/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters;

import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.PartEndEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.exception.UnsupportedFormatFeatureException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.AbstractNexusCommandEventReader;
import info.bioinfweb.jphyloio.utils.IDToNameManager;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MatrixReader
extends AbstractNexusCommandEventReader
implements NexusConstants,
ReadWriteConstants {
    private String currentSequenceLabel = null;
    private int currentSequenceIndex = 0;
    private long currentSequencePosition = 0L;
    private IDToNameManager idToNameManager = new IDToNameManager("seq");

    public MatrixReader(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super("MATRIX", new String[]{"CHARACTERS", "UNALIGNED", "DATA"}, nexusReaderStreamDataProvider);
    }

    private String readDelimitedToken(char c, char c2) throws IOException {
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        peekReader.skip(1L);
        char c3 = peekReader.peekChar();
        StringBuilder stringBuilder = new StringBuilder();
        while (c3 != c2) {
            if (c3 == '[') {
                peekReader.skip(1L);
                this.getStreamDataProvider().readComment();
            } else {
                stringBuilder.append(c3);
                peekReader.skip(1L);
            }
            c3 = peekReader.peekChar();
        }
        peekReader.skip(1L);
        return c + stringBuilder.toString() + c2;
    }

    private String readToken(boolean bl) throws IOException {
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        char c = peekReader.peekChar();
        if (!bl && c != '(' && c != '{') {
            return Character.toString(peekReader.readChar());
        }
        if (c == '(') {
            return this.readDelimitedToken('(', ')');
        }
        if (c == '{') {
            return this.readDelimitedToken('{', '}');
        }
        return this.getStreamDataProvider().readNexusWord();
    }

    @Override
    protected boolean doReadNextEvent() throws IOException {
        ParameterMap parameterMap = this.getStreamDataProvider().getSharedInformationMap();
        if (parameterMap.getBoolean("info.bioinfweb.jphyloio.nexus.transpose", false)) {
            throw new UnsupportedFormatFeatureException("Transposed Nexus matrices are currently not supported by JPhyloIO.", (StreamLocationProvider)this.getStreamDataProvider().getDataReader());
        }
        boolean bl = parameterMap.getBoolean("info.bioinfweb.jphyloio.nexus.tokens", false);
        boolean bl2 = parameterMap.getBoolean("info.bioinfweb.jphyloio.nexus.interleave", false);
        boolean bl3 = !parameterMap.getBoolean("info.bioinfweb.jphyloio.nexus.labels", true);
        long l = parameterMap.getLong("info.bioinfweb.jphyloio.nexus.ntax", Long.MAX_VALUE);
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        try {
            Object object;
            char c;
            if (this.currentSequenceLabel == null) {
                this.getStreamDataProvider().consumeWhiteSpaceAndComments();
            }
            if ((c = peekReader.peekChar()) == ';') {
                peekReader.skip(1L);
                this.setAllDataProcessed(true);
                return false;
            }
            if (this.currentSequenceLabel == null) {
                if (this.getStreamDataProvider().eventsUpcoming()) {
                    return true;
                }
                object = this.getStreamDataProvider().getCurrentLinkedBlockID("TAXA");
                if (bl3) {
                    if (object == null) {
                        throw new JPhyloIOReaderException("A MATRIX command with the NOLABELS option was found, but no preceding TAXA block is present", (StreamLocationProvider)this.getStreamDataProvider().getDataReader());
                    }
                    if (this.currentSequenceIndex >= this.getStreamDataProvider().getElementList(EventContentType.OTU, (String)object).size()) {
                        throw new JPhyloIOReaderException("A MATRIX command contains more sequences than defined in the TAXA block. This is invalid, if NOLABELS was specified. An alternative cause could be an invalid sequence length definition.", (StreamLocationProvider)this.getStreamDataProvider().getDataReader());
                    }
                    this.currentSequenceLabel = this.getStreamDataProvider().getElementList(EventContentType.OTU, (String)object).get(this.currentSequenceIndex);
                } else {
                    this.currentSequenceLabel = this.getStreamDataProvider().readNexusWord();
                }
                ++this.currentSequenceIndex;
                String string = null;
                if (object != null) {
                    string = this.getStreamDataProvider().getNexusNameToIDMap(EventContentType.OTU, (String)object).get(this.currentSequenceLabel);
                }
                this.getStreamDataProvider().getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.SEQUENCE, this.idToNameManager.getID(this.currentSequenceLabel), this.currentSequenceLabel, string));
                this.currentSequencePosition = 0L;
            }
            object = new ArrayList();
            c = peekReader.peekChar();
            boolean bl4 = false;
            boolean bl5 = false;
            while (c != ';' && object.size() < this.getStreamDataProvider().getParameters().getMaxTokensToRead() && !bl5) {
                if (c == ',' || bl2 && StringUtils.isNewLineChar((char)c) || this.currentSequencePosition >= l) {
                    if (c == ',') {
                        peekReader.skip(1L);
                    }
                    peekReader.consumeNewLine();
                    if (!object.isEmpty()) {
                        this.getStreamDataProvider().getCurrentEventCollection().add(this.getStreamDataProvider().getSequenceTokensEventManager().createEvent(this.currentSequenceLabel, (List<String>)object));
                        bl4 = true;
                    }
                    this.currentSequenceLabel = null;
                    bl5 = true;
                    this.getStreamDataProvider().getCurrentEventCollection().add(new PartEndEvent(EventContentType.SEQUENCE, !bl2 || this.getStreamDataProvider().getSequenceTokensEventManager().getCurrentPosition() >= l));
                } else {
                    if (c == '[') {
                        if (!object.isEmpty()) {
                            this.getStreamDataProvider().getCurrentEventCollection().add(this.getStreamDataProvider().getSequenceTokensEventManager().createEvent(this.currentSequenceLabel, (List<String>)object));
                        }
                        peekReader.skip(1L);
                        this.getStreamDataProvider().readComment();
                        return true;
                    }
                    if (Character.isWhitespace(c)) {
                        peekReader.skip(1L);
                    } else {
                        String string = this.readToken(bl);
                        if (!"".equals(string)) {
                            object.add(string);
                            ++this.currentSequencePosition;
                        }
                    }
                }
                c = peekReader.peekChar();
            }
            if (!object.isEmpty() && this.currentSequenceLabel != null) {
                this.getStreamDataProvider().getCurrentEventCollection().add(this.getStreamDataProvider().getSequenceTokensEventManager().createEvent(this.currentSequenceLabel, (List<String>)object));
                bl4 = true;
            }
            if (c == ';') {
                this.setAllDataProcessed(true);
                peekReader.skip(1L);
                if (this.currentSequenceLabel != null) {
                    this.getStreamDataProvider().getCurrentEventCollection().add(new PartEndEvent(EventContentType.SEQUENCE, true));
                }
            }
            return bl4;
        }
        catch (EOFException eOFException) {
            throw new JPhyloIOReaderException("Unexpected end of file in Nexus " + this.getCommandName() + " command.", (StreamLocationProvider)peekReader, (Throwable)eOFException);
        }
    }
}

