/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.all;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.AbstractNexusCommandEventReader;
import java.io.EOFException;
import java.io.IOException;

public class TitleReader
extends AbstractNexusCommandEventReader
implements NexusConstants,
ReadWriteConstants {
    public TitleReader(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super("TITLE", new String[0], nexusReaderStreamDataProvider);
    }

    @Override
    protected boolean doReadNextEvent() throws IOException {
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        try {
            this.getStreamDataProvider().consumeWhiteSpaceAndComments();
            String string = this.getStreamDataProvider().readNexusWord();
            this.getStreamDataProvider().getSharedInformationMap().put((Object)"info.bioinfweb.jphyloio.nexus.blockTitle", (Object)string);
            String string2 = this.getStreamDataProvider().getSharedInformationMap().getString("info.bioinfweb.jphyloio.nexus.currentBlockID");
            if (string2 != null) {
                this.getStreamDataProvider().getBlockTitleToIDMap().putID(this.getStreamDataProvider().getEventReader().getCurrentBlockName(), string, string2);
            }
            this.getStreamDataProvider().consumeWhiteSpaceAndComments();
            if (peekReader.readChar() == ';') {
                this.setAllDataProcessed(true);
                return false;
            }
            throw new JPhyloIOReaderException("Expected end of Nexus TITLE command.", (StreamLocationProvider)peekReader);
        }
        catch (EOFException eOFException) {
            throw new JPhyloIOReaderException("Unexpected end of file in " + this.getCommandName() + " command.", (StreamLocationProvider)peekReader);
        }
    }
}

