/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.all;

import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.AbstractKeyValueCommandReader;
import info.bioinfweb.jphyloio.formats.text.KeyValueInformation;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;

public class LinkReader
extends AbstractKeyValueCommandReader
implements NexusConstants {
    private static final Set<String> BLOCK_NAMES_WITH_EVENTS = LinkReader.createBlockNamesWithEvents();

    private static Set<String> createBlockNamesWithEvents() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("TAXA");
        treeSet.add("CHARACTERS");
        treeSet.add("DATA");
        treeSet.add("UNALIGNED");
        treeSet.add("TREES");
        return treeSet;
    }

    public LinkReader(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super("LINK", new String[0], nexusReaderStreamDataProvider);
    }

    @Override
    protected boolean processSubcommand(KeyValueInformation keyValueInformation) throws IOException {
        String string;
        String string2 = keyValueInformation.getValue();
        if (!keyValueInformation.wasValueDelimited()) {
            string2 = string2.replace('_', ' ');
        }
        if (BLOCK_NAMES_WITH_EVENTS.contains(string = keyValueInformation.getOriginalKey().toUpperCase())) {
            String string3 = string2;
            string2 = this.getStreamDataProvider().getBlockTitleToIDMap().getID(string, string2);
            if (string2 == null) {
                throw new JPhyloIOReaderException("The linked Nexus " + string + " block with the label \"" + string3 + "\" was not previously declared unsing a TITLE command.", (StreamLocationProvider)this.getStreamDataProvider().getDataReader());
            }
        }
        this.getStreamDataProvider().getBlockLinks().put(string, string2);
        return false;
    }

    @Override
    protected boolean addStoredEvents() {
        return false;
    }
}

