/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.AbstractNexusCommandEventReader;
import info.bioinfweb.jphyloio.formats.text.KeyValueInformation;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractKeyValueCommandReader
extends AbstractNexusCommandEventReader
implements NexusConstants {
    public AbstractKeyValueCommandReader(String string, String[] stringArray, NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super(string, stringArray, nexusReaderStreamDataProvider);
    }

    protected abstract boolean processSubcommand(KeyValueInformation var1) throws IOException;

    protected abstract boolean addStoredEvents();

    @Override
    protected boolean doReadNextEvent() throws IOException {
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        try {
            while (peekReader.peekChar() != ';') {
                this.getStreamDataProvider().consumeWhiteSpaceAndComments();
                KeyValueInformation keyValueInformation = this.getStreamDataProvider().readKeyValueMetaInformation();
                if (!this.processSubcommand(keyValueInformation)) continue;
                return true;
            }
            boolean bl = this.addStoredEvents();
            peekReader.skip(1L);
            this.setAllDataProcessed(true);
            return bl;
        }
        catch (EOFException eOFException) {
            throw new JPhyloIOReaderException("Unexpected end of file in Nexus " + this.getCommandName() + " command.", (StreamLocationProvider)peekReader, (Throwable)eOFException);
        }
    }
}

