/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.blockhandlers;

import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.blockhandlers.AbstractNexusBlockHandler;
import info.bioinfweb.jphyloio.formats.nexus.blockhandlers.NexusBlockHandler;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.NexusCommandEventReader;

public class TreesBlockHandler
extends AbstractNexusBlockHandler
implements NexusBlockHandler,
NexusConstants,
ReadWriteConstants {
    public TreesBlockHandler() {
        super(new String[]{"TREES"});
    }

    protected TreesBlockHandler(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void handleBegin(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        nexusReaderStreamDataProvider.getTreesTranslationTable().clear();
        nexusReaderStreamDataProvider.getSharedInformationMap().put((Object)"info.bioinfweb.jphyloio.nexus.currentBlockID", (Object)("treesOrNetworks" + nexusReaderStreamDataProvider.getIDManager().createNewID()));
    }

    @Override
    public void handleEnd(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        nexusReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.TREE_NETWORK_GROUP));
        nexusReaderStreamDataProvider.getTreesTranslationTable().clear();
    }

    protected String getStartTriggerCommand() {
        return "TREE";
    }

    protected String getBlockName() {
        return "TREES";
    }

    @Override
    public void beforeCommand(NexusReaderStreamDataProvider nexusReaderStreamDataProvider, String string, NexusCommandEventReader nexusCommandEventReader) {
        ParameterMap parameterMap = nexusReaderStreamDataProvider.getSharedInformationMap();
        if (!parameterMap.getBoolean("info.bioinfweb.jphyloio.nexus.blockStartEventFired", false) && string.equals(this.getStartTriggerCommand())) {
            String string2 = parameterMap.getString("info.bioinfweb.jphyloio.nexus.currentBlockID");
            nexusReaderStreamDataProvider.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.TREE_NETWORK_GROUP, string2, parameterMap.getString("info.bioinfweb.jphyloio.nexus.blockTitle"), nexusReaderStreamDataProvider.getCurrentLinkedBlockID("TAXA")));
            if (!nexusReaderStreamDataProvider.getBlockTitleToIDMap().hasDefaultBlockID(this.getBlockName())) {
                nexusReaderStreamDataProvider.getBlockTitleToIDMap().putDefaultBlockID(this.getBlockName(), string2);
            }
            parameterMap.put((Object)"info.bioinfweb.jphyloio.nexus.blockStartEventFired", (Object)true);
        }
    }
}

