/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.blockhandlers;

import info.bioinfweb.jphyloio.formats.nexus.blockhandlers.CharactersDataUnalignedBlockHandler;
import info.bioinfweb.jphyloio.formats.nexus.blockhandlers.NexusBlockHandler;
import info.bioinfweb.jphyloio.formats.nexus.blockhandlers.TaxaBlockHandler;
import info.bioinfweb.jphyloio.formats.nexus.blockhandlers.TreesBlockHandler;
import java.util.HashMap;
import java.util.Map;

public class NexusBlockHandlerMap {
    private Map<String, NexusBlockHandler> handlers = new HashMap<String, NexusBlockHandler>();

    public static NexusBlockHandlerMap newJPhyloIOInstance() {
        NexusBlockHandlerMap nexusBlockHandlerMap = new NexusBlockHandlerMap();
        nexusBlockHandlerMap.addJPhyloIOHandlers();
        return nexusBlockHandlerMap;
    }

    public void addHandler(NexusBlockHandler nexusBlockHandler) {
        for (String string : nexusBlockHandler.getBlockNames()) {
            this.handlers.put(string.toUpperCase(), nexusBlockHandler);
        }
    }

    public void addJPhyloIOHandlers() {
        this.addHandler(new TaxaBlockHandler());
        this.addHandler(new CharactersDataUnalignedBlockHandler());
        this.addHandler(new TreesBlockHandler());
    }

    public NexusBlockHandler getHandler(String string) {
        return this.handlers.get(string.toUpperCase());
    }

    public boolean hasHandler(String string) {
        return this.handlers.containsKey(string.toUpperCase());
    }
}

