/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus;

import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusEventReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.all.BlockTitleToIDMap;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.trees.NexusTranslationTable;
import info.bioinfweb.jphyloio.formats.text.KeyValueInformation;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NexusReaderStreamDataProvider
extends TextReaderStreamDataProvider<NexusEventReader>
implements NexusConstants {
    public static final String INFO_KEY_BLOCK_START_EVENT_FIRED = "info.bioinfweb.jphyloio.nexus.blockStartEventFired";
    public static final String INFO_KEY_CURRENT_BLOCK_ID = "info.bioinfweb.jphyloio.nexus.currentBlockID";
    public static final String INFO_KEY_BLOCK_TITLE = "info.bioinfweb.jphyloio.nexus.blockTitle";
    public static final String INFO_KEY_BLOCK_LINKS = "info.bioinfweb.jphyloio.nexus.blockLinks";
    public static final String INFO_KEY_BLOCK_ID_MAP = "info.bioinfweb.jphyloio.nexus.taxa.blockTitleToIDMap";
    public static final String INFO_KEY_ELEMENT_LIST = "info.bioinfweb.jphyloio.nexus.elementlist";
    public static final String INFO_KEY_NEXUS_NAME_TO_ID_MAP = "info.bioinfweb.jphyloio.nexus.nameToIDMap";
    public static final String INFO_CHARACTER_NAME_TO_INDEX_MAP = "info.bioinfweb.jphyloio.nexus.characters.characterNameToIndexMap";
    public static final String INFO_KEY_TREES_TRANSLATION = "info.bioinfweb.jphyloio.nexus.trees.translate";
    public static final String INFO_KEY_MATRIX_WIDTHS_MAP = "info.bioinfweb.jphyloio.nexus.matrixWidths";
    private ParameterMap sharedInformationMap = new ParameterMap();

    public NexusReaderStreamDataProvider(NexusEventReader nexusEventReader) {
        super(nexusEventReader);
    }

    @Override
    public NexusEventReader getEventReader() {
        return (NexusEventReader)super.getEventReader();
    }

    public void consumeWhiteSpaceAndComments() throws IOException {
        this.getEventReader().consumeWhiteSpaceAndComments();
    }

    public String readNexusWord() throws IOException {
        return this.getEventReader().readNexusWord();
    }

    public long readPositiveInteger(long l) throws IOException {
        return this.getEventReader().readPositiveInteger(l);
    }

    public void readComment() throws IOException {
        this.getEventReader().readComment();
    }

    public KeyValueInformation readKeyValueMetaInformation() throws IOException {
        return this.getEventReader().readKeyValueMetaInformation();
    }

    public ParameterMap getSharedInformationMap() {
        return this.sharedInformationMap;
    }

    public Map<String, String> getBlockLinks() {
        TreeMap treeMap = (TreeMap)this.getSharedInformationMap().get((Object)INFO_KEY_BLOCK_LINKS);
        if (treeMap == null) {
            treeMap = new TreeMap();
            this.getSharedInformationMap().put((Object)INFO_KEY_BLOCK_LINKS, treeMap);
        }
        return treeMap;
    }

    public String getMatrixLink() {
        Map<String, String> map = this.getBlockLinks();
        String string = map.get("CHARACTERS");
        if (string == null && (string = map.get("DATA")) == null && (string = map.get("UNALIGNED")) == null && (string = this.getBlockTitleToIDMap().getDefaultBlockID("CHARACTERS")) == null && (string = this.getBlockTitleToIDMap().getDefaultBlockID("DATA")) == null) {
            string = this.getBlockTitleToIDMap().getDefaultBlockID("UNALIGNED");
        }
        return string;
    }

    public void clearBlockInformation() {
        this.getSharedInformationMap().remove((Object)INFO_KEY_BLOCK_TITLE);
        this.getSharedInformationMap().remove((Object)INFO_KEY_BLOCK_LINKS);
        this.getSharedInformationMap().remove((Object)INFO_KEY_CURRENT_BLOCK_ID);
        this.getSharedInformationMap().remove((Object)INFO_KEY_BLOCK_START_EVENT_FIRED);
    }

    public Map<?, ?> getMap(String string) {
        HashMap hashMap = (HashMap)this.getSharedInformationMap().get((Object)string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.getSharedInformationMap().put((Object)string, hashMap);
        }
        return hashMap;
    }

    public BlockTitleToIDMap getBlockTitleToIDMap() {
        BlockTitleToIDMap blockTitleToIDMap = (BlockTitleToIDMap)this.getSharedInformationMap().getObject(INFO_KEY_BLOCK_ID_MAP, null, BlockTitleToIDMap.class);
        if (blockTitleToIDMap == null) {
            blockTitleToIDMap = new BlockTitleToIDMap();
            this.getSharedInformationMap().put((Object)INFO_KEY_BLOCK_ID_MAP, (Object)blockTitleToIDMap);
        }
        return blockTitleToIDMap;
    }

    public String getCurrentLinkedBlockID(String string) {
        String string2 = this.getBlockLinks().get(string);
        if (string2 == null) {
            string2 = this.getBlockTitleToIDMap().getDefaultBlockID(string);
        }
        return string2;
    }

    public List<String> getElementList(EventContentType eventContentType, String string) {
        if (string == null) {
            throw new NullPointerException("The specified listID must not be null.");
        }
        String string2 = "info.bioinfweb.jphyloio.nexus.elementlist." + eventContentType.toString() + "." + string;
        ArrayList arrayList = (ArrayList)this.getSharedInformationMap().get((Object)string2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.getSharedInformationMap().put((Object)string2, arrayList);
        }
        return arrayList;
    }

    public Map<String, String> getNexusNameToIDMap(EventContentType eventContentType, String string) {
        if (string == null) {
            throw new NullPointerException("The specified listID must not be null.");
        }
        return this.getMap("info.bioinfweb.jphyloio.nexus.nameToIDMap." + eventContentType.toString() + "." + string);
    }

    public NexusTranslationTable getTreesTranslationTable() {
        NexusTranslationTable nexusTranslationTable = (NexusTranslationTable)this.getSharedInformationMap().get((Object)INFO_KEY_TREES_TRANSLATION);
        if (nexusTranslationTable == null) {
            nexusTranslationTable = new NexusTranslationTable();
            this.getSharedInformationMap().put((Object)INFO_KEY_TREES_TRANSLATION, (Object)nexusTranslationTable);
        }
        return nexusTranslationTable;
    }

    public Map<String, Long> getMatrixWidthsMap() {
        return this.getMap(INFO_KEY_MATRIX_WIDTHS_MAP);
    }
}

