/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus;

import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.OTUListDataAdapter;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.formats.newick.DefaultNewickWriterNodeLabelProcessor;
import info.bioinfweb.jphyloio.utils.LabelEditingReporter;
import java.util.Map;

public class NexusNewickWriterNodeLabelProcessor
extends DefaultNewickWriterNodeLabelProcessor {
    private Map<String, Long> indexMap;

    public NexusNewickWriterNodeLabelProcessor(OTUListDataAdapter oTUListDataAdapter, Map<String, Long> map, ReadWriteParameterMap readWriteParameterMap) {
        super(oTUListDataAdapter, readWriteParameterMap);
        this.indexMap = map;
    }

    @Override
    public String createNodeName(LinkedLabeledIDEvent linkedLabeledIDEvent) {
        String string;
        LabelEditingReporter labelEditingReporter = this.getParameters().getLabelEditingReporter();
        if (this.indexMap != null && linkedLabeledIDEvent.hasLink()) {
            Long l = this.indexMap.get(linkedLabeledIDEvent.getLinkedID());
            if (l == null) {
                throw new InconsistentAdapterDataException("Error when writing tree: The node with the ID " + linkedLabeledIDEvent.getID() + " references an OTU with the ID " + linkedLabeledIDEvent.getLinkedID() + ", which could not be found in the OTU list associated with this tree.");
            }
            string = l.toString();
            labelEditingReporter.addEdit(linkedLabeledIDEvent, labelEditingReporter.getEditedLabel(EventContentType.OTU, linkedLabeledIDEvent.getLinkedID()));
        } else {
            string = AbstractEventWriter.getLinkedOTUNameOTUFirst(linkedLabeledIDEvent, this.getOTUList(), this.getParameters());
            labelEditingReporter.addEdit(linkedLabeledIDEvent, string);
        }
        return string;
    }
}

