/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.AnnotatedDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.DocumentDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.ElementDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.MatrixDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.OTUListDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.ObjectListDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.TreeNetworkDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.TreeNetworkGroupDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.implementations.receivers.BasicEventReceiver;
import info.bioinfweb.jphyloio.events.CharacterDefinitionEvent;
import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.TokenSetDefinitionEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.formats.newick.NewickStringWriter;
import info.bioinfweb.jphyloio.formats.nexus.AbstractNexusSetWriter;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusMatrixWriteResult;
import info.bioinfweb.jphyloio.formats.nexus.NexusNewickWriterNodeLabelProcessor;
import info.bioinfweb.jphyloio.formats.nexus.NexusWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.receivers.CharacterSetEventReceiver;
import info.bioinfweb.jphyloio.formats.nexus.receivers.ReferenceOnlySetReceiver;
import info.bioinfweb.jphyloio.formats.nexus.receivers.TokenSetEventReceiver;
import info.bioinfweb.jphyloio.formats.text.AbstractTextEventWriter;
import info.bioinfweb.jphyloio.formats.text.TextSequenceContentReceiver;
import info.bioinfweb.jphyloio.formats.text.TextWriterStreamDataProvider;
import info.bioinfweb.jphyloio.utils.LabelEditingReporter;
import java.io.IOException;
import java.io.Writer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NexusEventWriter
extends AbstractTextEventWriter<NexusWriterStreamDataProvider>
implements NexusConstants {
    private static final String UNDEFINED_OTUS_ID = "\n";
    private ReadWriteParameterMap parameters;
    private ApplicationLogger logger;
    private Map<String, NexusMatrixWriteResult> matrixIDToBlockTypeMap = new HashMap<String, NexusMatrixWriteResult>(8);

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.nexus";
    }

    @Override
    protected NexusWriterStreamDataProvider createStreamDataProvider() {
        return new NexusWriterStreamDataProvider(this);
    }

    protected ReadWriteParameterMap getParameters() {
        return this.parameters;
    }

    protected ApplicationLogger getLogger() {
        return this.logger;
    }

    protected Map<String, NexusMatrixWriteResult> getMatrixIDToBlockTypeMap() {
        return this.matrixIDToBlockTypeMap;
    }

    @Override
    protected void writeLineStart(Writer writer, String string) throws IOException {
        super.writeLineStart(writer, string);
    }

    private void writeInitialLines() throws IOException {
        this.getWriter().write("#NEXUS");
        NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
        this.getWriter().write(91);
        this.getWriter().write(this.getFileStartInfo(this.parameters));
        this.getWriter().write(93);
        NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
    }

    private void logIgnoredMetadata(AnnotatedDataAdapter annotatedDataAdapter, String string) {
    }

    private void logMultipleBlocksWarning(String string, String string2) {
        this.logger.addWarning("This document contains more than one " + string + ". Therefore multiple " + string2 + " blocks have been written into the Nexus output. Not all programs may be able to process Nexus files with multiple blocks of the same type.");
    }

    public static String formatToken(String string) {
        return NewickStringWriter.formatToken(string, '\'');
    }

    protected void writeCommandEnd() throws IOException {
        this.getWriter().write(59);
        NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
    }

    protected void writeBlockStart(String string) throws IOException {
        NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
        this.writeLineStart(this.getWriter(), "BEGIN");
        this.getWriter().write(32);
        this.getWriter().write(string);
        this.writeCommandEnd();
        this.increaseIndention();
    }

    protected void writeBlockEnd() throws IOException {
        this.decreaseIndention();
        this.writeLineStart(this.getWriter(), "END");
        this.writeCommandEnd();
    }

    private void writeKeyValueExpression(String string, String string2) throws IOException {
        NexusEventWriter.writeKeyValueExpression(this.getWriter(), string, string2);
    }

    public static void writeKeyValueExpression(Writer writer, String string, String string2) throws IOException {
        writer.write(string);
        writer.write(61);
        writer.write(string2);
    }

    private void writeTitleCommand(String string) throws IOException {
        this.writeLineStart(this.getWriter(), "TITLE");
        this.getWriter().write(32);
        this.getWriter().write(NexusEventWriter.formatToken(string));
        this.writeCommandEnd();
    }

    private void writeTitleCommand(LabeledIDEvent labeledIDEvent) throws IOException {
        String string = NexusEventWriter.createUniqueLabel(this.parameters, labeledIDEvent);
        this.writeTitleCommand(string);
        this.parameters.getLabelEditingReporter().addEdit(labeledIDEvent, string);
    }

    protected void writeLinkCommand(String string, String string2, EventContentType eventContentType) throws IOException {
        this.writeLineStart(this.getWriter(), "LINK");
        this.getWriter().write(32);
        this.getWriter().write(string2);
        this.getWriter().write(61);
        this.getWriter().write(NexusEventWriter.formatToken(this.parameters.getLabelEditingReporter().getEditedLabel(eventContentType, string)));
        this.writeCommandEnd();
    }

    private void writeLinkCommand(LinkedLabeledIDEvent linkedLabeledIDEvent, String string, EventContentType eventContentType) throws IOException {
        if (linkedLabeledIDEvent.hasLink()) {
            this.writeLinkCommand(linkedLabeledIDEvent.getLinkedID(), string, eventContentType);
        }
    }

    private void writeTaxaBlock(OTUListDataAdapter oTUListDataAdapter) throws IOException {
        this.logIgnoredMetadata(oTUListDataAdapter, "Metadata attached to an OTU list have been ignored.");
        if (oTUListDataAdapter.getCount(this.getParameters()) > 0L) {
            this.writeBlockStart("TAXA");
            this.writeTitleCommand((LabeledIDEvent)oTUListDataAdapter.getStartEvent(this.parameters));
            this.writeLineStart(this.getWriter(), "DIMENSIONS");
            this.getWriter().write(32);
            this.writeKeyValueExpression("NTAX", Long.toString(oTUListDataAdapter.getCount(this.getParameters())));
            this.writeCommandEnd();
            this.writeLineStart(this.getWriter(), "TAXLABELS");
            NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
            this.increaseIndention();
            this.increaseIndention();
            BasicEventReceiver basicEventReceiver = new BasicEventReceiver(this.getStreamDataProvider(), this.parameters);
            Iterator<String> iterator = oTUListDataAdapter.getIDIterator(this.getParameters());
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.writeLineStart(this.getWriter(), NexusEventWriter.formatToken(NexusEventWriter.createUniqueLabel(this.parameters, (LabeledIDEvent)oTUListDataAdapter.getObjectStartEvent(this.getParameters(), string))));
                if (iterator.hasNext()) {
                    NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
                } else {
                    this.writeCommandEnd();
                }
                oTUListDataAdapter.writeContentData(this.getParameters(), basicEventReceiver, string);
            }
            basicEventReceiver.addIgnoreLogMessage(this.logger, "one or more OTUs", "Nexus");
            this.decreaseIndention();
            this.decreaseIndention();
            this.writeBlockEnd();
        } else {
            this.logger.addWarning("The document contained an emtpty OTU list, which has been ignored.");
        }
    }

    private void writeTaxaBlocks(DocumentDataAdapter documentDataAdapter) throws IOException {
        Iterator<OTUListDataAdapter> iterator = documentDataAdapter.getOTUListIterator(this.getParameters());
        if (iterator.hasNext()) {
            this.writeTaxaBlock(iterator.next());
            if (iterator.hasNext()) {
                this.logMultipleBlocksWarning("OTU list", "TAXA");
                do {
                    this.writeTaxaBlock(iterator.next());
                } while (iterator.hasNext());
            }
        } else {
            this.logger.addWarning("This document contains no OTU list. Therefore no TAXA block can be written to the Nexus document. Some programs may not be able to read Nexus files without a TAXA block.");
        }
    }

    private boolean containsInvalidOTULinks(MatrixDataAdapter matrixDataAdapter) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<String> iterator = matrixDataAdapter.getSequenceIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            LinkedLabeledIDEvent linkedLabeledIDEvent = matrixDataAdapter.getSequenceStartEvent(this.getParameters(), iterator.next());
            if (linkedLabeledIDEvent.hasLink()) {
                if (hashSet.contains(linkedLabeledIDEvent.getLinkedID())) {
                    return true;
                }
                hashSet.add(linkedLabeledIDEvent.getLinkedID());
                continue;
            }
            return true;
        }
        return false;
    }

    private void writeMatrixDimensionsCommand(MatrixDataAdapter matrixDataAdapter, long l) throws IOException {
        this.writeLineStart(this.getWriter(), "DIMENSIONS");
        this.getWriter().write(32);
        if (this.containsInvalidOTULinks(matrixDataAdapter)) {
            this.getWriter().write("NEWTAXA");
            this.getWriter().write(32);
        }
        this.writeKeyValueExpression("NTAX", Long.toString(matrixDataAdapter.getSequenceCount(this.getParameters())));
        if (l != -1L) {
            this.getWriter().write(32);
            this.writeKeyValueExpression("NCHAR", Long.toString(l));
        }
        this.writeCommandEnd();
    }

    private void writeFormatCommand(MatrixDataAdapter matrixDataAdapter) throws IOException {
        ObjectListDataAdapter<TokenSetDefinitionEvent> objectListDataAdapter = matrixDataAdapter.getTokenSets(this.getParameters());
        long l = objectListDataAdapter.getCount(this.getParameters());
        if (l > 0L) {
            String string;
            this.writeLineStart(this.getWriter(), "FORMAT");
            Iterator<String> iterator = objectListDataAdapter.getIDIterator(this.getParameters());
            TokenSetEventReceiver tokenSetEventReceiver = new TokenSetEventReceiver((NexusWriterStreamDataProvider)this.getStreamDataProvider());
            String string2 = iterator.next();
            switch (objectListDataAdapter.getObjectStartEvent(this.getParameters(), string2).asTokenSetDefinitionEvent().getSetType()) {
                case DISCRETE: {
                    string = "STANDARD";
                    break;
                }
                case NUCLEOTIDE: {
                    string = "NUCLEOTIDE";
                    break;
                }
                case DNA: {
                    string = "DNA";
                    break;
                }
                case RNA: {
                    string = "RNA";
                    break;
                }
                case AMINO_ACID: {
                    string = "PROTEIN";
                    break;
                }
                case CONTINUOUS: {
                    string = "CONTINUOUS";
                    break;
                }
                default: {
                    string = null;
                }
            }
            if (string != null) {
                this.getWriter().write(32);
                NexusEventWriter.writeKeyValueExpression(this.getWriter(), "DATATYPE", string);
            }
            objectListDataAdapter.writeContentData(this.getParameters(), tokenSetEventReceiver, string2);
            if (tokenSetEventReceiver.getSingleTokens() != null) {
                this.getWriter().write(32);
                this.writeKeyValueExpression("SYMBOLS", '\"' + tokenSetEventReceiver.getSingleTokens() + '\"');
            }
            if (tokenSetEventReceiver.getIgnoredMetadata() > 0L) {
                this.logger.addWarning("A token definition of a character matrix contained metadata which has been ignored, since the Nexus format does not support writing such data.");
            }
            this.getWriter().write(32);
            if (matrixDataAdapter.containsLongTokens(this.getParameters())) {
                this.getWriter().write("TOKENS");
            } else {
                this.getWriter().write("NOTOKENS");
            }
            this.writeCommandEnd();
            if (l > 1L) {
                this.getParameters().getLogger().addWarning("Multiple token sets where provided for a matrix. Only the first one was considered.");
            }
        }
    }

    private void writeMatrixTaxLabelsCommand(MatrixDataAdapter matrixDataAdapter) throws IOException {
        final LabelEditingReporter labelEditingReporter = this.parameters.getLabelEditingReporter();
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<String> iterator = matrixDataAdapter.getSequenceIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            String string;
            LinkedLabeledIDEvent linkedLabeledIDEvent = matrixDataAdapter.getSequenceStartEvent(this.getParameters(), iterator.next());
            boolean bl2 = false;
            if (linkedLabeledIDEvent.hasLink()) {
                if (hashSet.contains(linkedLabeledIDEvent.getLinkedID())) {
                    bl2 = true;
                } else {
                    hashSet.add(linkedLabeledIDEvent.getLinkedID());
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                if (!bl) {
                    this.writeLineStart(this.getWriter(), "TAXLABELS");
                    NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
                    this.increaseIndention();
                    this.increaseIndention();
                    bl = true;
                } else {
                    NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
                }
                string = NexusEventWriter.createUniqueLabel(this.parameters, new AbstractEventWriter.NoEditUniqueLabelHandler(){

                    @Override
                    public boolean isUnique(String string) {
                        return !labelEditingReporter.isLabelUsed(EventContentType.OTU, string) && !labelEditingReporter.isLabelUsed(EventContentType.SEQUENCE, string);
                    }
                }, linkedLabeledIDEvent);
                this.writeLineStart(this.getWriter(), NexusEventWriter.formatToken(string));
            } else {
                string = labelEditingReporter.getEditedLabel(EventContentType.OTU, linkedLabeledIDEvent.getLinkedID());
                if (string == null) {
                    throw new InconsistentAdapterDataException("The sequence with the ID " + linkedLabeledIDEvent.getID() + " is referencing an OTU with the ID " + linkedLabeledIDEvent.getLinkedID() + " which could not be found.");
                }
            }
            labelEditingReporter.addEdit(linkedLabeledIDEvent, string);
        }
        if (bl) {
            this.writeCommandEnd();
            this.writeLineStart(this.getWriter(), "[");
            this.getWriter().write("These additional taxon definitions were automatically added by JPhyloIO, because sequences without linked taxa had to be written or more than one sequence was linked to the same taxon (which is both invalid in Nexus).");
            this.getWriter().write(93);
            NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
            this.decreaseIndention();
            this.decreaseIndention();
        }
    }

    private void writeCharStateLabelsCommand(MatrixDataAdapter matrixDataAdapter) throws IOException {
        ObjectListDataAdapter<CharacterDefinitionEvent> objectListDataAdapter = matrixDataAdapter.getCharacterDefinitions(this.getParameters());
        Iterator<String> iterator = objectListDataAdapter.getIDIterator(this.getParameters());
        if (iterator.hasNext()) {
            this.writeLineStart(this.getWriter(), "CHARSTATELABELS");
            NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
            this.increaseIndention();
            this.increaseIndention();
            while (iterator.hasNext()) {
                CharacterDefinitionEvent characterDefinitionEvent = objectListDataAdapter.getObjectStartEvent(this.getParameters(), iterator.next());
                String string = NexusEventWriter.createUniqueLabel(this.parameters, characterDefinitionEvent);
                this.parameters.getLabelEditingReporter().addEdit(characterDefinitionEvent, string);
                this.writeLineStart(this.getWriter(), characterDefinitionEvent.getIndex() + " " + string);
                if (!iterator.hasNext()) continue;
                this.getWriter().write(44);
                NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
            }
            this.decreaseIndention();
            this.decreaseIndention();
            this.writeCommandEnd();
        }
    }

    private void writeMatrixCommand(DocumentDataAdapter documentDataAdapter, MatrixDataAdapter matrixDataAdapter, long l, String string) throws IOException {
        LabelEditingReporter labelEditingReporter = this.parameters.getLabelEditingReporter();
        this.writeLineStart(this.getWriter(), "MATRIX");
        NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
        this.increaseIndention();
        this.increaseIndention();
        Iterator<String> iterator = matrixDataAdapter.getSequenceIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            String string3 = labelEditingReporter.getEditedLabel(EventContentType.SEQUENCE, string2);
            if (string3 == null) {
                throw new InternalError("Writing TAXLABELS and MATRIX command is not consistent.");
            }
            this.writeLineStart(this.getWriter(), NexusEventWriter.formatToken(string3));
            this.getWriter().write(32);
            TextSequenceContentReceiver<TextWriterStreamDataProvider> textSequenceContentReceiver = new TextSequenceContentReceiver<TextWriterStreamDataProvider>((TextWriterStreamDataProvider)this.getStreamDataProvider(), this.parameters, matrixDataAdapter.containsLongTokens(this.getParameters()), "[", "]");
            matrixDataAdapter.writeSequencePartContentData(this.getParameters(), textSequenceContentReceiver, string2, 0L, matrixDataAdapter.getSequenceLength(this.getParameters(), string2));
            if (textSequenceContentReceiver.didIgnoreMetadata()) {
                this.logger.addWarning(textSequenceContentReceiver.getIgnoredMetadata() + " metadata events nested inside the sequence \"" + string3 + "\" have been ignored, since the Nexus format does not supprt such data.");
            }
            if (string != null) {
                long l2 = l - matrixDataAdapter.getSequenceLength(this.getParameters(), string2);
                for (long i = 0L; i < l2; ++i) {
                    if (matrixDataAdapter.containsLongTokens(this.getParameters())) {
                        this.getWriter().write(32);
                    }
                    this.getWriter().write(string);
                }
            }
            if (iterator.hasNext()) {
                if (l == -1L) {
                    this.getWriter().write(44);
                }
                NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
                continue;
            }
            this.writeCommandEnd();
        }
        this.decreaseIndention();
        this.decreaseIndention();
    }

    private NexusMatrixWriteResult writeCharactersUnalignedBlock(DocumentDataAdapter documentDataAdapter, MatrixDataAdapter matrixDataAdapter, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        this.logIgnoredMetadata(matrixDataAdapter, "A character matrix");
        if (matrixDataAdapter.getSequenceCount(this.getParameters()) > 0L) {
            NexusMatrixWriteResult nexusMatrixWriteResult;
            long l = matrixDataAdapter.getColumnCount(this.getParameters());
            String string = readWriteParameterMap.getString("info.bioinfweb.jphyloio.sequenceExtensionToken");
            if (l == -1L && string != null) {
                l = NexusEventWriter.determineMaxSequenceLength(matrixDataAdapter, readWriteParameterMap);
            }
            if (l == -1L) {
                nexusMatrixWriteResult = NexusMatrixWriteResult.UNALIGNED;
                this.writeBlockStart("UNALIGNED");
            } else {
                nexusMatrixWriteResult = NexusMatrixWriteResult.CHARACTERS;
                this.writeBlockStart("CHARACTERS");
            }
            LinkedLabeledIDEvent linkedLabeledIDEvent = (LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(readWriteParameterMap);
            this.writeTitleCommand(linkedLabeledIDEvent);
            this.writeLinkCommand(linkedLabeledIDEvent, "TAXA", EventContentType.OTU_LIST);
            this.writeMatrixDimensionsCommand(matrixDataAdapter, l);
            this.writeFormatCommand(matrixDataAdapter);
            this.writeMatrixTaxLabelsCommand(matrixDataAdapter);
            this.writeCharStateLabelsCommand(matrixDataAdapter);
            this.writeMatrixCommand(documentDataAdapter, matrixDataAdapter, l, string);
            this.writeBlockEnd();
            this.matrixIDToBlockTypeMap.put(((LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(readWriteParameterMap)).getID(), nexusMatrixWriteResult);
            return nexusMatrixWriteResult;
        }
        this.logger.addWarning("The document contained an emtpty character matrix, which has been ignored.");
        return NexusMatrixWriteResult.NONE;
    }

    private void writeCharactersUnalignedBlocks(DocumentDataAdapter documentDataAdapter, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        Iterator<MatrixDataAdapter> iterator = documentDataAdapter.getMatrixIterator(this.getParameters());
        block4: while (iterator.hasNext()) {
            switch (this.writeCharactersUnalignedBlock(documentDataAdapter, iterator.next(), readWriteParameterMap)) {
                case CHARACTERS: {
                    bl = true;
                    continue block4;
                }
                case UNALIGNED: {
                    bl2 = true;
                    continue block4;
                }
            }
        }
        if (bl) {
            this.logMultipleBlocksWarning("aligned matrix", "CHARACTERS");
        }
        if (bl2) {
            this.logMultipleBlocksWarning("unaligned matrix", "UNALIGNED");
        }
    }

    private String getOTUsIDForTreeGroup(LinkedLabeledIDEvent linkedLabeledIDEvent) {
        if (linkedLabeledIDEvent.hasLink()) {
            return linkedLabeledIDEvent.getLinkedID();
        }
        return UNDEFINED_OTUS_ID;
    }

    private String createUniqueTreeLabel(LabeledIDEvent labeledIDEvent, final Set<String> set) {
        String string = NexusEventWriter.createUniqueLabel(this.parameters, new AbstractEventWriter.NoEditUniqueLabelHandler(){

            @Override
            public boolean isUnique(String string) {
                return !set.contains(string);
            }
        }, labeledIDEvent);
        set.add(string);
        return string;
    }

    private Map<String, Long> createOTUIndexMap(OTUListDataAdapter oTUListDataAdapter) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        long l = 1L;
        Iterator<String> iterator = oTUListDataAdapter.getIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            hashMap.put(iterator.next(), l);
            ++l;
        }
        return hashMap;
    }

    private void writeTranslateCommand(Map<String, Long> map) throws IOException {
        if (!map.isEmpty()) {
            LabelEditingReporter labelEditingReporter = this.parameters.getLabelEditingReporter();
            this.writeLineStart(this.getWriter(), "TRANSLATE");
            NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
            this.increaseIndention();
            this.increaseIndention();
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.writeLineStart(this.getWriter(), map.get(string).toString());
                this.getWriter().write(32);
                String string2 = labelEditingReporter.getEditedLabel(EventContentType.OTU, string);
                if (string2 == null) {
                    throw new InternalError("No label definition found for OTU ID " + string + ".");
                }
                this.getWriter().write(NexusEventWriter.formatToken(string2));
                if (iterator.hasNext()) {
                    this.getWriter().write(44);
                    NexusEventWriter.writeLineBreak(this.getWriter(), this.parameters);
                    continue;
                }
                this.writeCommandEnd();
            }
            this.decreaseIndention();
            this.decreaseIndention();
        }
    }

    private void writeTreesBlocks(DocumentDataAdapter documentDataAdapter) throws IOException {
        long l = 0L;
        Iterator<TreeNetworkGroupDataAdapter> iterator = documentDataAdapter.getTreeNetworkGroupIterator(this.getParameters());
        while (iterator.hasNext()) {
            TreeNetworkGroupDataAdapter treeNetworkGroupDataAdapter = iterator.next();
            LinkedLabeledIDEvent linkedLabeledIDEvent = (LinkedLabeledIDEvent)treeNetworkGroupDataAdapter.getStartEvent(this.parameters);
            String string = this.getOTUsIDForTreeGroup(linkedLabeledIDEvent);
            OTUListDataAdapter oTUListDataAdapter = null;
            if (!UNDEFINED_OTUS_ID.equals(string)) {
                oTUListDataAdapter = documentDataAdapter.getOTUList(this.getParameters(), string);
            } else if (documentDataAdapter.getOTUListCount(this.getParameters()) > 1L) {
                this.parameters.getLogger().addWarning("One or more trees were written to the Nexus document, which do not reference any TAXA block. Since the created Nexus document contains more than one TAXA block, this file may not be readable by some applications.");
            }
            this.writeBlockStart("TREES");
            this.writeTitleCommand(linkedLabeledIDEvent);
            this.writeLinkCommand(linkedLabeledIDEvent, "TAXA", EventContentType.OTU_LIST);
            HashSet<String> hashSet = new HashSet<String>();
            Iterator<TreeNetworkDataAdapter> iterator2 = treeNetworkGroupDataAdapter.getTreeNetworkIterator(this.getParameters());
            while (iterator2.hasNext()) {
                TreeNetworkDataAdapter treeNetworkDataAdapter;
                Map<String, Long> map = null;
                if (oTUListDataAdapter != null) {
                    boolean bl = this.parameters.getBoolean("info.bioinfweb.jphyloio.generateTranslationTable", false);
                    boolean bl2 = this.parameters.getBoolean("info.bioinfweb.jphyloio.alwaysWriteNexusNodeLabels", false);
                    if (bl || !bl2) {
                        map = this.createOTUIndexMap(oTUListDataAdapter);
                    }
                    if (bl) {
                        this.writeTranslateCommand(map);
                    }
                    if (bl2) {
                        map = null;
                    }
                }
                if ((treeNetworkDataAdapter = iterator2.next()).isTree(this.getParameters())) {
                    this.writeLineStart(this.getWriter(), "TREE");
                    this.getWriter().write(32);
                    this.getWriter().write(NexusEventWriter.formatToken(this.createUniqueTreeLabel((LabeledIDEvent)treeNetworkDataAdapter.getStartEvent(this.parameters), hashSet)));
                    this.getWriter().write(32);
                    this.getWriter().write(61);
                    this.getWriter().write(32);
                    new NewickStringWriter((TextWriterStreamDataProvider)this.getStreamDataProvider(), treeNetworkDataAdapter, new NexusNewickWriterNodeLabelProcessor(oTUListDataAdapter, map, this.parameters), this.parameters).write();
                    continue;
                }
                ++l;
            }
            this.writeBlockEnd();
        }
        if (l > 0L) {
            this.parameters.getLogger().addWarning("The document data contained " + l + " phylogenetic network definitions, which have not been written to the Nexus document, since it only supports trees.");
        }
    }

    private void writeSetsBlocks(DocumentDataAdapter documentDataAdapter) throws IOException {
        new AbstractNexusSetWriter((NexusWriterStreamDataProvider)this.getStreamDataProvider(), "TAXSET", EventContentType.OTU_LIST, documentDataAdapter.getOTUListIterator(this.getParameters()), new ReferenceOnlySetReceiver((NexusWriterStreamDataProvider)this.getStreamDataProvider(), EnumSet.of(EventContentType.OTU, EventContentType.OTU_SET))){

            @Override
            protected ObjectListDataAdapter<LinkedLabeledIDEvent> getSets(ElementDataAdapter<? extends LabeledIDEvent> elementDataAdapter) {
                return ((OTUListDataAdapter)elementDataAdapter).getOTUSets(NexusEventWriter.this.getParameters());
            }

            @Override
            protected String getLinkedBlockName(ElementDataAdapter<? extends LabeledIDEvent> elementDataAdapter) {
                return "TAXA";
            }
        }.write();
        new AbstractNexusSetWriter((NexusWriterStreamDataProvider)this.getStreamDataProvider(), "CHARSET", EventContentType.ALIGNMENT, documentDataAdapter.getMatrixIterator(this.getParameters()), new CharacterSetEventReceiver((NexusWriterStreamDataProvider)this.getStreamDataProvider())){

            @Override
            protected ObjectListDataAdapter<LinkedLabeledIDEvent> getSets(ElementDataAdapter<? extends LabeledIDEvent> elementDataAdapter) {
                return ((MatrixDataAdapter)elementDataAdapter).getCharacterSets(NexusEventWriter.this.getParameters());
            }

            @Override
            protected String getLinkedBlockName(ElementDataAdapter<? extends LabeledIDEvent> elementDataAdapter) {
                return ((NexusMatrixWriteResult)((Object)NexusEventWriter.this.matrixIDToBlockTypeMap.get(elementDataAdapter.getStartEvent(NexusEventWriter.this.parameters).getID()))).toBlockName();
            }
        }.write();
        new AbstractNexusSetWriter((NexusWriterStreamDataProvider)this.getStreamDataProvider(), "TREESET", EventContentType.TREE_NETWORK_GROUP, documentDataAdapter.getTreeNetworkGroupIterator(this.getParameters()), new ReferenceOnlySetReceiver((NexusWriterStreamDataProvider)this.getStreamDataProvider(), EnumSet.of(EventContentType.TREE, EventContentType.TREE_NETWORK_SET), EnumSet.of(EventContentType.NETWORK))){

            @Override
            protected ObjectListDataAdapter<LinkedLabeledIDEvent> getSets(ElementDataAdapter<? extends LabeledIDEvent> elementDataAdapter) {
                return ((TreeNetworkGroupDataAdapter)elementDataAdapter).getTreeSets(NexusEventWriter.this.getParameters());
            }

            @Override
            protected String getLinkedBlockName(ElementDataAdapter<? extends LabeledIDEvent> elementDataAdapter) {
                return "TREES";
            }
        }.write();
    }

    @Override
    protected void doWriteDocument(DocumentDataAdapter documentDataAdapter, Writer writer, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super.doWriteDocument(documentDataAdapter, writer, readWriteParameterMap);
        this.parameters = readWriteParameterMap;
        this.logger = readWriteParameterMap.getLogger();
        readWriteParameterMap.getLabelEditingReporter().clear();
        this.writeInitialLines();
        this.logIgnoredMetadata(documentDataAdapter, "The document");
        this.writeTaxaBlocks(documentDataAdapter);
        this.writeCharactersUnalignedBlocks(documentDataAdapter, readWriteParameterMap);
        this.writeTreesBlocks(documentDataAdapter);
        this.writeSetsBlocks(documentDataAdapter);
    }
}

