/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus;

import info.bioinfweb.commons.LongIDManager;
import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.blockhandlers.ENewickNetworksBlockHandler;
import info.bioinfweb.jphyloio.formats.nexus.blockhandlers.NexusBlockHandler;
import info.bioinfweb.jphyloio.formats.nexus.blockhandlers.NexusBlockHandlerMap;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.DefaultCommandReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.NexusCommandEventReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.NexusCommandReaderFactory;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.trees.ENewickNetworkReader;
import info.bioinfweb.jphyloio.formats.text.AbstractTextEventReader;
import info.bioinfweb.jphyloio.formats.text.KeyValueInformation;
import info.bioinfweb.jphyloio.utils.SequenceTokensEventManager;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class NexusEventReader
extends AbstractTextEventReader<NexusReaderStreamDataProvider>
implements NexusConstants {
    private NexusBlockHandlerMap blockHandlerMap;
    private NexusCommandReaderFactory factory;
    private boolean createUnknownCommandEvents = false;
    private String currentBlockName;
    private NexusCommandEventReader currentCommandReader = null;
    private boolean documentEndReached = false;

    public NexusEventReader(File file, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(file, readWriteParameterMap, readWriteParameterMap.getMatchToken());
        this.init();
    }

    public NexusEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(inputStream, readWriteParameterMap, readWriteParameterMap.getMatchToken());
        this.init();
    }

    public NexusEventReader(PeekReader peekReader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(peekReader, readWriteParameterMap, readWriteParameterMap.getMatchToken());
        this.init();
    }

    public NexusEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(reader, readWriteParameterMap, readWriteParameterMap.getMatchToken());
        this.init();
    }

    private void init() {
        this.blockHandlerMap = (NexusBlockHandlerMap)this.getParameters().getObject("info.bioinfweb.jphyloio.nexusBlockHandlerMap", NexusBlockHandlerMap.newJPhyloIOInstance(), NexusBlockHandlerMap.class);
        this.factory = (NexusCommandReaderFactory)this.getParameters().getObject("info.bioinfweb.jphyloio.nexusCommandReaderFactory", NexusCommandReaderFactory.newJPhyloIOInstance(), NexusCommandReaderFactory.class);
        this.createUnknownCommandEvents = this.getParameters().getBoolean("info.bioinfweb.jphyloio.createUnknownCommandEvents", false);
    }

    public void addENewickNetworksBlockSupport() {
        this.blockHandlerMap.addHandler(new ENewickNetworksBlockHandler());
        this.factory.addReaderClass(ENewickNetworkReader.class);
    }

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.nexus";
    }

    @Override
    protected NexusReaderStreamDataProvider createStreamDataProvider() {
        return new NexusReaderStreamDataProvider(this);
    }

    protected boolean getCreateUnknownCommandEvents() {
        return this.createUnknownCommandEvents;
    }

    public String getCurrentBlockName() {
        return this.currentBlockName;
    }

    @Override
    protected LongIDManager getIDManager() {
        return super.getIDManager();
    }

    @Override
    protected SequenceTokensEventManager getSequenceTokensEventManager() {
        return super.getSequenceTokensEventManager();
    }

    protected void consumeWhiteSpaceAndComments() throws IOException {
        this.consumeWhiteSpaceAndComments('[', ']');
    }

    protected String readNexusWord() throws IOException {
        try {
            StringBuilder stringBuilder;
            block7: {
                stringBuilder = new StringBuilder();
                char c = this.getReader().peekChar();
                if (c == '\'') {
                    this.getReader().skip(1L);
                    c = this.getReader().peekChar();
                    while (true) {
                        if (c == '\'') {
                            this.getReader().skip(1L);
                            if (this.getReader().peekChar() != '\'') break block7;
                        }
                        stringBuilder.append(c);
                        this.getReader().skip(1L);
                        c = this.getReader().peekChar();
                    }
                }
                while (!(Character.isWhitespace(c) || c == '[' || c == ';' || c == '=' || c == ',' || c == '/' || c == '-' && stringBuilder.length() != 0)) {
                    stringBuilder.append(c);
                    this.getReader().skip(1L);
                    c = this.getReader().peekChar();
                }
            }
            return stringBuilder.toString();
        }
        catch (EOFException eOFException) {
            throw new JPhyloIOReaderException("Unexpected end of file inside a Nexus word.", (StreamLocationProvider)this.getReader(), (Throwable)eOFException);
        }
    }

    protected long readPositiveInteger(long l) throws IOException {
        if (this.getReader().peekChar() == '.') {
            this.getReader().skip(1L);
            return l;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (Character.isDigit(this.getReader().peekChar())) {
            stringBuilder.append(this.getReader().readChar());
        }
        if (stringBuilder.length() > 0) {
            return Long.parseLong(stringBuilder.toString());
        }
        return -2L;
    }

    protected void readComment() throws IOException {
        this.readComment('[', ']');
    }

    protected KeyValueInformation readKeyValueMetaInformation() throws IOException {
        return this.readKeyValueInformation(';', '[', ']', '=');
    }

    private void checkStart() throws IOException {
        if (!"#NEXUS".equals(this.getReader().readString("#NEXUS".length()).toUpperCase())) {
            throw new JPhyloIOReaderException("All Nexus files must start with \"#NEXUS\".", 0L, 0L, 0L);
        }
    }

    private void processBlockStartEnd(EventTopologyType eventTopologyType) {
        ((NexusReaderStreamDataProvider)this.getStreamDataProvider()).clearBlockInformation();
        NexusBlockHandler nexusBlockHandler = this.blockHandlerMap.getHandler(this.currentBlockName);
        if (nexusBlockHandler != null) {
            if (EventTopologyType.START.equals((Object)eventTopologyType)) {
                nexusBlockHandler.handleBegin((NexusReaderStreamDataProvider)this.getStreamDataProvider());
            } else {
                nexusBlockHandler.handleEnd((NexusReaderStreamDataProvider)this.getStreamDataProvider());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readNextCommand() throws IOException {
        this.consumeWhiteSpaceAndComments();
        while (this.getUpcomingEvents().isEmpty() && this.getReader().peek() != -1) {
            String string = this.getReader().readRegExp(UNTIL_WHITESPACE_COMMENT_COMMAND_PATTERN, false).getSequence().toString();
            char c = StringUtils.lastChar((CharSequence)string);
            string = StringUtils.cutEnd((String)string, (int)1).toUpperCase();
            if (c == '[') {
                this.readComment();
            }
            if ("BEGIN".equals(string)) {
                if (this.currentBlockName != null) throw new JPhyloIOReaderException("Nested blocks are not allowed in Nexus.", (StreamLocationProvider)this.getReader());
                this.consumeWhiteSpaceAndComments();
                this.currentBlockName = this.getReader().readRegExp(UNTIL_WHITESPACE_COMMENT_COMMAND_PATTERN, false).getSequence().toString().toUpperCase();
                c = StringUtils.lastChar((CharSequence)this.currentBlockName);
                this.currentBlockName = StringUtils.cutEnd((String)this.currentBlockName, (int)1);
                this.processBlockStartEnd(EventTopologyType.START);
                if (c != ';') {
                    this.consumeWhiteSpaceAndComments();
                    if (this.getReader().peekChar() != ';') throw new JPhyloIOReaderException("Invalid character '" + this.getReader().peekChar() + "' in " + "BEGIN" + " command.", (StreamLocationProvider)this.getReader());
                    this.getReader().skip(1L);
                }
            } else if ("END".equals(string) || "ENDBLOCK".equals(string)) {
                this.processBlockStartEnd(EventTopologyType.END);
                this.currentBlockName = null;
                this.consumeWhiteSpaceAndComments();
                if (this.getReader().peek() != -1 && this.getReader().peekChar() == ';') {
                    this.getReader().read();
                }
            } else if (c != ';') {
                this.currentCommandReader = this.factory.createReader(this.currentBlockName, string, (NexusReaderStreamDataProvider)this.getStreamDataProvider());
                NexusBlockHandler nexusBlockHandler = this.blockHandlerMap.getHandler(this.currentBlockName);
                if (nexusBlockHandler != null) {
                    nexusBlockHandler.beforeCommand((NexusReaderStreamDataProvider)this.getStreamDataProvider(), string, this.currentCommandReader);
                }
                if (this.currentCommandReader == null) {
                    if (this.getCreateUnknownCommandEvents()) {
                        this.currentCommandReader = new DefaultCommandReader(string, (NexusReaderStreamDataProvider)this.getStreamDataProvider());
                    } else if (c != ';') {
                        PeekReader.ReadResult readResult;
                        while (!(readResult = this.getReader().readUntil(this.getParameters().getMaxTokensToRead(), Character.toString(';'))).isCompletelyRead()) {
                        }
                    }
                }
                if (this.currentCommandReader != null) {
                    return this.currentCommandReader.readNextEvent();
                }
            }
            this.consumeWhiteSpaceAndComments();
        }
        if (this.getReader().peek() == -1) return false;
        return true;
    }

    @Override
    protected void readNextEvent() throws IOException {
        if (!this.documentEndReached) {
            if (this.isBeforeFirstAccess()) {
                this.checkStart();
                this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.START));
                this.consumeWhiteSpaceAndComments();
            } else {
                boolean bl = false;
                bl = this.currentCommandReader == null ? this.readNextCommand() : this.currentCommandReader.readNextEvent();
                if (!bl) {
                    do {
                        bl = this.readNextCommand();
                        this.consumeWhiteSpaceAndComments();
                    } while (!bl && this.getReader().peek() != -1);
                }
                if (!bl) {
                    this.documentEndReached = true;
                    this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.END));
                }
            }
        }
    }
}

