/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus;

import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.dataadapters.ElementDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.ObjectListDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.implementations.receivers.BasicEventReceiver;
import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusEventWriter;
import info.bioinfweb.jphyloio.formats.nexus.NexusWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.receivers.AbstractNexusEventReceiver;
import java.io.IOException;
import java.util.Iterator;

public abstract class AbstractNexusSetWriter
implements NexusConstants {
    private NexusWriterStreamDataProvider streamDataProvider;
    private String commandName;
    private EventContentType linkedContentType;
    private Iterator<? extends ElementDataAdapter<? extends LabeledIDEvent>> dataSourceIterator;
    private AbstractNexusEventReceiver receiver;
    private boolean executed = false;

    public AbstractNexusSetWriter(NexusWriterStreamDataProvider nexusWriterStreamDataProvider, String string, EventContentType eventContentType, Iterator<? extends ElementDataAdapter<? extends LabeledIDEvent>> iterator, AbstractNexusEventReceiver abstractNexusEventReceiver) {
        this.streamDataProvider = nexusWriterStreamDataProvider;
        this.commandName = string;
        this.linkedContentType = eventContentType;
        this.dataSourceIterator = iterator;
        this.receiver = abstractNexusEventReceiver;
    }

    protected abstract ObjectListDataAdapter<LinkedLabeledIDEvent> getSets(ElementDataAdapter<? extends LabeledIDEvent> var1);

    protected abstract String getLinkedBlockName(ElementDataAdapter<? extends LabeledIDEvent> var1);

    private void logIgnoredMetadata(BasicEventReceiver<NexusWriterStreamDataProvider> basicEventReceiver, String string) {
        if (basicEventReceiver.didIgnoreMetadata()) {
            this.streamDataProvider.getParameters().getLogger().addMessage("One or more " + string + " elements contained metadata. " + basicEventReceiver.getIgnoredMetadata() + " metadata items were not written, because the Nexus format does not support metadata at this position.");
        }
    }

    public void write() throws IOException {
        if (this.executed) {
            throw new IllegalStateException("This set writer did already run and cannot be invoked multiple times.");
        }
        this.executed = true;
        while (this.dataSourceIterator.hasNext()) {
            ElementDataAdapter<? extends LabeledIDEvent> elementDataAdapter = this.dataSourceIterator.next();
            ObjectListDataAdapter<LinkedLabeledIDEvent> objectListDataAdapter = this.getSets(elementDataAdapter);
            Iterator<String> iterator = objectListDataAdapter.getIDIterator(this.streamDataProvider.getParameters());
            if (!iterator.hasNext()) continue;
            this.streamDataProvider.writeBlockStart("SETS");
            String string = elementDataAdapter.getStartEvent(this.streamDataProvider.getParameters()).getID();
            this.streamDataProvider.writeLinkCommand(string, this.getLinkedBlockName(elementDataAdapter), this.linkedContentType);
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                this.streamDataProvider.writeLineStart(this.commandName);
                this.streamDataProvider.getWriter().write(32);
                this.streamDataProvider.getWriter().write(NexusEventWriter.formatToken(AbstractEventWriter.createUniqueLabel(this.streamDataProvider.getParameters(), objectListDataAdapter.getObjectStartEvent(this.streamDataProvider.getParameters(), string2))));
                this.streamDataProvider.getWriter().write(32);
                this.streamDataProvider.getWriter().write(61);
                objectListDataAdapter.writeContentData(this.streamDataProvider.getParameters(), this.receiver, string2);
                this.streamDataProvider.writeCommandEnd();
            }
            this.streamDataProvider.writeBlockEnd();
        }
        this.logIgnoredMetadata(this.receiver, this.commandName);
    }
}

