/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml.receivers;

import info.bioinfweb.commons.bio.CharacterStateSetType;
import info.bioinfweb.commons.bio.CharacterSymbolMeaning;
import info.bioinfweb.commons.bio.CharacterSymbolType;
import info.bioinfweb.commons.bio.SequenceUtils;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SingleTokenDefinitionEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterAlignmentInformation;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexml.receivers.AbstractNeXMLDataReceiverMixin;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLMetaDataReceiver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class NeXMLTokenSetEventReceiver
extends NeXMLMetaDataReceiver {
    private String tokenSetID;
    private Map<String, String> tokenNameToIDMap = new HashMap<String, String>();
    private int tokenDefinitionIndex = 0;

    public NeXMLTokenSetEventReceiver(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, String string) {
        super(neXMLWriterStreamDataProvider, readWriteParameterMap);
        this.tokenSetID = string;
    }

    private void writeState(SingleTokenDefinitionEvent singleTokenDefinitionEvent) throws XMLStreamException, IOException {
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeStartElement(TAG_STATE.getLocalPart());
        this.writeTokenDefinitionAttributes(singleTokenDefinitionEvent);
    }

    private void writeStateSet(SingleTokenDefinitionEvent singleTokenDefinitionEvent, boolean bl) throws XMLStreamException, IOException {
        block11: {
            Collection<Object> collection;
            String string;
            block13: {
                block12: {
                    NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo();
                    string = null;
                    String string2 = singleTokenDefinitionEvent.getTokenName();
                    if (bl) {
                        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeStartElement(TAG_POLYMORPHIC.getLocalPart());
                    } else {
                        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeStartElement(TAG_UNCERTAIN.getLocalPart());
                    }
                    this.writeTokenDefinitionAttributes(singleTokenDefinitionEvent);
                    if (singleTokenDefinitionEvent.getMeaning().equals((Object)CharacterSymbolMeaning.GAP)) break block11;
                    collection = new ArrayList();
                    if (singleTokenDefinitionEvent.getConstituents() != null && !singleTokenDefinitionEvent.getConstituents().isEmpty()) break block12;
                    switch (neXMLWriterAlignmentInformation.getAlignmentType()) {
                        case DNA: {
                            collection = this.addConstituents(SequenceUtils.nucleotideConstituents((char)string2.charAt(0)), false);
                            break;
                        }
                        case RNA: {
                            collection = this.addConstituents(SequenceUtils.rnaConstituents((char)string2.charAt(0)), true);
                            break;
                        }
                        case AMINO_ACID: {
                            if (SequenceUtils.getAminoAcidOneLetterCodes((boolean)true).contains(string2)) {
                                collection = this.addConstituents(SequenceUtils.oneLetterAminoAcidConstituents((String)string2), false);
                                break;
                            }
                            if (SequenceUtils.getAminoAcidThreeLetterCodes((boolean)true).contains(string2)) {
                                string2 = Character.toString(SequenceUtils.oneLetterAminoAcidByThreeLetter((String)string2));
                                collection = this.addConstituents(SequenceUtils.oneLetterAminoAcidConstituents((String)string2), false);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block13;
                }
                collection = singleTokenDefinitionEvent.getConstituents();
            }
            for (String string3 : collection) {
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeEmptyElement(TAG_MEMBER.getLocalPart());
                string = this.tokenNameToIDMap.get(string3);
                if (string != null && ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getDocumentIDs().contains(string)) {
                    ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_SINGLE_STATE_LINK.getLocalPart(), string);
                    continue;
                }
                throw new InconsistentAdapterDataException("The token \"" + string3 + "\" was referenced in a token definition but not defined before. This may error may be solved by providing tokens in the correct order (atomic states before uncertain states that reference them as constituents).");
            }
        }
    }

    private void writeTokenDefinitionAttributes(SingleTokenDefinitionEvent singleTokenDefinitionEvent) throws XMLStreamException, IOException {
        String string;
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo();
        String string2 = string = singleTokenDefinitionEvent.getTokenName();
        String string3 = singleTokenDefinitionEvent.getLabel();
        if (neXMLWriterAlignmentInformation.getAlignmentType().equals((Object)CharacterStateSetType.DISCRETE)) {
            string2 = "" + this.tokenDefinitionIndex;
            ++this.tokenDefinitionIndex;
            string3 = string;
        } else if (neXMLWriterAlignmentInformation.getAlignmentType().equals((Object)CharacterStateSetType.AMINO_ACID) && string.length() == 3) {
            string2 = Character.toString(SequenceUtils.oneLetterAminoAcidByThreeLetter((String)string));
            string3 = string;
        }
        neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().get(this.tokenSetID).getTokenTranslationMap().put(singleTokenDefinitionEvent.getTokenName(), string2);
        this.tokenNameToIDMap.put(string, singleTokenDefinitionEvent.getID());
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_ID.getLocalPart(), singleTokenDefinitionEvent.getID());
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_ABOUT.getLocalPart(), "#" + singleTokenDefinitionEvent.getID());
        if (this.getParameterMap().getBoolean("info.bioinfweb.jphyloio.neXMLstandardDataLabel", false)) {
            if (string3 != null && !string3.isEmpty()) {
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_LABEL.getLocalPart(), string3);
            }
        } else if (singleTokenDefinitionEvent.getLabel() != null && !singleTokenDefinitionEvent.getLabel().isEmpty()) {
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_LABEL.getLocalPart(), singleTokenDefinitionEvent.getLabel());
        }
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_SYMBOL.getLocalPart(), string2);
        switch (this.getParameterMap().getLabelHandling()) {
            case NEITHER: {
                break;
            }
            case BOTH: {
                if (singleTokenDefinitionEvent.getLabel() != null && !singleTokenDefinitionEvent.getLabel().isEmpty()) {
                    this.writeMetaElement(PREDICATE_ORIGINAL_LABEL, singleTokenDefinitionEvent.getLabel());
                }
                if (singleTokenDefinitionEvent.getTokenName().isEmpty()) break;
                this.writeMetaElement(PREDICATE_ORIGINAL_TOKEN_NAME, singleTokenDefinitionEvent.getTokenName());
                break;
            }
            case DISCARDED: {
                if (singleTokenDefinitionEvent.getLabel() != null && !singleTokenDefinitionEvent.getLabel().isEmpty() && !string3.equals(singleTokenDefinitionEvent.getLabel())) {
                    this.writeMetaElement(PREDICATE_ORIGINAL_LABEL, singleTokenDefinitionEvent.getLabel());
                }
                if (string2.equals(singleTokenDefinitionEvent.getTokenName()) || string3.equals(singleTokenDefinitionEvent.getTokenName()) || singleTokenDefinitionEvent.getTokenName().isEmpty()) break;
                this.writeMetaElement(PREDICATE_ORIGINAL_TOKEN_NAME, singleTokenDefinitionEvent.getTokenName());
            }
        }
    }

    private void writeMetaElement(QName qName, String string) throws XMLStreamException, IOException {
        AbstractNeXMLDataReceiverMixin.handleLiteralMeta((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), new LiteralMetadataEvent(((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("meta"), null, new URIOrStringIdentifier(null, qName), LiteralContentSequenceType.SIMPLE));
        AbstractNeXMLDataReceiverMixin.handleLiteralContentMeta((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameterMap(), new LiteralMetadataContentEvent((Object)string, string));
        AbstractNeXMLDataReceiverMixin.handleMetaEndEvent((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
    }

    private Collection<String> addConstituents(char[] cArray, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < cArray.length; ++i) {
            String string = Character.toString(cArray[i]);
            if (bl && string.equals("T")) {
                arrayList.add("U");
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public void writeRemainingStandardTokenDefinitions() throws IOException, XMLStreamException {
        for (String string : ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo().getIDToTokenSetInfoMap().get(this.tokenSetID).getOccuringTokens()) {
            String string2 = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("tokenDefinition");
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(string2);
            this.doAdd(new SingleTokenDefinitionEvent(string2, null, string, CharacterSymbolMeaning.CHARACTER_STATE, CharacterSymbolType.ATOMIC_STATE, null));
            this.doAdd(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.SINGLE_TOKEN_DEFINITION));
        }
    }

    @Override
    protected boolean doAdd(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        switch (jPhyloIOEvent.getType().getContentType()) {
            case SINGLE_TOKEN_DEFINITION: {
                if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                    SingleTokenDefinitionEvent singleTokenDefinitionEvent = jPhyloIOEvent.asSingleTokenDefinitionEvent();
                    if (singleTokenDefinitionEvent.getMeaning().equals((Object)CharacterSymbolMeaning.MATCH) || singleTokenDefinitionEvent.getMeaning().equals((Object)CharacterSymbolMeaning.OTHER)) break;
                    switch (singleTokenDefinitionEvent.getTokenType()) {
                        case ATOMIC_STATE: {
                            this.writeState(singleTokenDefinitionEvent);
                            break;
                        }
                        case POLYMORPHIC: {
                            this.writeStateSet(singleTokenDefinitionEvent, true);
                            break;
                        }
                        case UNCERTAIN: {
                            this.writeStateSet(singleTokenDefinitionEvent, false);
                        }
                    }
                    break;
                }
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeEndElement();
                break;
            }
        }
        return true;
    }
}

