/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml.receivers;

import info.bioinfweb.commons.bio.CharacterStateSetType;
import info.bioinfweb.commons.bio.CharacterSymbolMeaning;
import info.bioinfweb.commons.bio.CharacterSymbolType;
import info.bioinfweb.commons.bio.SequenceUtils;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.CharacterSetIntervalEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SingleTokenDefinitionEvent;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.exception.JPhyloIOWriterException;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterAlignmentInformation;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLCollectNamespaceReceiver;
import java.io.IOException;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;

public class NeXMLCollectTokenSetDefinitionDataReceiver
extends NeXMLCollectNamespaceReceiver {
    private String tokenSetDefinitionID;

    public NeXMLCollectTokenSetDefinitionDataReceiver(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, String string) {
        super(neXMLWriterStreamDataProvider, readWriteParameterMap);
        this.tokenSetDefinitionID = string;
    }

    private void logTokenSetWarning(SingleTokenDefinitionEvent singleTokenDefinitionEvent, CharacterStateSetType characterStateSetType, CharacterStateSetType characterStateSetType2) {
        this.getLogger().addWarning("Switching from the specified " + characterStateSetType + " token set to " + characterStateSetType2 + " token set, since a token with the ID " + singleTokenDefinitionEvent.getID() + " (\"" + singleTokenDefinitionEvent.getTokenName() + "\", " + singleTokenDefinitionEvent.getTokenType() + ", " + singleTokenDefinitionEvent.getMeaning() + ") was encountered that is invalid for a " + characterStateSetType + " token set in NeXML or such a token set does not exist in this format. (Note that additional switches within the same token set may follow.)");
    }

    private void checkSingleTokenDefinition(SingleTokenDefinitionEvent singleTokenDefinitionEvent) throws JPhyloIOWriterException {
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo();
        switch (neXMLWriterAlignmentInformation.getTokenSetType()) {
            case DNA: {
                if (this.isDNAToken(singleTokenDefinitionEvent)) break;
                if (((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentTokenSetInfo().isNucleotideType() && this.isRNAToken(singleTokenDefinitionEvent) && !neXMLWriterAlignmentInformation.getDefinedTokens().contains("T")) {
                    this.logTokenSetWarning(singleTokenDefinitionEvent, neXMLWriterAlignmentInformation.getTokenSetType(), CharacterStateSetType.RNA);
                    neXMLWriterAlignmentInformation.setTokenSetType(CharacterStateSetType.RNA);
                    break;
                }
                this.logTokenSetWarning(singleTokenDefinitionEvent, neXMLWriterAlignmentInformation.getTokenSetType(), CharacterStateSetType.DISCRETE);
                neXMLWriterAlignmentInformation.setTokenSetType(CharacterStateSetType.DISCRETE);
                break;
            }
            case RNA: {
                if (this.isRNAToken(singleTokenDefinitionEvent)) break;
                if (((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentTokenSetInfo().isNucleotideType() && this.isDNAToken(singleTokenDefinitionEvent) && !neXMLWriterAlignmentInformation.getDefinedTokens().contains("U")) {
                    this.logTokenSetWarning(singleTokenDefinitionEvent, neXMLWriterAlignmentInformation.getTokenSetType(), CharacterStateSetType.DNA);
                    neXMLWriterAlignmentInformation.setTokenSetType(CharacterStateSetType.DNA);
                    break;
                }
                this.logTokenSetWarning(singleTokenDefinitionEvent, neXMLWriterAlignmentInformation.getTokenSetType(), CharacterStateSetType.DISCRETE);
                neXMLWriterAlignmentInformation.setTokenSetType(CharacterStateSetType.DISCRETE);
                break;
            }
            case NUCLEOTIDE: {
                if (this.isDNAToken(singleTokenDefinitionEvent)) {
                    this.getLogger().addMessage("Switching from a NUCLEOTIDE to a DNA token set, since NeXML does not allow general nucleotide token sets. (Note that additional switches within the same token set may follow.)");
                    neXMLWriterAlignmentInformation.setTokenSetType(CharacterStateSetType.DNA);
                    break;
                }
                if (this.isRNAToken(singleTokenDefinitionEvent)) {
                    this.getLogger().addMessage("Switching from a NUCLEOTIDE to a RNA token set, since NeXML does not allow general nucleotide token sets. (Note that additional switches within the same token set may follow.)");
                    neXMLWriterAlignmentInformation.setTokenSetType(CharacterStateSetType.RNA);
                    break;
                }
                this.logTokenSetWarning(singleTokenDefinitionEvent, neXMLWriterAlignmentInformation.getTokenSetType(), CharacterStateSetType.DISCRETE);
                neXMLWriterAlignmentInformation.setTokenSetType(CharacterStateSetType.DISCRETE);
                break;
            }
            case AMINO_ACID: {
                if (this.isAAToken(singleTokenDefinitionEvent)) break;
                this.logTokenSetWarning(singleTokenDefinitionEvent, neXMLWriterAlignmentInformation.getTokenSetType(), CharacterStateSetType.DISCRETE);
                neXMLWriterAlignmentInformation.setTokenSetType(CharacterStateSetType.DISCRETE);
                break;
            }
            case CONTINUOUS: {
                throw new InconsistentAdapterDataException("A continuous data token set can not specify single token definitions.");
            }
        }
    }

    private boolean isDNAToken(SingleTokenDefinitionEvent singleTokenDefinitionEvent) {
        char c;
        if (singleTokenDefinitionEvent.getTokenName().length() == 1 && (c = singleTokenDefinitionEvent.getTokenName().charAt(0)) != 'U') {
            if (singleTokenDefinitionEvent.getTokenType().equals((Object)CharacterSymbolType.ATOMIC_STATE)) {
                if (SequenceUtils.isNonAmbiguityNucleotide((char)c) || this.isMissingChar(singleTokenDefinitionEvent) || this.isGapChar(singleTokenDefinitionEvent)) {
                    return true;
                }
            } else if (singleTokenDefinitionEvent.getTokenType().equals((Object)CharacterSymbolType.UNCERTAIN)) {
                if (SequenceUtils.isNucleotideAmbuguityCode((char)c)) {
                    return this.checkConstituents(singleTokenDefinitionEvent.getConstituents(), SequenceUtils.nucleotideConstituents((char)c));
                }
                if (this.isGapChar(singleTokenDefinitionEvent) || this.isMissingChar(singleTokenDefinitionEvent)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isRNAToken(SingleTokenDefinitionEvent singleTokenDefinitionEvent) {
        char c;
        if (singleTokenDefinitionEvent.getTokenName().length() == 1 && (c = singleTokenDefinitionEvent.getTokenName().charAt(0)) != 'T') {
            if (singleTokenDefinitionEvent.getTokenType().equals((Object)CharacterSymbolType.ATOMIC_STATE)) {
                if (SequenceUtils.isNonAmbiguityNucleotide((char)c) || this.isMissingChar(singleTokenDefinitionEvent) || this.isGapChar(singleTokenDefinitionEvent)) {
                    return true;
                }
            } else if (singleTokenDefinitionEvent.getTokenType().equals((Object)CharacterSymbolType.UNCERTAIN)) {
                if (SequenceUtils.isNucleotideAmbuguityCode((char)c)) {
                    return this.checkConstituents(singleTokenDefinitionEvent.getConstituents(), SequenceUtils.rnaConstituents((char)c));
                }
                if (this.isGapChar(singleTokenDefinitionEvent) || this.isMissingChar(singleTokenDefinitionEvent)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAAToken(SingleTokenDefinitionEvent singleTokenDefinitionEvent) {
        String string = singleTokenDefinitionEvent.getTokenName();
        if (singleTokenDefinitionEvent.getTokenType().equals((Object)CharacterSymbolType.ATOMIC_STATE)) {
            if (SequenceUtils.isNonAmbiguityAminoAcid((String)string) || this.isMissingChar(singleTokenDefinitionEvent) || this.isGapChar(singleTokenDefinitionEvent) || singleTokenDefinitionEvent.getMeaning().equals((Object)CharacterSymbolMeaning.CHARACTER_STATE) && string.equals(Character.valueOf('*'))) {
                return true;
            }
        } else if (singleTokenDefinitionEvent.getTokenType().equals((Object)CharacterSymbolType.UNCERTAIN)) {
            if (SequenceUtils.isAminoAcidAmbiguityCode((String)string)) {
                if (!string.equals("J") && !string.equals("Xle")) {
                    Collection<String> collection = singleTokenDefinitionEvent.getConstituents();
                    if (SequenceUtils.getAminoAcidOneLetterCodes((boolean)true).contains(Character.valueOf(string.charAt(0)))) {
                        this.checkConstituents(collection, SequenceUtils.oneLetterAminoAcidConstituents((String)string));
                    } else if (SequenceUtils.getAminoAcidThreeLetterCodes((boolean)true).contains(string)) {
                        this.checkConstituents(collection, SequenceUtils.threeLetterAminoAcidConstituents((String)string));
                    }
                    return true;
                }
            } else if (this.isGapChar(singleTokenDefinitionEvent) || this.isMissingChar(singleTokenDefinitionEvent)) {
                return true;
            }
        }
        return false;
    }

    private boolean isGapChar(SingleTokenDefinitionEvent singleTokenDefinitionEvent) {
        return singleTokenDefinitionEvent.getMeaning().equals((Object)CharacterSymbolMeaning.GAP) && singleTokenDefinitionEvent.getTokenName().equals(Character.toString('-'));
    }

    private boolean isMissingChar(SingleTokenDefinitionEvent singleTokenDefinitionEvent) {
        return singleTokenDefinitionEvent.getMeaning().equals((Object)CharacterSymbolMeaning.MISSING) && singleTokenDefinitionEvent.getTokenName().equals(Character.toString('?'));
    }

    private boolean checkConstituents(Collection<String> collection, char[] cArray) {
        String[] stringArray = new String[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            stringArray[i] = Character.toString(cArray[i]);
        }
        return this.checkConstituents(collection, stringArray);
    }

    private boolean checkConstituents(Collection<String> collection, String[] stringArray) {
        if (collection != null && !collection.isEmpty()) {
            if (collection.size() == stringArray.length) {
                boolean bl = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    bl = collection.contains(stringArray[i]);
                    if (bl) continue;
                    return false;
                }
                if (bl) {
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    protected boolean doAdd(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo();
        switch (jPhyloIOEvent.getType().getContentType()) {
            case SINGLE_TOKEN_DEFINITION: {
                SingleTokenDefinitionEvent singleTokenDefinitionEvent;
                if (!jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START) || (singleTokenDefinitionEvent = jPhyloIOEvent.asSingleTokenDefinitionEvent()).getMeaning().equals((Object)CharacterSymbolMeaning.MATCH)) break;
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(singleTokenDefinitionEvent.getID());
                this.checkSingleTokenDefinition(singleTokenDefinitionEvent);
                neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().get(this.tokenSetDefinitionID).getSingleTokenDefinitions().add(singleTokenDefinitionEvent.getTokenName());
                neXMLWriterAlignmentInformation.getDefinedTokens().add(singleTokenDefinitionEvent.getTokenName());
                break;
            }
            case CHARACTER_SET_INTERVAL: {
                CharacterSetIntervalEvent characterSetIntervalEvent = jPhyloIOEvent.asCharacterSetIntervalEvent();
                for (long i = characterSetIntervalEvent.getStart(); i < characterSetIntervalEvent.getEnd(); ++i) {
                    if (neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().containsKey(i)) {
                        throw new InconsistentAdapterDataException("More than one token set was assigned to the alignment column " + i + ".");
                    }
                    neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().put(i, this.tokenSetDefinitionID);
                }
                break;
            }
        }
        return true;
    }
}

