/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml.receivers;

import info.bioinfweb.commons.bio.CharacterStateSetType;
import info.bioinfweb.commons.bio.SequenceUtils;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.exception.JPhyloIOWriterException;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterAlignmentInformation;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexml.receivers.AbstractNeXMLDataReceiverMixin;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLHandleSequenceDataReceiver;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class NeXMLCollectSequenceDataReceiver
extends NeXMLHandleSequenceDataReceiver {
    public NeXMLCollectSequenceDataReceiver(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, boolean bl) {
        super(neXMLWriterStreamDataProvider, readWriteParameterMap, bl);
    }

    @Override
    protected void handleResourceMetaStart(ResourceMetadataEvent resourceMetadataEvent) throws IOException, XMLStreamException {
        AbstractNeXMLDataReceiverMixin.checkResourceMeta((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), resourceMetadataEvent);
        if (this.isNestedUnderSingleToken()) {
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo().setWriteCellsTags(true);
        }
    }

    @Override
    protected void handleLiteralMetaStart(LiteralMetadataEvent literalMetadataEvent) throws IOException, XMLStreamException {
        AbstractNeXMLDataReceiverMixin.checkLiteralMeta((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), literalMetadataEvent);
        if (this.isNestedUnderSingleToken()) {
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo().setWriteCellsTags(true);
        }
    }

    @Override
    protected void handleLiteralContentMeta(LiteralMetadataContentEvent literalMetadataContentEvent) throws IOException, XMLStreamException {
        AbstractNeXMLDataReceiverMixin.checkLiteralContentMeta((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameterMap(), literalMetadataContentEvent);
        if (this.isNestedUnderSingleToken()) {
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo().setWriteCellsTags(true);
        }
    }

    @Override
    protected void handleToken(String string, String string2) throws JPhyloIOWriterException {
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo();
        if (!neXMLWriterAlignmentInformation.hasTokenDefinitionSet()) {
            neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().get(neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().get(this.getTokenIndex())).getOccuringTokens().add(string);
            if (neXMLWriterAlignmentInformation.getTokenSetType().equals((Object)CharacterStateSetType.CONTINUOUS)) {
                try {
                    Double.parseDouble(string);
                    neXMLWriterAlignmentInformation.setTokenType(CharacterStateSetType.CONTINUOUS);
                }
                catch (NumberFormatException numberFormatException) {
                    neXMLWriterAlignmentInformation.setTokenType(CharacterStateSetType.DISCRETE);
                }
            } else if (!neXMLWriterAlignmentInformation.getTokenSetType().equals((Object)CharacterStateSetType.DISCRETE) && !neXMLWriterAlignmentInformation.getDefinedTokens().contains(string)) {
                neXMLWriterAlignmentInformation.setTokenType(CharacterStateSetType.DISCRETE);
            }
        } else if (neXMLWriterAlignmentInformation.getTokenSetType().equals((Object)CharacterStateSetType.DISCRETE)) {
            neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().get(neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().get(this.getTokenIndex())).getOccuringTokens().add(string);
        } else if (neXMLWriterAlignmentInformation.getTokenSetType().equals((Object)CharacterStateSetType.CONTINUOUS)) {
            try {
                Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JPhyloIOWriterException("All tokens in a continuous data characters tag must be numbers.");
            }
        } else if (neXMLWriterAlignmentInformation.getTokenSetType().equals((Object)CharacterStateSetType.AMINO_ACID)) {
            neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().get(neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().get(this.getTokenIndex())).getOccuringTokens().add(string);
            if (!(neXMLWriterAlignmentInformation.getDefinedTokens().contains(string) || string.length() == 3 && neXMLWriterAlignmentInformation.getDefinedTokens().contains(Character.toString(SequenceUtils.oneLetterAminoAcidByThreeLetter((String)string))))) {
                neXMLWriterAlignmentInformation.setTokenType(CharacterStateSetType.DISCRETE);
            }
        } else {
            neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().get(neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().get(this.getTokenIndex())).getOccuringTokens().add(string);
            if (!neXMLWriterAlignmentInformation.getDefinedTokens().contains(string)) {
                neXMLWriterAlignmentInformation.setTokenType(CharacterStateSetType.DISCRETE);
            }
        }
        this.setTokenIndex(this.getTokenIndex() + 1L);
    }
}

