/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml.receivers;

import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.exception.JPhyloIOWriterException;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLConstants;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.XMLReadWriteUtils;
import info.bioinfweb.jphyloio.objecttranslation.ObjectTranslator;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class AbstractNeXMLDataReceiverMixin
implements NeXMLConstants {
    public static void handleLiteralMeta(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, LiteralMetadataEvent literalMetadataEvent) throws XMLStreamException, JPhyloIOWriterException {
        XMLStreamWriter xMLStreamWriter = neXMLWriterStreamDataProvider.getWriter();
        String string = neXMLWriterStreamDataProvider.getNeXMLPrefix(neXMLWriterStreamDataProvider.getWriter()) + ":" + "LiteralMeta";
        xMLStreamWriter.writeStartElement(TAG_META.getLocalPart());
        neXMLWriterStreamDataProvider.writeLabeledIDAttributes(literalMetadataEvent, null);
        xMLStreamWriter.writeAttribute(XMLReadWriteUtils.getXSIPrefix(neXMLWriterStreamDataProvider.getWriter()), ATTR_XSI_TYPE.getNamespaceURI(), ATTR_XSI_TYPE.getLocalPart(), string);
        QName qName = literalMetadataEvent.getPredicate().getURI() != null ? literalMetadataEvent.getPredicate().getURI() : ReadWriteConstants.PREDICATE_HAS_LITERAL_METADATA;
        if (literalMetadataEvent.getPredicate().getStringRepresentation() != null) {
            xMLStreamWriter.writeAttribute(ReadWriteConstants.ATTRIBUTE_STRING_KEY.getNamespaceURI(), ReadWriteConstants.ATTRIBUTE_STRING_KEY.getLocalPart(), literalMetadataEvent.getPredicate().getStringRepresentation());
        }
        xMLStreamWriter.writeAttribute(ATTR_PROPERTY.getLocalPart(), AbstractNeXMLDataReceiverMixin.obtainPrefix(neXMLWriterStreamDataProvider, qName.getNamespaceURI()) + ":" + qName.getLocalPart());
        if (literalMetadataEvent.getOriginalType() != null && literalMetadataEvent.getOriginalType().getURI() != null) {
            xMLStreamWriter.writeAttribute(ATTR_DATATYPE.getLocalPart(), AbstractNeXMLDataReceiverMixin.obtainPrefix(neXMLWriterStreamDataProvider, literalMetadataEvent.getOriginalType().getURI().getNamespaceURI()) + ":" + literalMetadataEvent.getOriginalType().getURI().getLocalPart());
        }
        if (literalMetadataEvent.getAlternativeStringValue() != null) {
            xMLStreamWriter.writeAttribute(ATTR_CONTENT.getLocalPart(), literalMetadataEvent.getAlternativeStringValue());
        }
        neXMLWriterStreamDataProvider.setCurrentLiteralMetaSequenceType(literalMetadataEvent.getSequenceType());
        neXMLWriterStreamDataProvider.setCurrentLiteralMetaDatatype(literalMetadataEvent.getOriginalType());
    }

    public static void checkLiteralMeta(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, LiteralMetadataEvent literalMetadataEvent) throws XMLStreamException, JPhyloIOWriterException {
        if (literalMetadataEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
            QName qName;
            neXMLWriterStreamDataProvider.addToDocumentIDs(literalMetadataEvent.getID());
            if (literalMetadataEvent.getPredicate().getURI() != null) {
                qName = literalMetadataEvent.getPredicate().getURI();
                neXMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(neXMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
            } else {
                qName = ReadWriteConstants.PREDICATE_HAS_LITERAL_METADATA;
                neXMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(neXMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
            }
            if (literalMetadataEvent.getPredicate().getStringRepresentation() != null) {
                qName = ReadWriteConstants.ATTRIBUTE_STRING_KEY;
                neXMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(neXMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
            }
            if (literalMetadataEvent.getOriginalType() != null && literalMetadataEvent.getOriginalType().getURI() != null) {
                qName = literalMetadataEvent.getOriginalType().getURI();
                neXMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(neXMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
            }
        }
    }

    public static void handleLiteralContentMeta(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, LiteralMetadataContentEvent literalMetadataContentEvent) throws XMLStreamException, ClassCastException, IOException {
        XMLStreamWriter xMLStreamWriter = neXMLWriterStreamDataProvider.getWriter();
        switch (neXMLWriterStreamDataProvider.getCurrentLiteralMetaSequenceType()) {
            case SIMPLE: {
                QName qName = null;
                if (neXMLWriterStreamDataProvider.getCurrentLiteralMetaDatatype() != null) {
                    qName = neXMLWriterStreamDataProvider.getCurrentLiteralMetaDatatype().getURI();
                }
                ObjectTranslator<?> objectTranslator = readWriteParameterMap.getObjectTranslatorFactory().getDefaultTranslatorWithPossiblyInvalidNamespace(qName);
                if (literalMetadataContentEvent.hasObjectValue()) {
                    if (objectTranslator != null) {
                        objectTranslator.writeXMLRepresentation(xMLStreamWriter, literalMetadataContentEvent.getObjectValue(), null);
                        break;
                    }
                    if (literalMetadataContentEvent.hasStringValue()) {
                        xMLStreamWriter.writeCharacters(literalMetadataContentEvent.getStringValue());
                        break;
                    }
                    xMLStreamWriter.writeCharacters(literalMetadataContentEvent.getObjectValue().toString());
                    break;
                }
                if (!literalMetadataContentEvent.hasStringValue()) break;
                xMLStreamWriter.writeCharacters(literalMetadataContentEvent.getStringValue());
                break;
            }
            case XML: {
                if (!literalMetadataContentEvent.hasXMLEventValue()) break;
                XMLReadWriteUtils.writeCustomXML(xMLStreamWriter, readWriteParameterMap, literalMetadataContentEvent.getXMLEvent());
            }
        }
        neXMLWriterStreamDataProvider.setLiteralContentIsContinued(literalMetadataContentEvent.isContinuedInNextEvent());
    }

    public static void checkLiteralContentMeta(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, LiteralMetadataContentEvent literalMetadataContentEvent) throws XMLStreamException {
        XMLReadWriteUtils.manageLiteralContentMetaNamespaces(neXMLWriterStreamDataProvider, readWriteParameterMap, literalMetadataContentEvent);
    }

    public static void handleResourceMeta(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, ResourceMetadataEvent resourceMetadataEvent) throws ClassCastException, XMLStreamException, JPhyloIOWriterException {
        XMLStreamWriter xMLStreamWriter = neXMLWriterStreamDataProvider.getWriter();
        String string = neXMLWriterStreamDataProvider.getNeXMLPrefix(neXMLWriterStreamDataProvider.getWriter()) + ":" + "ResourceMeta";
        xMLStreamWriter.writeStartElement(TAG_META.getLocalPart());
        neXMLWriterStreamDataProvider.writeLabeledIDAttributes(resourceMetadataEvent, resourceMetadataEvent.getAbout());
        xMLStreamWriter.writeAttribute(XMLReadWriteUtils.getXSIPrefix(neXMLWriterStreamDataProvider.getWriter()), ATTR_XSI_TYPE.getNamespaceURI(), ATTR_XSI_TYPE.getLocalPart(), string);
        QName qName = resourceMetadataEvent.getRel().getURI() != null ? resourceMetadataEvent.getRel().getURI() : ReadWriteConstants.PREDICATE_HAS_LITERAL_METADATA;
        if (resourceMetadataEvent.getRel().getStringRepresentation() != null) {
            xMLStreamWriter.writeAttribute(ReadWriteConstants.ATTRIBUTE_STRING_KEY.getNamespaceURI(), ReadWriteConstants.ATTRIBUTE_STRING_KEY.getLocalPart(), resourceMetadataEvent.getRel().getStringRepresentation());
        }
        xMLStreamWriter.writeAttribute(ATTR_REL.getLocalPart(), AbstractNeXMLDataReceiverMixin.obtainPrefix(neXMLWriterStreamDataProvider, qName.getNamespaceURI()) + ":" + qName.getLocalPart());
        if (resourceMetadataEvent.getHRef() != null) {
            xMLStreamWriter.writeAttribute(ATTR_HREF.getLocalPart(), resourceMetadataEvent.getHRef().toString());
        }
    }

    public static void checkResourceMeta(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, ResourceMetadataEvent resourceMetadataEvent) throws IOException, XMLStreamException {
        if (resourceMetadataEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
            QName qName;
            neXMLWriterStreamDataProvider.addToDocumentIDs(resourceMetadataEvent.getID());
            if (resourceMetadataEvent.getRel().getURI() != null) {
                qName = resourceMetadataEvent.getRel().getURI();
                neXMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(neXMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
            } else {
                qName = ReadWriteConstants.PREDICATE_HAS_LITERAL_METADATA;
                neXMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(neXMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
            }
            if (resourceMetadataEvent.getRel().getStringRepresentation() != null) {
                qName = ReadWriteConstants.ATTRIBUTE_STRING_KEY;
                neXMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(neXMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
            }
        }
    }

    public static void handleMetaEndEvent(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.LITERAL_META)) {
            if (neXMLWriterStreamDataProvider.isLiteralContentContinued()) {
                throw new InconsistentAdapterDataException("A literal meta end event was encountered, although the last literal meta content event was marked to be continued in a subsequent event.");
            }
            neXMLWriterStreamDataProvider.setCurrentLiteralMetaSequenceType(null);
        }
        neXMLWriterStreamDataProvider.getWriter().writeEndElement();
    }

    public static void handleComment(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, CommentEvent commentEvent) throws ClassCastException, XMLStreamException {
        String string = commentEvent.getContent();
        if (!string.isEmpty()) {
            neXMLWriterStreamDataProvider.getCommentContent().append(string);
        }
        if (!commentEvent.isContinuedInNextEvent()) {
            neXMLWriterStreamDataProvider.getWriter().writeComment(neXMLWriterStreamDataProvider.getCommentContent().toString());
            neXMLWriterStreamDataProvider.getCommentContent().delete(0, neXMLWriterStreamDataProvider.getCommentContent().length());
        }
    }

    private static String obtainPrefix(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, String string) throws XMLStreamException, JPhyloIOWriterException {
        String string2 = neXMLWriterStreamDataProvider.getWriter().getPrefix(string);
        if (string2 == null) {
            throw new JPhyloIOWriterException("The namespace \"" + string + "\" is not bound to a prefix.");
        }
        return string2;
    }
}

