/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml.elementreader;

import info.bioinfweb.commons.io.W3CXSConstants;
import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLEventReader;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexml.elementreader.AbstractNeXMLElementReader;
import info.bioinfweb.jphyloio.objecttranslation.InvalidObjectSourceDataException;
import info.bioinfweb.jphyloio.objecttranslation.ObjectTranslator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class NeXMLMetaStartElementReader
extends AbstractNeXMLElementReader {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readEvent(NeXMLReaderStreamDataProvider neXMLReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
        StartElement startElement = xMLEvent.asStartElement();
        AbstractNeXMLElementReader.LabeledIDEventInformation labeledIDEventInformation = this.getLabeledIDEventInformation(neXMLReaderStreamDataProvider, startElement);
        QName qName = neXMLReaderStreamDataProvider.getEventReader().parseQName(XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_XSI_TYPE, null), startElement);
        if (qName.getLocalPart().equals("LiteralMeta")) {
            neXMLReaderStreamDataProvider.getMetaType().push(EventContentType.LITERAL_META);
            URIOrStringIdentifier uRIOrStringIdentifier = new URIOrStringIdentifier(null, neXMLReaderStreamDataProvider.getEventReader().parseQName(XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_PROPERTY, null), startElement));
            QName qName2 = neXMLReaderStreamDataProvider.getEventReader().parseQName(XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_DATATYPE, null), startElement);
            String string = XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_CONTENT, null);
            URIOrStringIdentifier uRIOrStringIdentifier2 = null;
            if (qName2 != null) {
                uRIOrStringIdentifier2 = new URIOrStringIdentifier(null, qName2);
            }
            neXMLReaderStreamDataProvider.setAlternativeStringRepresentation(string);
            LiteralContentSequenceType literalContentSequenceType = LiteralContentSequenceType.XML;
            ObjectTranslator<NeXMLEventReader> objectTranslator = neXMLReaderStreamDataProvider.getParameters().getObjectTranslatorFactory().getDefaultTranslatorWithPossiblyInvalidNamespace(qName2);
            if (objectTranslator != null) {
                literalContentSequenceType = LiteralContentSequenceType.SIMPLE;
            }
            neXMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataEvent(labeledIDEventInformation.id, labeledIDEventInformation.label, uRIOrStringIdentifier, string, uRIOrStringIdentifier2, literalContentSequenceType));
            neXMLReaderStreamDataProvider.setCurrentLiteralContentSequenceType(literalContentSequenceType);
            XMLEvent xMLEvent2 = neXMLReaderStreamDataProvider.getXMLReader().peek();
            if (xMLEvent2.getEventType() == 2 && string != null) {
                if (objectTranslator != null) {
                    try {
                        Object obj = objectTranslator.representationToJava(string, neXMLReaderStreamDataProvider);
                        neXMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent(obj, string));
                        return;
                    }
                    catch (InvalidObjectSourceDataException invalidObjectSourceDataException) {
                        throw new JPhyloIOReaderException("The content of this meta tag could not be parsed to class " + objectTranslator.getObjectClass().getSimpleName() + ".", xMLEvent.getLocation());
                    }
                } else {
                    neXMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent((Object)string, string));
                }
                return;
            } else {
                if (qName2 == null || qName2.equals(W3CXSConstants.DATA_TYPE_TOKEN) || qName2.equals(W3CXSConstants.DATA_TYPE_STRING) || objectTranslator == null) return;
                Object var13_19 = null;
                if (objectTranslator.hasStringRepresentation()) {
                    String string2 = XMLUtils.readCharactersAsString((XMLEventReader)neXMLReaderStreamDataProvider.getXMLReader());
                    if (string2 == null) return;
                    try {
                        if (!"".equals(string2.trim())) {
                            var13_19 = objectTranslator.representationToJava(string2, neXMLReaderStreamDataProvider);
                            neXMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent(var13_19, string2));
                            return;
                        }
                        if (string == null || string.isEmpty()) return;
                        var13_19 = objectTranslator.representationToJava(string, neXMLReaderStreamDataProvider);
                        neXMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent(var13_19, string));
                        return;
                    }
                    catch (InvalidObjectSourceDataException invalidObjectSourceDataException) {
                        throw new JPhyloIOReaderException("The nested content of this meta tag could not be parsed to class " + objectTranslator.getObjectClass().getSimpleName() + ".", xMLEvent.getLocation());
                    }
                } else {
                    try {
                        var13_19 = objectTranslator.readXMLRepresentation(neXMLReaderStreamDataProvider.getXMLReader(), neXMLReaderStreamDataProvider);
                        neXMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent((Object)var13_19, null));
                        return;
                    }
                    catch (InvalidObjectSourceDataException invalidObjectSourceDataException) {
                        throw new JPhyloIOReaderException("The nested XML content of this meta tag could not be parsed to class " + objectTranslator.getObjectClass().getSimpleName() + ".", xMLEvent.getLocation());
                    }
                }
            }
        }
        if (!qName.getLocalPart().equals("ResourceMeta")) throw new JPhyloIOReaderException("Meta annotations can only be of type \"LiteralMeta\" or \"ResourceMeta\".", startElement.getLocation());
        neXMLReaderStreamDataProvider.getMetaType().push(EventContentType.RESOURCE_META);
        URIOrStringIdentifier uRIOrStringIdentifier = new URIOrStringIdentifier(null, neXMLReaderStreamDataProvider.getEventReader().parseQName(XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_REL, null), startElement));
        String string = XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_ABOUT, null);
        String string3 = XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_HREF, null);
        URI uRI = null;
        if (string3 != null) {
            try {
                uRI = new URI(string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new JPhyloIOReaderException("An \"href\"-attribute element must specify a valid URI. Instead the string \"" + string3 + "\" was found.", xMLEvent.getLocation());
            }
        }
        neXMLReaderStreamDataProvider.getCurrentEventCollection().add(new ResourceMetadataEvent(labeledIDEventInformation.id, labeledIDEventInformation.label, uRIOrStringIdentifier, uRI, string));
    }
}

