/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml.elementreader;

import info.bioinfweb.commons.bio.CharacterStateSetType;
import info.bioinfweb.commons.bio.CharacterSymbolMeaning;
import info.bioinfweb.commons.collections.PackedObjectArrayList;
import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.CharacterSetIntervalEvent;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLConstants;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexml.TokenTranslationStrategy;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.AbstractXMLElementReader;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.XMLElementReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractNeXMLElementReader
extends AbstractXMLElementReader<NeXMLReaderStreamDataProvider>
implements XMLElementReader<NeXMLReaderStreamDataProvider>,
NeXMLConstants,
ReadWriteConstants {
    protected List<String> readSequence(NeXMLReaderStreamDataProvider neXMLReaderStreamDataProvider, String string, TokenTranslationStrategy tokenTranslationStrategy) throws JPhyloIOReaderException, XMLStreamException {
        ArrayList<String> arrayList;
        block13: {
            block12: {
                int n;
                arrayList = new ArrayList<String>();
                String string2 = "";
                String string3 = "";
                if (!neXMLReaderStreamDataProvider.isAllowLongTokens()) break block12;
                if (neXMLReaderStreamDataProvider.getIncompleteToken() != null) {
                    string3 = neXMLReaderStreamDataProvider.getIncompleteToken();
                    neXMLReaderStreamDataProvider.setIncompleteToken(null);
                }
                for (n = 0; n < string.length(); ++n) {
                    Character c = Character.valueOf(string.charAt(n));
                    if (!Character.isWhitespace(c.charValue())) {
                        string3 = string3 + c;
                        continue;
                    }
                    if (!string3.isEmpty()) {
                        arrayList.add(string3);
                    }
                    string3 = "";
                }
                string2 = string3;
                if (!Character.isWhitespace(string.charAt(string.length() - 1))) {
                    XMLEvent xMLEvent = neXMLReaderStreamDataProvider.getXMLReader().peek();
                    if (xMLEvent != null && xMLEvent.getEventType() == 4 && !Character.isWhitespace(xMLEvent.asCharacters().getData().charAt(0))) {
                        neXMLReaderStreamDataProvider.setIncompleteToken(string2);
                    } else if (!string3.isEmpty()) {
                        arrayList.add(string3);
                    }
                }
                if (!neXMLReaderStreamDataProvider.getCharacterSetType().equals((Object)CharacterStateSetType.DISCRETE) || tokenTranslationStrategy.equals((Object)TokenTranslationStrategy.NEVER)) break block13;
                for (n = 0; n < arrayList.size(); ++n) {
                    if (((String)arrayList.get(n)).equals("-") || ((String)arrayList.get(n)).equals("?")) continue;
                    try {
                        int n2 = Integer.parseInt((String)arrayList.get(n));
                        arrayList.set(n, neXMLReaderStreamDataProvider.getTokenSets().get(neXMLReaderStreamDataProvider.getCharIDToStatesMap().get(neXMLReaderStreamDataProvider.getCharIDs().get(n))).getSymbolTranslationMap().get(n2));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JPhyloIOReaderException("The symbol \"" + (String)arrayList.get(n) + "\" of a standard data token definition must be of type Integer.", neXMLReaderStreamDataProvider.getXMLReader().peek().getLocation());
                    }
                }
                break block13;
            }
            for (int i = 0; i < string.length(); ++i) {
                Character c = Character.valueOf(string.charAt(i));
                if (Character.isWhitespace(c.charValue())) continue;
                arrayList.add(c.toString());
            }
        }
        return arrayList;
    }

    protected void createIntervalEvents(NeXMLReaderStreamDataProvider neXMLReaderStreamDataProvider, String[] stringArray) throws JPhyloIOReaderException, XMLStreamException {
        PackedObjectArrayList packedObjectArrayList = new PackedObjectArrayList(2, neXMLReaderStreamDataProvider.getCharIDs().size());
        for (int i = 0; i < neXMLReaderStreamDataProvider.getCharIDs().size(); ++i) {
            packedObjectArrayList.add((Object)false);
        }
        for (String string : stringArray) {
            if (!neXMLReaderStreamDataProvider.getCharIDToIndexMap().containsKey(string)) {
                throw new JPhyloIOReaderException("A character set referenced the ID \"" + string + "\" of a character that was not specified before.", neXMLReaderStreamDataProvider.getXMLReader().peek().getLocation());
            }
            packedObjectArrayList.set(neXMLReaderStreamDataProvider.getCharIDToIndexMap().get(string).intValue(), (Object)true);
        }
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < packedObjectArrayList.size(); ++i) {
            if (((Boolean)packedObjectArrayList.get(i)).booleanValue()) {
                n = i;
            }
            if (i == 0 || ((Boolean)packedObjectArrayList.get(i)).booleanValue() && !((Boolean)packedObjectArrayList.get(i - 1)).booleanValue()) {
                n2 = i;
            }
            if (!((Boolean)packedObjectArrayList.get(i)).booleanValue() || i + 1 != packedObjectArrayList.size() && ((Boolean)packedObjectArrayList.get(i + 1)).booleanValue()) continue;
            neXMLReaderStreamDataProvider.getCurrentEventCollection().add(new CharacterSetIntervalEvent(n2, n + 1));
        }
    }

    protected LabeledIDEventInformation getLabeledIDEventInformation(NeXMLReaderStreamDataProvider neXMLReaderStreamDataProvider, StartElement startElement) throws JPhyloIOReaderException {
        LabeledIDEventInformation labeledIDEventInformation = new LabeledIDEventInformation();
        labeledIDEventInformation.id = XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_ID, null);
        labeledIDEventInformation.label = XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_LABEL, null);
        if (labeledIDEventInformation.id == null || !org.semanticweb.owlapi.io.XMLUtils.isNCName((CharSequence)labeledIDEventInformation.id)) {
            if (startElement.getName().equals(TAG_META)) {
                labeledIDEventInformation.id = "info.bioinfweb.jphyloio.reservedIDs.meta" + neXMLReaderStreamDataProvider.getIDManager().createNewID();
            } else if (startElement.getName().equals(TAG_CHAR)) {
                labeledIDEventInformation.id = "info.bioinfweb.jphyloio.reservedIDs.char" + neXMLReaderStreamDataProvider.getIDManager().createNewID();
            }
        }
        if (labeledIDEventInformation.id != null) {
            return labeledIDEventInformation;
        }
        throw new JPhyloIOReaderException("The element \"" + startElement.getName().getLocalPart() + "\" must specify an ID.", startElement.getLocation());
    }

    protected OTUorOTUsEventInformation getOTUorOTUsEventInformation(NeXMLReaderStreamDataProvider neXMLReaderStreamDataProvider, StartElement startElement) throws JPhyloIOReaderException {
        LabeledIDEventInformation labeledIDEventInformation = this.getLabeledIDEventInformation(neXMLReaderStreamDataProvider, startElement);
        OTUorOTUsEventInformation oTUorOTUsEventInformation = new OTUorOTUsEventInformation();
        oTUorOTUsEventInformation.id = labeledIDEventInformation.id;
        oTUorOTUsEventInformation.label = labeledIDEventInformation.label;
        oTUorOTUsEventInformation.otuOrOtusID = XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_SINGLE_OTU_LINK, null);
        if (oTUorOTUsEventInformation.otuOrOtusID == null) {
            oTUorOTUsEventInformation.otuOrOtusID = XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_OTUS, null);
        }
        if (oTUorOTUsEventInformation.label == null && oTUorOTUsEventInformation.otuOrOtusID != null && neXMLReaderStreamDataProvider.getParameters().getBoolean("info.bioinfweb.jphyloio.useOTULabel", false)) {
            oTUorOTUsEventInformation.label = neXMLReaderStreamDataProvider.getOTUIDToLabelMap().get(oTUorOTUsEventInformation.otuOrOtusID);
        }
        return oTUorOTUsEventInformation;
    }

    public static CharacterSymbolMeaning parseStateMeaning(String string) {
        CharacterSymbolMeaning characterSymbolMeaning = null;
        if (string.length() == 1) {
            characterSymbolMeaning = CharacterSymbolMeaning.meaningByDefaultSymbol((char)string.charAt(0));
        }
        if (characterSymbolMeaning == null) {
            characterSymbolMeaning = CharacterSymbolMeaning.CHARACTER_STATE;
        }
        return characterSymbolMeaning;
    }

    protected static class OTUorOTUsEventInformation
    extends LabeledIDEventInformation {
        public String otuOrOtusID;

        protected OTUorOTUsEventInformation() {
        }
    }

    protected static class LabeledIDEventInformation {
        public String id;
        public String label;

        protected LabeledIDEventInformation() {
        }
    }
}

