/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml;

import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.exception.JPhyloIOWriterException;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLConstants;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLEventWriter;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterAlignmentInformation;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterTokenSetInformation;
import info.bioinfweb.jphyloio.formats.xml.XMLWriterStreamDataProvider;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class NeXMLWriterStreamDataProvider
extends XMLWriterStreamDataProvider<NeXMLEventWriter>
implements NeXMLConstants {
    private Set<String> documentIDs = new HashSet<String>();
    private int idIndex = 0;
    private LiteralContentSequenceType currentLiteralMetaSequenceType;
    private URIOrStringIdentifier currentLiteralMetaDatatype;
    private Map<String, EnumMap<EventContentType, Set<String>>> setIDToSetElementsMap = new HashMap<String, EnumMap<EventContentType, Set<String>>>();
    private boolean hasOTUList = true;
    private boolean writeUndefinedOTU = false;
    private boolean writeUndefinedOtuList = false;
    private String undefinedOTUID;
    private String undefinedOTUsID;
    private NeXMLWriterAlignmentInformation currentAlignmentInfo;
    private Map<String, NeXMLWriterAlignmentInformation> alignmentInfoByIDMap = new HashMap<String, NeXMLWriterAlignmentInformation>();
    private NeXMLWriterTokenSetInformation currentTokenSetInfo;
    private String singleToken = null;

    public NeXMLWriterStreamDataProvider(NeXMLEventWriter neXMLEventWriter) {
        super(neXMLEventWriter);
    }

    public Set<String> getDocumentIDs() {
        return this.documentIDs;
    }

    public int getIDIndex() {
        return this.idIndex;
    }

    public void setIDIndex(int n) {
        this.idIndex = n;
    }

    public void addToDocumentIDs(String string) throws JPhyloIOWriterException {
        if (!this.getDocumentIDs().add(string)) {
            throw new InconsistentAdapterDataException("The encountered ID " + string + " already exists in the document. IDs have to be unique.");
        }
    }

    public boolean hasOTUList() {
        return this.hasOTUList;
    }

    public void setHasOTUList(boolean bl) {
        this.hasOTUList = bl;
    }

    public LiteralContentSequenceType getCurrentLiteralMetaSequenceType() {
        return this.currentLiteralMetaSequenceType;
    }

    public void setCurrentLiteralMetaSequenceType(LiteralContentSequenceType literalContentSequenceType) {
        this.currentLiteralMetaSequenceType = literalContentSequenceType;
    }

    public URIOrStringIdentifier getCurrentLiteralMetaDatatype() {
        return this.currentLiteralMetaDatatype;
    }

    public void setCurrentLiteralMetaDatatype(URIOrStringIdentifier uRIOrStringIdentifier) {
        this.currentLiteralMetaDatatype = uRIOrStringIdentifier;
    }

    public Map<String, EnumMap<EventContentType, Set<String>>> getSetIDToSetElementsMap() {
        return this.setIDToSetElementsMap;
    }

    public NeXMLWriterAlignmentInformation getCurrentAlignmentInfo() {
        return this.currentAlignmentInfo;
    }

    public void setCurrentAlignmentInfo(NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation) {
        this.currentAlignmentInfo = neXMLWriterAlignmentInformation;
    }

    public Map<String, NeXMLWriterAlignmentInformation> getAlignmentInfoByIDMap() {
        return this.alignmentInfoByIDMap;
    }

    public NeXMLWriterTokenSetInformation getCurrentTokenSetInfo() {
        return this.currentTokenSetInfo;
    }

    public void setCurrentTokenSetInfo(NeXMLWriterTokenSetInformation neXMLWriterTokenSetInformation) {
        this.currentTokenSetInfo = neXMLWriterTokenSetInformation;
    }

    public String getSingleToken() {
        return this.singleToken;
    }

    public void setSingleToken(String string) {
        this.singleToken = string;
    }

    public boolean isWriteUndefinedOTU() {
        return this.writeUndefinedOTU;
    }

    public void setWriteUndefinedOTU(boolean bl) {
        this.writeUndefinedOTU = bl;
    }

    public boolean isWriteUndefinedOtuList() {
        return this.writeUndefinedOtuList;
    }

    public void setWriteUndefinedOtuList(boolean bl) {
        this.writeUndefinedOtuList = bl;
    }

    public String getUndefinedOTUID() {
        return this.undefinedOTUID;
    }

    public void setUndefinedOTUID(String string) {
        this.undefinedOTUID = string;
    }

    public String getUndefinedOTUsID() {
        return this.undefinedOTUsID;
    }

    public void setUndefinedOTUsID(String string) {
        this.undefinedOTUsID = string;
    }

    public String createNewID(String string) {
        String string2;
        do {
            string2 = string + this.getIDIndex();
            this.setIDIndex(this.getIDIndex() + 1);
        } while (this.getDocumentIDs().contains(string2));
        return string2;
    }

    public void writeLabeledIDAttributes(LabeledIDEvent labeledIDEvent) throws XMLStreamException, JPhyloIOWriterException {
        this.writeLabeledIDAttributes(labeledIDEvent, labeledIDEvent.getID());
    }

    public void writeLabeledIDAttributes(LabeledIDEvent labeledIDEvent, String string) throws XMLStreamException, JPhyloIOWriterException {
        this.getWriter().writeAttribute(ATTR_ID.getLocalPart(), labeledIDEvent.getID());
        if (string != null) {
            this.getWriter().writeAttribute(ATTR_ABOUT.getLocalPart(), "#" + string);
        }
        if (labeledIDEvent.hasLabel()) {
            this.getWriter().writeAttribute(ATTR_LABEL.getLocalPart(), labeledIDEvent.getLabel());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeLinkedLabeledIDAttributes(LinkedLabeledIDEvent linkedLabeledIDEvent, QName qName, boolean bl) throws XMLStreamException, JPhyloIOWriterException {
        this.writeLabeledIDAttributes(linkedLabeledIDEvent);
        if (linkedLabeledIDEvent.hasLink()) {
            if (!this.hasOTUList()) throw new InconsistentAdapterDataException("An element links to an OTU list or OTU though no OTU list exists in the document.");
            if (!this.getDocumentIDs().contains(linkedLabeledIDEvent.getLinkedID())) {
                throw new InconsistentAdapterDataException("An element links to a non-existent OTU list or OTU.");
            }
            this.getWriter().writeAttribute(qName.getLocalPart(), linkedLabeledIDEvent.getLinkedID());
            return;
        } else {
            if (!bl) return;
            if (qName.equals(TAG_OTUS)) {
                this.getWriter().writeAttribute(qName.getLocalPart(), this.getUndefinedOTUsID());
                return;
            } else {
                if (!qName.equals(TAG_OTU)) return;
                this.getWriter().writeAttribute(qName.getLocalPart(), this.getUndefinedOTUID());
            }
        }
    }

    public String getNeXMLPrefix(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamWriter.getPrefix("http://www.nexml.org/2009");
        if (string == null || string.isEmpty()) {
            string = "nex";
        }
        return string;
    }
}

