/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml;

import info.bioinfweb.commons.bio.CharacterStateSetType;
import info.bioinfweb.commons.bio.SequenceUtils;
import info.bioinfweb.jphyloio.JPhyloIO;
import info.bioinfweb.jphyloio.dataadapters.AnnotatedDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.DocumentDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.MatrixDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.OTUListDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.ObjectListDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.TreeNetworkDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.TreeNetworkGroupDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.implementations.UndefinedOTUListDataAdapter;
import info.bioinfweb.jphyloio.events.CharacterDefinitionEvent;
import info.bioinfweb.jphyloio.events.EdgeEvent;
import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.NodeEvent;
import info.bioinfweb.jphyloio.events.TokenSetDefinitionEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.exception.JPhyloIOWriterException;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLConstants;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterAlignmentInformation;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterTokenSetInformation;
import info.bioinfweb.jphyloio.formats.nexml.receivers.AbstractNeXMLDataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLAttributeMetadataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLCharacterSetEventReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLCollectCharSetDataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLCollectNamespaceReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLCollectSequenceDataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLCollectSetMetadataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLCollectTokenSetDefinitionDataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLIgnoreCertainMetadataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLMetaDataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLMolecularDataTokenDefinitionReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLOnlyWriteMetaDataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLSequenceTokensReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLTokenSetEventReceiver;
import info.bioinfweb.jphyloio.formats.xml.AbstractXMLEventWriter;
import info.bioinfweb.jphyloio.formats.xml.XMLReadWriteUtils;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class NeXMLEventWriter
extends AbstractXMLEventWriter<NeXMLWriterStreamDataProvider>
implements NeXMLConstants {
    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.nexml";
    }

    @Override
    protected NeXMLWriterStreamDataProvider createStreamDataProvider() {
        return new NeXMLWriterStreamDataProvider(this);
    }

    @Override
    protected void doWriteDocument() throws IOException, XMLStreamException {
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setNamespacePrefix(((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNeXMLPrefix(this.getXMLWriter()), "http://www.nexml.org/2009");
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setNamespacePrefix(XMLReadWriteUtils.getXSIPrefix(this.getXMLWriter()), "http://www.w3.org/2001/XMLSchema-instance");
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setNamespacePrefix(XMLReadWriteUtils.getXSDPrefix(this.getXMLWriter()), "http://www.w3.org/2001/XMLSchema");
        this.checkDocument(this.getDocument());
        this.getXMLWriter().writeStartElement(TAG_ROOT.getLocalPart());
        this.getXMLWriter().writeDefaultNamespace("http://www.nexml.org/2009");
        this.getXMLWriter().writeAttribute(ATTR_VERSION.getLocalPart(), "0.9");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getParameters().getString("info.bioinfweb.jphyloio.applicationName") != null) {
            stringBuilder.append(this.getParameters().getString("info.bioinfweb.jphyloio.applicationName"));
            stringBuilder.append(" ");
            if (this.getParameters().getObject("info.bioinfweb.jphyloio.applicationVersion", null) != null) {
                stringBuilder.append(this.getParameters().getObject("info.bioinfweb.jphyloio.applicationVersion", null).toString());
                stringBuilder.append(" ");
            }
            stringBuilder.append("using ");
        }
        stringBuilder.append(JPhyloIO.getInstance().getLibraryNameAndVersion());
        this.getXMLWriter().writeAttribute(ATTR_GENERATOR.getLocalPart(), stringBuilder.toString());
        for (String string : ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNamespacePrefixes()) {
            this.getXMLWriter().writeNamespace(string, this.getXMLWriter().getNamespaceContext().getNamespaceURI(string));
        }
        this.getXMLWriter().writeComment(" " + this.getFileStartInfo(this.getParameters()) + " ");
        this.writeOrCheckMetaData(this.getDocument(), false);
        this.writeOTUSTags(this.getDocument());
        this.writeCharactersTags(this.getDocument());
        this.writeTreesTags(this.getDocument());
        this.getXMLWriter().writeEndElement();
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setUndefinedOTUID(null);
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setUndefinedOTUsID(null);
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getDocumentIDs().clear();
    }

    private void checkDocument(DocumentDataAdapter documentDataAdapter) throws IOException {
        this.writeOrCheckMetaData(documentDataAdapter, true);
        if (documentDataAdapter.getOTUListCount(this.getParameters()) > 0L) {
            this.checkOTUSTags(documentDataAdapter);
        } else {
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setHasOTUList(false);
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setWriteUndefinedOtuList(true);
        }
        if (documentDataAdapter.getMatrixIterator(this.getParameters()).hasNext()) {
            this.checkCharactersTags(documentDataAdapter);
        }
        if (documentDataAdapter.getTreeNetworkGroupIterator(this.getParameters()).hasNext()) {
            this.checkTreeAndNetworkGroups(documentDataAdapter);
        }
    }

    private void writeOrCheckMetaData(AnnotatedDataAdapter annotatedDataAdapter, boolean bl) throws IOException {
        AbstractNeXMLDataReceiver abstractNeXMLDataReceiver = bl ? new NeXMLCollectNamespaceReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters()) : new NeXMLMetaDataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters());
        annotatedDataAdapter.writeMetadata(this.getParameters(), abstractNeXMLDataReceiver);
    }

    private void writeOrCheckObjectMetaData(ObjectListDataAdapter<?> objectListDataAdapter, String string, boolean bl) throws IOException {
        AbstractNeXMLDataReceiver abstractNeXMLDataReceiver = bl ? new NeXMLCollectNamespaceReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters()) : new NeXMLMetaDataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters());
        if (string != null) {
            objectListDataAdapter.writeContentData(this.getParameters(), abstractNeXMLDataReceiver, string);
        }
    }

    private void writeSetTags(EnumMap<EventContentType, String> enumMap, ObjectListDataAdapter<LinkedLabeledIDEvent> objectListDataAdapter) throws XMLStreamException, IllegalArgumentException, IOException {
        NeXMLOnlyWriteMetaDataReceiver neXMLOnlyWriteMetaDataReceiver = new NeXMLOnlyWriteMetaDataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters());
        Iterator<String> iterator = objectListDataAdapter.getIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.getXMLWriter().writeStartElement(TAG_SET.getLocalPart());
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes(objectListDataAdapter.getObjectStartEvent(this.getParameters(), string));
            for (EventContentType eventContentType : enumMap.keySet()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string2 : ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getSetIDToSetElementsMap().get(string).get((Object)eventContentType)) {
                    stringBuffer.append(string2);
                    stringBuffer.append(" ");
                }
                if (stringBuffer.length() == 0) continue;
                this.getXMLWriter().writeAttribute(enumMap.get((Object)eventContentType), stringBuffer.toString());
            }
            objectListDataAdapter.writeContentData(this.getParameters(), neXMLOnlyWriteMetaDataReceiver, string);
            this.getXMLWriter().writeEndElement();
        }
    }

    private void checkSets(EnumMap<EventContentType, String> enumMap, EventContentType eventContentType, ObjectListDataAdapter<LinkedLabeledIDEvent> objectListDataAdapter) throws IllegalArgumentException, IOException {
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator<String> iterator = objectListDataAdapter.getIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            String string = iterator.next();
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(string);
            treeSet.add(string);
            NeXMLCollectSetMetadataReceiver neXMLCollectSetMetadataReceiver = new NeXMLCollectSetMetadataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), string, false);
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getSetIDToSetElementsMap().put(string, new EnumMap(EventContentType.class));
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getSetIDToSetElementsMap().get(string).put(eventContentType, new TreeSet());
            for (EventContentType eventContentType2 : enumMap.keySet()) {
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getSetIDToSetElementsMap().get(string).put(eventContentType2, new TreeSet());
            }
            objectListDataAdapter.writeContentData(this.getParameters(), neXMLCollectSetMetadataReceiver, string);
            while (!((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getSetIDToSetElementsMap().get(string).get((Object)eventContentType).isEmpty()) {
                HashSet hashSet = new HashSet();
                hashSet.addAll(((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getSetIDToSetElementsMap().get(string).get((Object)eventContentType));
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getSetIDToSetElementsMap().get(string).get((Object)eventContentType).clear();
                neXMLCollectSetMetadataReceiver = new NeXMLCollectSetMetadataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), string, true);
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (treeSet.add(string2)) {
                        objectListDataAdapter.writeContentData(this.getParameters(), neXMLCollectSetMetadataReceiver, string2);
                        continue;
                    }
                    throw new JPhyloIOWriterException("A circular reference was encountered when writing sets.");
                }
            }
            treeSet.clear();
        }
    }

    private void writeOTUSTags(DocumentDataAdapter documentDataAdapter) throws IOException, XMLStreamException {
        Iterator<OTUListDataAdapter> iterator = documentDataAdapter.getOTUListIterator(this.getParameters());
        while (iterator.hasNext()) {
            this.writeOTUSTag(iterator.next());
        }
        if (((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).isWriteUndefinedOtuList()) {
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setUndefinedOTUID(((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("undefinedOTU"));
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setUndefinedOTUsID(((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("undefinedOTUs"));
            UndefinedOTUListDataAdapter undefinedOTUListDataAdapter = new UndefinedOTUListDataAdapter(((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getUndefinedOTUsID(), ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getUndefinedOTUID());
            this.writeOTUSTag(undefinedOTUListDataAdapter);
        }
    }

    private void writeOTUSTag(OTUListDataAdapter oTUListDataAdapter) throws IOException, XMLStreamException {
        Object object;
        this.getXMLWriter().writeStartElement(TAG_OTUS.getLocalPart());
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes((LabeledIDEvent)oTUListDataAdapter.getStartEvent(this.getParameters()));
        this.writeOrCheckMetaData(oTUListDataAdapter, false);
        Iterator<String> iterator = oTUListDataAdapter.getIDIterator(this.getParameters());
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            object = iterator.next();
            hashSet.add((String)object);
            this.getXMLWriter().writeStartElement(TAG_OTU.getLocalPart());
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes((LabeledIDEvent)oTUListDataAdapter.getObjectStartEvent(this.getParameters(), (String)object));
            this.writeOrCheckObjectMetaData(oTUListDataAdapter, (String)object, false);
            this.getXMLWriter().writeEndElement();
        }
        if (((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).isWriteUndefinedOTU() && ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getUndefinedOTUID() == null) {
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setUndefinedOTUID(((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("undefinedOTU"));
            this.getXMLWriter().writeStartElement(TAG_OTU.getLocalPart());
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes(new LabeledIDEvent(EventContentType.OTU, ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getUndefinedOTUID(), "UNDEFINED OTU generated by JPhyloIO"));
            this.getXMLWriter().writeEndElement();
        }
        object = new EnumMap(EventContentType.class);
        ((EnumMap)object).put(EventContentType.OTU, ATTR_OTU_SET_LINKED_IDS.getLocalPart());
        this.writeSetTags((EnumMap<EventContentType, String>)object, oTUListDataAdapter.getOTUSets(this.getParameters()));
        this.getXMLWriter().writeEndElement();
    }

    private void checkOTUSTags(DocumentDataAdapter documentDataAdapter) throws IOException {
        Iterator<OTUListDataAdapter> iterator = documentDataAdapter.getOTUListIterator(this.getParameters());
        while (iterator.hasNext()) {
            this.checkOTUsTag(iterator.next());
        }
    }

    private void checkOTUsTag(OTUListDataAdapter oTUListDataAdapter) throws IOException {
        Object object;
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(((LabeledIDEvent)oTUListDataAdapter.getStartEvent(this.getParameters())).getID());
        this.writeOrCheckMetaData(oTUListDataAdapter, true);
        Iterator<String> iterator = oTUListDataAdapter.getIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            object = iterator.next();
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs((String)object);
            this.writeOrCheckObjectMetaData(oTUListDataAdapter, (String)object, true);
        }
        object = new EnumMap(EventContentType.class);
        ((EnumMap)object).put(EventContentType.OTU, ATTR_OTU_SET_LINKED_IDS.getLocalPart());
        this.checkSets((EnumMap<EventContentType, String>)object, EventContentType.OTU_SET, oTUListDataAdapter.getOTUSets(this.getParameters()));
    }

    private void writeCharactersTags(DocumentDataAdapter documentDataAdapter) throws IOException, XMLStreamException {
        Iterator<MatrixDataAdapter> iterator = documentDataAdapter.getMatrixIterator(this.getParameters());
        while (iterator.hasNext()) {
            this.writeCharactersTag(iterator.next());
        }
    }

    private void writeCharactersTag(MatrixDataAdapter matrixDataAdapter) throws IOException, XMLStreamException {
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getAlignmentInfoByIDMap().get(((LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(this.getParameters())).getID());
        if (neXMLWriterAlignmentInformation.isWriteAlignment()) {
            this.getXMLWriter().writeStartElement(TAG_CHARACTERS.getLocalPart());
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLinkedLabeledIDAttributes((LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(this.getParameters()), TAG_OTUS, true);
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setCurrentAlignmentInfo(neXMLWriterAlignmentInformation);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNeXMLPrefix(this.getXMLWriter()));
            stringBuffer.append(":");
            if (neXMLWriterAlignmentInformation.isWriteCellsTags()) {
                switch (neXMLWriterAlignmentInformation.getAlignmentType()) {
                    case NUCLEOTIDE: 
                    case DNA: {
                        stringBuffer.append("DnaCells");
                        break;
                    }
                    case RNA: {
                        stringBuffer.append("RnaCells");
                        break;
                    }
                    case AMINO_ACID: {
                        stringBuffer.append("ProteinCells");
                        break;
                    }
                    case CONTINUOUS: {
                        stringBuffer.append("ContinuousCells");
                        break;
                    }
                    case DISCRETE: 
                    case UNKNOWN: {
                        stringBuffer.append("StandardCells");
                        break;
                    }
                }
            } else {
                switch (neXMLWriterAlignmentInformation.getAlignmentType()) {
                    case DNA: {
                        stringBuffer.append("DnaSeqs");
                        break;
                    }
                    case RNA: {
                        stringBuffer.append("RnaSeqs");
                        break;
                    }
                    case AMINO_ACID: {
                        stringBuffer.append("ProteinSeqs");
                        break;
                    }
                    case CONTINUOUS: {
                        stringBuffer.append("ContinuousSeqs");
                        break;
                    }
                    case DISCRETE: 
                    case UNKNOWN: {
                        stringBuffer.append("StandardSeqs");
                        break;
                    }
                }
            }
            this.getXMLWriter().writeAttribute(XMLReadWriteUtils.getXSIPrefix(this.getXMLWriter()), ATTR_XSI_TYPE.getNamespaceURI(), ATTR_XSI_TYPE.getLocalPart(), stringBuffer.toString());
            NeXMLIgnoreCertainMetadataReceiver neXMLIgnoreCertainMetadataReceiver = new NeXMLIgnoreCertainMetadataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), false, PREDICATE_FORMAT, PREDICATE_MATRIX);
            matrixDataAdapter.writeMetadata(this.getParameters(), neXMLIgnoreCertainMetadataReceiver);
            this.writeFormatTag(matrixDataAdapter);
            this.getXMLWriter().writeStartElement(TAG_MATRIX.getLocalPart());
            neXMLIgnoreCertainMetadataReceiver = new NeXMLIgnoreCertainMetadataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), true, PREDICATE_MATRIX);
            matrixDataAdapter.writeMetadata(this.getParameters(), neXMLIgnoreCertainMetadataReceiver);
            Iterator<String> iterator = matrixDataAdapter.getSequenceIDIterator(this.getParameters());
            while (iterator.hasNext()) {
                this.writeRowTag(matrixDataAdapter.getSequenceStartEvent(this.getParameters(), iterator.next()), matrixDataAdapter);
            }
            EnumMap<EventContentType, String> enumMap = new EnumMap<EventContentType, String>(EventContentType.class);
            enumMap.put(EventContentType.SEQUENCE, ATTR_SEQUENCE_SET_LINKED_IDS.getLocalPart());
            this.writeSetTags(enumMap, matrixDataAdapter.getSequenceSets(this.getParameters()));
            this.getXMLWriter().writeEndElement();
            this.getXMLWriter().writeEndElement();
        } else {
            this.getParameters().getLogger().addWarning("Alignment data was found but either the number of sequences or the alignment length were zero. Therefore no characters element was written. It is possible that meta or other data was lost because of this.");
        }
    }

    private void writeFormatTag(MatrixDataAdapter matrixDataAdapter) throws XMLStreamException, IllegalArgumentException, IOException {
        this.getXMLWriter().writeStartElement(TAG_FORMAT.getLocalPart());
        NeXMLIgnoreCertainMetadataReceiver neXMLIgnoreCertainMetadataReceiver = new NeXMLIgnoreCertainMetadataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), true, PREDICATE_FORMAT);
        matrixDataAdapter.writeMetadata(this.getParameters(), neXMLIgnoreCertainMetadataReceiver);
        this.writeTokenSetDefinitions(matrixDataAdapter);
        this.writeCharacterDefinitionTags(matrixDataAdapter);
        this.writeCharacterSets(matrixDataAdapter);
        this.getXMLWriter().writeEndElement();
    }

    private void writeTokenSetDefinitions(MatrixDataAdapter matrixDataAdapter) throws XMLStreamException, IllegalArgumentException, IOException {
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setIDIndex(0);
        ObjectListDataAdapter<TokenSetDefinitionEvent> objectListDataAdapter = matrixDataAdapter.getTokenSets(this.getParameters());
        Iterator<String> iterator = objectListDataAdapter.getIDIterator(this.getParameters());
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getAlignmentInfoByIDMap().get(((LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(this.getParameters())).getID());
        if (neXMLWriterAlignmentInformation.hasTokenDefinitionSet()) {
            block8: while (iterator.hasNext()) {
                String string = iterator.next();
                TokenSetDefinitionEvent tokenSetDefinitionEvent = objectListDataAdapter.getObjectStartEvent(this.getParameters(), string);
                NeXMLWriterTokenSetInformation neXMLWriterTokenSetInformation = neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().get(string);
                switch (neXMLWriterAlignmentInformation.getAlignmentType()) {
                    case NUCLEOTIDE: 
                    case CONTINUOUS: {
                        continue block8;
                    }
                    case DNA: 
                    case RNA: 
                    case AMINO_ACID: {
                        NeXMLMolecularDataTokenDefinitionReceiver neXMLMolecularDataTokenDefinitionReceiver = new NeXMLMolecularDataTokenDefinitionReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), string);
                        this.getXMLWriter().writeStartElement(TAG_STATES.getLocalPart());
                        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes(tokenSetDefinitionEvent);
                        objectListDataAdapter.writeContentData(this.getParameters(), neXMLMolecularDataTokenDefinitionReceiver, string);
                        neXMLMolecularDataTokenDefinitionReceiver.addRemainingEvents(neXMLWriterAlignmentInformation.getAlignmentType());
                        this.getXMLWriter().writeEndElement();
                        continue block8;
                    }
                }
                NeXMLTokenSetEventReceiver neXMLTokenSetEventReceiver = new NeXMLTokenSetEventReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), string);
                this.getXMLWriter().writeStartElement(TAG_STATES.getLocalPart());
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes(tokenSetDefinitionEvent);
                objectListDataAdapter.writeContentData(this.getParameters(), neXMLTokenSetEventReceiver, string);
                neXMLWriterTokenSetInformation.getOccuringTokens().removeAll(neXMLWriterTokenSetInformation.getTokenTranslationMap().keySet());
                if (!neXMLWriterTokenSetInformation.getOccuringTokens().isEmpty()) {
                    neXMLTokenSetEventReceiver.writeRemainingStandardTokenDefinitions();
                }
                this.getXMLWriter().writeEndElement();
            }
        }
        if (neXMLWriterAlignmentInformation.isWriteDefaultTokenSet()) {
            switch (neXMLWriterAlignmentInformation.getAlignmentType()) {
                case NUCLEOTIDE: 
                case CONTINUOUS: {
                    break;
                }
                case DNA: 
                case RNA: 
                case AMINO_ACID: {
                    this.getXMLWriter().writeStartElement(TAG_STATES.getLocalPart());
                    ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes(new TokenSetDefinitionEvent(neXMLWriterAlignmentInformation.getAlignmentType(), neXMLWriterAlignmentInformation.getDefaultTokenSetID(), null));
                    new NeXMLMolecularDataTokenDefinitionReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), neXMLWriterAlignmentInformation.getDefaultTokenSetID()).addRemainingEvents(neXMLWriterAlignmentInformation.getAlignmentType());
                    this.getXMLWriter().writeEndElement();
                    break;
                }
                default: {
                    this.getXMLWriter().writeStartElement(TAG_STATES.getLocalPart());
                    ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes(new TokenSetDefinitionEvent(neXMLWriterAlignmentInformation.getAlignmentType(), neXMLWriterAlignmentInformation.getDefaultTokenSetID(), null));
                    if (!neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().get(neXMLWriterAlignmentInformation.getDefaultTokenSetID()).getOccuringTokens().isEmpty()) {
                        new NeXMLTokenSetEventReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), neXMLWriterAlignmentInformation.getDefaultTokenSetID()).writeRemainingStandardTokenDefinitions();
                    }
                    this.getXMLWriter().writeEndElement();
                }
            }
        }
    }

    private void writeCharacterDefinitionTags(MatrixDataAdapter matrixDataAdapter) throws XMLStreamException, IOException {
        Object object;
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getAlignmentInfoByIDMap().get(((LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(this.getParameters())).getID());
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setIDIndex(0);
        if (matrixDataAdapter.getCharacterDefinitions(this.getParameters()).getCount(this.getParameters()) > 0L) {
            Iterator<String> iterator = matrixDataAdapter.getCharacterDefinitions(this.getParameters()).getIDIterator(this.getParameters());
            while (iterator.hasNext()) {
                String string = iterator.next();
                object = matrixDataAdapter.getCharacterDefinitions(this.getParameters()).getObjectStartEvent(this.getParameters(), string);
                neXMLWriterAlignmentInformation.getColumnIndexToIDMap().put(((CharacterDefinitionEvent)object).getIndex(), string);
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(string);
                this.getXMLWriter().writeStartElement(TAG_CHAR.getLocalPart());
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes((LabeledIDEvent)object);
                if (!neXMLWriterAlignmentInformation.getAlignmentType().equals((Object)CharacterStateSetType.CONTINUOUS)) {
                    this.getXMLWriter().writeAttribute(ATTR_STATES.getLocalPart(), neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().get(((CharacterDefinitionEvent)object).getIndex()));
                }
                NeXMLAttributeMetadataReceiver neXMLAttributeMetadataReceiver = new NeXMLAttributeMetadataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PREDICATE_CHAR_ATTR_TOKENS, PREDICATE_CHAR_ATTR_CODON_POSITION);
                matrixDataAdapter.getCharacterDefinitions(this.getParameters()).writeContentData(this.getParameters(), neXMLAttributeMetadataReceiver, string);
                if (!neXMLAttributeMetadataReceiver.getAttributeToValueMap().isEmpty()) {
                    for (QName qName : neXMLAttributeMetadataReceiver.getAttributeToValueMap().keySet()) {
                        if (qName.equals(PREDICATE_CHAR_ATTR_CODON_POSITION)) {
                            this.getXMLWriter().writeAttribute(ATTR_CODON_POSITION.getLocalPart(), neXMLAttributeMetadataReceiver.getAttributeToValueMap().get(qName));
                            continue;
                        }
                        if (!qName.equals(PREDICATE_CHAR_ATTR_TOKENS)) continue;
                        this.getXMLWriter().writeAttribute(ATTR_TOKENS.getLocalPart(), neXMLAttributeMetadataReceiver.getAttributeToValueMap().get(qName));
                    }
                }
                NeXMLIgnoreCertainMetadataReceiver neXMLIgnoreCertainMetadataReceiver = new NeXMLIgnoreCertainMetadataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), false, PREDICATE_CHAR_ATTR_TOKENS, PREDICATE_CHAR_ATTR_CODON_POSITION);
                matrixDataAdapter.getCharacterDefinitions(this.getParameters()).writeContentData(this.getParameters(), neXMLIgnoreCertainMetadataReceiver, string);
                this.getXMLWriter().writeEndElement();
            }
        }
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setIDIndex(0);
        for (long i = 0L; i < neXMLWriterAlignmentInformation.getAlignmentLength(); ++i) {
            if (neXMLWriterAlignmentInformation.getColumnIndexToIDMap().containsKey(i)) continue;
            object = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("char");
            neXMLWriterAlignmentInformation.getColumnIndexToIDMap().put(i, (String)object);
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs((String)object);
            this.getXMLWriter().writeEmptyElement(TAG_CHAR.getLocalPart());
            this.getXMLWriter().writeAttribute(ATTR_ID.getLocalPart(), (String)object);
            this.getXMLWriter().writeAttribute(ATTR_ABOUT.getLocalPart(), "#" + (String)object);
            if (neXMLWriterAlignmentInformation.getAlignmentType().equals((Object)CharacterStateSetType.CONTINUOUS)) continue;
            this.getXMLWriter().writeAttribute(ATTR_STATES.getLocalPart(), neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().get(i));
        }
    }

    private void writeCharacterSets(MatrixDataAdapter matrixDataAdapter) throws IllegalArgumentException, XMLStreamException, IOException {
        Iterator<String> iterator = matrixDataAdapter.getCharacterSets(this.getParameters()).getIDIterator(this.getParameters());
        NeXMLCharacterSetEventReceiver neXMLCharacterSetEventReceiver = new NeXMLCharacterSetEventReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters());
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getAlignmentInfoByIDMap().get(((LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(this.getParameters())).getID());
        while (iterator.hasNext()) {
            String string = iterator.next();
            String string2 = matrixDataAdapter.getCharacterSets(this.getParameters()).getObjectStartEvent(this.getParameters(), string).getLinkedID();
            if (string2 != null && !((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getDocumentIDs().contains(string2)) {
                throw new InconsistentAdapterDataException("The character set with the ID \"" + string + "\" linked to the matrix ID \"" + string2 + "\" which does not exist in the adapter data.");
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator2 = neXMLWriterAlignmentInformation.getCharSets().get(string).iterator();
            while (iterator2.hasNext()) {
                long l = (Long)iterator2.next();
                stringBuffer.append(neXMLWriterAlignmentInformation.getColumnIndexToIDMap().get(l));
                stringBuffer.append(" ");
            }
            this.getXMLWriter().writeStartElement(TAG_SET.getLocalPart());
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes(matrixDataAdapter.getCharacterSets(this.getParameters()).getObjectStartEvent(this.getParameters(), string));
            this.getXMLWriter().writeAttribute(ATTR_SINGLE_CHAR_LINK.getLocalPart(), stringBuffer.toString());
            matrixDataAdapter.getCharacterSets(this.getParameters()).writeContentData(this.getParameters(), neXMLCharacterSetEventReceiver, string);
            this.getXMLWriter().writeEndElement();
        }
    }

    private void writeRowTag(LinkedLabeledIDEvent linkedLabeledIDEvent, MatrixDataAdapter matrixDataAdapter) throws IOException, XMLStreamException {
        boolean bl = matrixDataAdapter.containsLongTokens(this.getParameters());
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getAlignmentInfoByIDMap().get(((LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(this.getParameters())).getID());
        if (neXMLWriterAlignmentInformation.getAlignmentType().equals((Object)CharacterStateSetType.DISCRETE) || neXMLWriterAlignmentInformation.getAlignmentType().equals((Object)CharacterStateSetType.CONTINUOUS)) {
            bl = true;
        }
        NeXMLSequenceTokensReceiver neXMLSequenceTokensReceiver = new NeXMLSequenceTokensReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), bl);
        NeXMLOnlyWriteMetaDataReceiver neXMLOnlyWriteMetaDataReceiver = new NeXMLOnlyWriteMetaDataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters());
        this.getXMLWriter().writeStartElement(TAG_ROW.getLocalPart());
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLinkedLabeledIDAttributes(linkedLabeledIDEvent, TAG_OTU, true);
        matrixDataAdapter.writeSequencePartContentData(this.getParameters(), neXMLOnlyWriteMetaDataReceiver, linkedLabeledIDEvent.getID(), 0L, matrixDataAdapter.getSequenceLength(this.getParameters(), linkedLabeledIDEvent.getID()));
        if (neXMLWriterAlignmentInformation.isWriteCellsTags()) {
            matrixDataAdapter.writeSequencePartContentData(this.getParameters(), neXMLSequenceTokensReceiver, linkedLabeledIDEvent.getID(), 0L, matrixDataAdapter.getSequenceLength(this.getParameters(), linkedLabeledIDEvent.getID()));
        } else {
            this.getXMLWriter().writeStartElement(TAG_SEQ.getLocalPart());
            matrixDataAdapter.writeSequencePartContentData(this.getParameters(), neXMLSequenceTokensReceiver, linkedLabeledIDEvent.getID(), 0L, matrixDataAdapter.getSequenceLength(this.getParameters(), linkedLabeledIDEvent.getID()));
            this.getXMLWriter().writeEndElement();
        }
        this.getXMLWriter().writeEndElement();
    }

    private void checkCharactersTags(DocumentDataAdapter documentDataAdapter) throws IllegalArgumentException, IOException {
        Iterator<MatrixDataAdapter> iterator = documentDataAdapter.getMatrixIterator(this.getParameters());
        while (iterator.hasNext()) {
            this.checkMatrix(iterator.next());
        }
    }

    private void checkMatrix(MatrixDataAdapter matrixDataAdapter) throws IllegalArgumentException, IOException {
        NeXMLCollectSequenceDataReceiver neXMLCollectSequenceDataReceiver = new NeXMLCollectSequenceDataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), false);
        String string = ((LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(this.getParameters())).getID();
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setCurrentAlignmentInfo(new NeXMLWriterAlignmentInformation());
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo();
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(string);
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getAlignmentInfoByIDMap().put(string, neXMLWriterAlignmentInformation);
        if (((LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(this.getParameters())).getLinkedID() == null) {
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setWriteUndefinedOtuList(true);
        }
        this.writeOrCheckMetaData(matrixDataAdapter, true);
        this.checkCharacterDefinitions(matrixDataAdapter.getCharacterDefinitions(this.getParameters()));
        this.checkTokenSets(matrixDataAdapter);
        long l = NeXMLEventWriter.determineMaxSequenceLength(matrixDataAdapter, this.getParameters());
        neXMLWriterAlignmentInformation.setAlignmentLength(l);
        if (Long.compare(matrixDataAdapter.getColumnCount(this.getParameters()), -1L) != 0 && Long.compare(matrixDataAdapter.getColumnCount(this.getParameters()), l) != 0) {
            throw new InconsistentAdapterDataException("The number of columns given in the matrix data adapter is not correct.");
        }
        String string2 = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("tokenSetDEFAULT");
        neXMLWriterAlignmentInformation.setDefaultTokenSetID(string2);
        for (long i = 0L; i < l; ++i) {
            if (neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().get(i) != null) continue;
            neXMLWriterAlignmentInformation.getColumnIndexToStatesMap().put(i, string2);
            neXMLWriterAlignmentInformation.setWriteDefaultTokenSet(true);
        }
        if (neXMLWriterAlignmentInformation.isWriteDefaultTokenSet()) {
            NeXMLWriterTokenSetInformation neXMLWriterTokenSetInformation = new NeXMLWriterTokenSetInformation();
            neXMLWriterTokenSetInformation.setNucleotideType(false);
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(string2);
            neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().put(string2, neXMLWriterTokenSetInformation);
        }
        this.checkCharacterSets(matrixDataAdapter);
        EnumMap<EventContentType, String> enumMap = new EnumMap<EventContentType, String>(EventContentType.class);
        enumMap.put(EventContentType.SEQUENCE, ATTR_SEQUENCE_SET_LINKED_IDS.getLocalPart());
        this.checkSets(enumMap, EventContentType.SEQUENCE_SET, matrixDataAdapter.getSequenceSets(this.getParameters()));
        this.setTokenList(neXMLWriterAlignmentInformation);
        Iterator<String> iterator = matrixDataAdapter.getSequenceIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(string3);
            LinkedLabeledIDEvent linkedLabeledIDEvent = matrixDataAdapter.getSequenceStartEvent(this.getParameters(), string3);
            String string4 = linkedLabeledIDEvent.getLinkedID();
            if (string4 == null || string4.isEmpty()) {
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setWriteUndefinedOTU(true);
            }
            matrixDataAdapter.writeSequencePartContentData(this.getParameters(), neXMLCollectSequenceDataReceiver, string3, 0L, matrixDataAdapter.getSequenceLength(this.getParameters(), linkedLabeledIDEvent.getID()));
            neXMLCollectSequenceDataReceiver.setTokenIndex(0L);
        }
        if (neXMLWriterAlignmentInformation.getTokenSetType().equals((Object)neXMLWriterAlignmentInformation.getTokenType())) {
            neXMLWriterAlignmentInformation.setAlignmentType(neXMLWriterAlignmentInformation.getTokenSetType());
        } else {
            neXMLWriterAlignmentInformation.setAlignmentType(CharacterStateSetType.DISCRETE);
        }
        neXMLWriterAlignmentInformation.setWriteAlignment(matrixDataAdapter.getSequenceCount(this.getParameters()) > 0L && l > 0L);
    }

    private void setTokenList(NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation) {
        switch (neXMLWriterAlignmentInformation.getTokenSetType()) {
            case AMINO_ACID: {
                for (Character c : SequenceUtils.getAminoAcidOneLetterCodes((boolean)true)) {
                    neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString(c.charValue()));
                }
                neXMLWriterAlignmentInformation.getDefinedTokens().remove("J");
                neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString('-'));
                neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString('?'));
                neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString('*'));
                break;
            }
            case DNA: {
                for (Character c : SequenceUtils.getNucleotideCharacters()) {
                    neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString(c.charValue()));
                }
                neXMLWriterAlignmentInformation.getDefinedTokens().remove("U");
                neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString('-'));
                neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString('?'));
                break;
            }
            case RNA: {
                for (Character c : SequenceUtils.getNucleotideCharacters()) {
                    neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString(c.charValue()));
                }
                neXMLWriterAlignmentInformation.getDefinedTokens().remove("T");
                neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString('-'));
                neXMLWriterAlignmentInformation.getDefinedTokens().add(Character.toString('?'));
                break;
            }
        }
    }

    private void checkCharacterDefinitions(ObjectListDataAdapter<CharacterDefinitionEvent> objectListDataAdapter) throws IOException {
        Iterator<String> iterator = objectListDataAdapter.getIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            this.writeOrCheckObjectMetaData(objectListDataAdapter, iterator.next(), true);
        }
    }

    private void checkTokenSets(MatrixDataAdapter matrixDataAdapter) throws IllegalArgumentException, IOException {
        ObjectListDataAdapter<TokenSetDefinitionEvent> objectListDataAdapter = matrixDataAdapter.getTokenSets(this.getParameters());
        Iterator<String> iterator = objectListDataAdapter.getIDIterator(this.getParameters());
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo();
        if (objectListDataAdapter.getCount(this.getParameters()) > 0L) {
            while (iterator.hasNext()) {
                String string = iterator.next();
                NeXMLCollectTokenSetDefinitionDataReceiver neXMLCollectTokenSetDefinitionDataReceiver = new NeXMLCollectTokenSetDefinitionDataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), string);
                CharacterStateSetType characterStateSetType = objectListDataAdapter.getObjectStartEvent(this.getParameters(), string).getSetType();
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(string);
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setCurrentTokenSetInfo(new NeXMLWriterTokenSetInformation());
                ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentTokenSetInfo().setNucleotideType(characterStateSetType.equals((Object)CharacterStateSetType.NUCLEOTIDE));
                CharacterStateSetType characterStateSetType2 = neXMLWriterAlignmentInformation.getTokenSetType();
                if (characterStateSetType2 == null || characterStateSetType2.equals((Object)CharacterStateSetType.UNKNOWN)) {
                    neXMLWriterAlignmentInformation.setTokenSetType(characterStateSetType);
                } else if (!characterStateSetType2.equals((Object)characterStateSetType)) {
                    throw new JPhyloIOWriterException("Different data types were encountered but only character data of one type (e.g DNA or amino acid) can be written to a single NeXML characters tag.");
                }
                neXMLWriterAlignmentInformation.getIDToTokenSetInfoMap().put(string, ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentTokenSetInfo());
                objectListDataAdapter.writeContentData(this.getParameters(), neXMLCollectTokenSetDefinitionDataReceiver, string);
            }
        }
        if (neXMLWriterAlignmentInformation.getTokenSetType() == null || neXMLWriterAlignmentInformation.getTokenSetType().equals((Object)CharacterStateSetType.UNKNOWN)) {
            neXMLWriterAlignmentInformation.setTokenSetType(CharacterStateSetType.CONTINUOUS);
        }
        neXMLWriterAlignmentInformation.setTokenType(neXMLWriterAlignmentInformation.getTokenSetType());
    }

    private void checkCharacterSets(MatrixDataAdapter matrixDataAdapter) throws IllegalArgumentException, IOException {
        ObjectListDataAdapter<LinkedLabeledIDEvent> objectListDataAdapter = matrixDataAdapter.getCharacterSets(this.getParameters());
        Iterator<String> iterator = objectListDataAdapter.getIDIterator(this.getParameters());
        NeXMLWriterAlignmentInformation neXMLWriterAlignmentInformation = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo();
        while (iterator.hasNext()) {
            String string = iterator.next();
            NeXMLCollectCharSetDataReceiver neXMLCollectCharSetDataReceiver = new NeXMLCollectCharSetDataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), string);
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(string);
            neXMLWriterAlignmentInformation.getCharSets().put(string, new TreeSet());
            objectListDataAdapter.writeContentData(this.getParameters(), neXMLCollectCharSetDataReceiver, string);
        }
    }

    private void writeTreesTags(DocumentDataAdapter documentDataAdapter) throws XMLStreamException, IOException {
        Iterator<TreeNetworkGroupDataAdapter> iterator = documentDataAdapter.getTreeNetworkGroupIterator(this.getParameters());
        while (iterator.hasNext()) {
            this.writeTreesTag(iterator.next());
        }
    }

    private void writeTreesTag(TreeNetworkGroupDataAdapter treeNetworkGroupDataAdapter) throws XMLStreamException, IOException {
        this.getXMLWriter().writeStartElement(TAG_TREES.getLocalPart());
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLinkedLabeledIDAttributes((LinkedLabeledIDEvent)treeNetworkGroupDataAdapter.getStartEvent(this.getParameters()), TAG_OTUS, true);
        this.writeOrCheckMetaData(treeNetworkGroupDataAdapter, false);
        Iterator<TreeNetworkDataAdapter> iterator = treeNetworkGroupDataAdapter.getTreeNetworkIterator(this.getParameters());
        while (iterator.hasNext()) {
            this.writeTreeOrNetworkTag(iterator.next());
        }
        EnumMap<EventContentType, String> enumMap = new EnumMap<EventContentType, String>(EventContentType.class);
        enumMap.put(EventContentType.TREE, ATTR_TREE_SET_LINKED_TREE_IDS.getLocalPart());
        enumMap.put(EventContentType.NETWORK, ATTR_TREE_SET_LINKED_NETWORK_IDS.getLocalPart());
        this.writeSetTags(enumMap, treeNetworkGroupDataAdapter.getTreeSets(this.getParameters()));
        this.getXMLWriter().writeEndElement();
    }

    private void writeTreeOrNetworkTag(TreeNetworkDataAdapter treeNetworkDataAdapter) throws XMLStreamException, IOException {
        EnumMap<EventContentType, String> enumMap;
        Object object;
        NeXMLMetaDataReceiver neXMLMetaDataReceiver = new NeXMLMetaDataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNeXMLPrefix(this.getXMLWriter()));
        stringBuffer.append(":");
        if (treeNetworkDataAdapter.isTree(this.getParameters())) {
            this.getXMLWriter().writeStartElement(TAG_TREE.getLocalPart());
            stringBuffer.append("FloatTree");
        } else {
            this.getXMLWriter().writeStartElement(TAG_NETWORK.getLocalPart());
            stringBuffer.append("FloatNetwork");
        }
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes((LabeledIDEvent)treeNetworkDataAdapter.getStartEvent(this.getParameters()));
        this.getXMLWriter().writeAttribute(XMLReadWriteUtils.getXSIPrefix(this.getXMLWriter()), ATTR_XSI_TYPE.getNamespaceURI(), ATTR_XSI_TYPE.getLocalPart(), stringBuffer.toString());
        this.writeOrCheckMetaData(treeNetworkDataAdapter, false);
        Iterator<String> iterator = treeNetworkDataAdapter.getNodes(this.getParameters()).getIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            object = iterator.next();
            enumMap = treeNetworkDataAdapter.getNodes(this.getParameters()).getObjectStartEvent(this.getParameters(), (String)object);
            this.getXMLWriter().writeStartElement(TAG_NODE.getLocalPart());
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLinkedLabeledIDAttributes((LinkedLabeledIDEvent)((Object)enumMap), TAG_OTU, false);
            if (((NodeEvent)((Object)enumMap)).isRootNode()) {
                this.getXMLWriter().writeAttribute(ATTR_ROOT.getLocalPart(), Boolean.toString(((NodeEvent)((Object)enumMap)).isRootNode()));
            }
            treeNetworkDataAdapter.getNodes(this.getParameters()).writeContentData(this.getParameters(), neXMLMetaDataReceiver, (String)object);
            this.getXMLWriter().writeEndElement();
        }
        object = treeNetworkDataAdapter.getEdges(this.getParameters()).getIDIterator(this.getParameters());
        while (object.hasNext()) {
            enumMap = (String)object.next();
            this.writeEdgeOrRootedgeTag(treeNetworkDataAdapter, treeNetworkDataAdapter.getEdges(this.getParameters()).getObjectStartEvent(this.getParameters(), (String)((Object)enumMap)));
        }
        enumMap = new EnumMap<EventContentType, String>(EventContentType.class);
        enumMap.put(EventContentType.NODE, ATTR_NODE_EDGE_SET_LINKED_NODE_IDS.getLocalPart());
        enumMap.put(EventContentType.EDGE, ATTR_NODE_EDGE_SET_LINKED_EDGE_IDS.getLocalPart());
        enumMap.put(EventContentType.ROOT_EDGE, ATTR_NODE_EDGE_SET_LINKED_ROOTEDGE_IDS.getLocalPart());
        this.writeSetTags(enumMap, treeNetworkDataAdapter.getNodeEdgeSets(this.getParameters()));
        this.getXMLWriter().writeEndElement();
    }

    private void writeEdgeOrRootedgeTag(TreeNetworkDataAdapter treeNetworkDataAdapter, EdgeEvent edgeEvent) throws XMLStreamException, IllegalArgumentException, IOException {
        NeXMLMetaDataReceiver neXMLMetaDataReceiver = new NeXMLMetaDataReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters());
        if (edgeEvent.hasSource()) {
            this.getXMLWriter().writeStartElement(TAG_ROOTEDGE.getLocalPart());
        } else {
            this.getXMLWriter().writeStartElement(TAG_EDGE.getLocalPart());
            this.getXMLWriter().writeAttribute(ATTR_SOURCE.getLocalPart(), edgeEvent.getSourceID());
        }
        this.getXMLWriter().writeAttribute(ATTR_TARGET.getLocalPart(), edgeEvent.getTargetID());
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).writeLabeledIDAttributes(edgeEvent);
        if (!Double.isNaN(edgeEvent.getLength())) {
            this.getXMLWriter().writeAttribute(ATTR_LENGTH.getLocalPart(), Double.toString(edgeEvent.getLength()));
        }
        treeNetworkDataAdapter.getEdges(this.getParameters()).writeContentData(this.getParameters(), neXMLMetaDataReceiver, edgeEvent.getID());
        this.getXMLWriter().writeEndElement();
    }

    private void checkTreeAndNetworkGroups(DocumentDataAdapter documentDataAdapter) throws IOException {
        Iterator<TreeNetworkGroupDataAdapter> iterator = documentDataAdapter.getTreeNetworkGroupIterator(this.getParameters());
        while (iterator.hasNext()) {
            this.checkTreesAndNetworkGroup(iterator.next());
        }
    }

    private void checkTreesAndNetworkGroup(TreeNetworkGroupDataAdapter treeNetworkGroupDataAdapter) throws IOException {
        String string = ((LinkedLabeledIDEvent)treeNetworkGroupDataAdapter.getStartEvent(this.getParameters())).getLinkedID();
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(((LinkedLabeledIDEvent)treeNetworkGroupDataAdapter.getStartEvent(this.getParameters())).getID());
        this.writeOrCheckMetaData(treeNetworkGroupDataAdapter, true);
        if (string == null) {
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).setWriteUndefinedOtuList(true);
        }
        Iterator<TreeNetworkDataAdapter> iterator = treeNetworkGroupDataAdapter.getTreeNetworkIterator(this.getParameters());
        while (iterator.hasNext()) {
            this.checkTreeOrNetwork(iterator.next());
        }
        EnumMap<EventContentType, String> enumMap = new EnumMap<EventContentType, String>(EventContentType.class);
        enumMap.put(EventContentType.TREE, ATTR_TREE_SET_LINKED_TREE_IDS.getLocalPart());
        enumMap.put(EventContentType.NETWORK, ATTR_TREE_SET_LINKED_NETWORK_IDS.getLocalPart());
        this.checkSets(enumMap, EventContentType.TREE_NETWORK_SET, treeNetworkGroupDataAdapter.getTreeSets(this.getParameters()));
    }

    private void checkTreeOrNetwork(TreeNetworkDataAdapter treeNetworkDataAdapter) throws IOException {
        CharSequence charSequence;
        Object object;
        Object object2;
        NeXMLCollectNamespaceReceiver neXMLCollectNamespaceReceiver = new NeXMLCollectNamespaceReceiver((NeXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters());
        HashSet<String> hashSet = new HashSet<String>();
        ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(((LabeledIDEvent)treeNetworkDataAdapter.getStartEvent(this.getParameters())).getID());
        this.writeOrCheckMetaData(treeNetworkDataAdapter, true);
        EnumMap<EventContentType, String> enumMap = new EnumMap<EventContentType, String>(EventContentType.class);
        enumMap.put(EventContentType.NODE, ATTR_NODE_EDGE_SET_LINKED_NODE_IDS.getLocalPart());
        enumMap.put(EventContentType.EDGE, ATTR_NODE_EDGE_SET_LINKED_EDGE_IDS.getLocalPart());
        enumMap.put(EventContentType.ROOT_EDGE, ATTR_NODE_EDGE_SET_LINKED_ROOTEDGE_IDS.getLocalPart());
        this.checkSets(enumMap, EventContentType.NODE_EDGE_SET, treeNetworkDataAdapter.getNodeEdgeSets(this.getParameters()));
        Iterator<String> iterator = treeNetworkDataAdapter.getEdges(this.getParameters()).getIDIterator(this.getParameters());
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = treeNetworkDataAdapter.getEdges(this.getParameters()).getObjectStartEvent(this.getParameters(), (String)object2);
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs((String)object2);
            treeNetworkDataAdapter.getEdges(this.getParameters()).writeContentData(this.getParameters(), neXMLCollectNamespaceReceiver, (String)object2);
            hashSet.add(((EdgeEvent)object).getSourceID());
            hashSet.add(((EdgeEvent)object).getTargetID());
        }
        hashSet.remove(null);
        object2 = new HashSet();
        object = treeNetworkDataAdapter.getNodes(this.getParameters()).getIDIterator(this.getParameters());
        while (object.hasNext()) {
            charSequence = (String)object.next();
            object2.add(charSequence);
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs((String)charSequence);
            treeNetworkDataAdapter.getNodes(this.getParameters()).writeContentData(this.getParameters(), neXMLCollectNamespaceReceiver, (String)charSequence);
        }
        if (hashSet.size() != object2.size()) {
            charSequence = new StringBuffer("The nodes ");
            for (String string : hashSet) {
                if (object2.contains(string)) continue;
                ((StringBuffer)charSequence).append(string);
                ((StringBuffer)charSequence).append(", ");
            }
            ((StringBuffer)charSequence).append("are referenced by edges but not defined in the document.");
            throw new JPhyloIOWriterException(((StringBuffer)charSequence).toString());
        }
    }
}

