/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.objecttranslation.InvalidObjectSourceDataException;
import java.math.BigDecimal;

public class NewickUtils
implements NewickConstants {
    public static Number parseNumericValue(String string) {
        string = string.trim();
        try {
            Double d = Double.parseDouble(string);
            if (d.isInfinite()) {
                return new BigDecimal(string);
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static int consumeElementSeparator(int n, int n2, String string) throws InvalidObjectSourceDataException {
        while (n < n2 && string.charAt(n) != ',') {
            if (!Character.isWhitespace(string.charAt(n))) {
                throw new InvalidObjectSourceDataException("Literal value starting with '" + string.charAt(n) + "' found although an element separator ('" + ',' + "') was expected.");
            }
            ++n;
        }
        return n + 1;
    }

    public static ReadElement readNextElement(String string, int n, int n2) throws InvalidObjectSourceDataException {
        int n3;
        for (n3 = n; n3 < n2 && Character.isWhitespace(string.charAt(n3)); ++n3) {
        }
        if (n3 < n2) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string.charAt(n3) == '\'' || string.charAt(n3) == '\"') {
                char c = string.charAt(n3);
                ++n3;
                while (n3 < n2 && string.charAt(n3) != c) {
                    stringBuilder.append(string.charAt(n3));
                    if (++n3 + 2 >= n2 || string.charAt(n3) != c || string.charAt(n3 + 1) != c) continue;
                    stringBuilder.append(c);
                    n3 += 2;
                }
                if (string.charAt(n3) == c) {
                    ++n3;
                }
                if (n3 <= n2) {
                    return new ReadElement(stringBuilder.toString(), null, NewickUtils.consumeElementSeparator(n3, n2, string));
                }
                throw new InvalidObjectSourceDataException("Unterminated string constant.");
            }
            while (n3 < n2 && string.charAt(n3) != ',') {
                stringBuilder.append(string.charAt(n3));
                ++n3;
            }
            String string2 = stringBuilder.toString();
            if (string2.length() > 0) {
                return new ReadElement(string2, NewickUtils.parseNumericValue(string2), NewickUtils.consumeElementSeparator(n3, n2, string));
            }
        }
        return null;
    }

    public static class ReadElement {
        private String text;
        private Number numericValue;
        private int endPos;

        public ReadElement(String string, Number number, int n) {
            this.text = string;
            this.numericValue = number;
            this.endPos = n;
        }

        public String getText() {
            return this.text;
        }

        public Number getNumericValue() {
            return this.numericValue;
        }

        public int getEndPos() {
            return this.endPos;
        }
    }
}

