/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.jphyloio.JPhyloIOEventReader;
import info.bioinfweb.jphyloio.JPhyloIOEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.factory.AbstractSingleReaderWriterFactory;
import info.bioinfweb.jphyloio.factory.SingleReaderWriterFactory;
import info.bioinfweb.jphyloio.formatinfo.DefaultFormatInfo;
import info.bioinfweb.jphyloio.formatinfo.JPhyloIOFormatInfo;
import info.bioinfweb.jphyloio.formatinfo.MetadataModeling;
import info.bioinfweb.jphyloio.formatinfo.MetadataTopologyType;
import info.bioinfweb.jphyloio.formats.JPhyloIOFormatIDs;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.newick.NewickEventReader;
import info.bioinfweb.jphyloio.formats.newick.NewickEventWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.TreeSet;

public class NewickFactory
extends AbstractSingleReaderWriterFactory
implements SingleReaderWriterFactory,
JPhyloIOFormatIDs,
NewickConstants {
    private static final int NUMBER_OF_EVENTS_TO_TEST = 5;

    @Override
    public boolean checkFormat(Reader reader, ReadWriteParameterMap readWriteParameterMap) {
        try {
            NewickEventReader newickEventReader = new NewickEventReader(reader, readWriteParameterMap);
            for (int i = 0; i < 5; ++i) {
                if (!newickEventReader.hasNextEvent()) {
                    return true;
                }
                newickEventReader.next();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public JPhyloIOEventReader getReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        return new NewickEventReader(inputStream, readWriteParameterMap);
    }

    @Override
    public JPhyloIOEventReader getReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        return new NewickEventReader(reader, readWriteParameterMap);
    }

    @Override
    public JPhyloIOEventWriter getWriter() {
        return new NewickEventWriter();
    }

    @Override
    public boolean hasReader() {
        return true;
    }

    @Override
    public boolean hasWriter() {
        return true;
    }

    @Override
    protected JPhyloIOFormatInfo createFormatInfo() {
        EnumSet<EventContentType[]> enumSet = EnumSet.of(EventContentType.DOCUMENT, new EventContentType[]{EventContentType.LITERAL_META, EventContentType.LITERAL_META_CONTENT, EventContentType.COMMENT, EventContentType.TREE_NETWORK_GROUP, EventContentType.TREE, EventContentType.NODE, EventContentType.EDGE, EventContentType.ROOT_EDGE});
        EnumMap<EventContentType, MetadataModeling> enumMap = new EnumMap<EventContentType, MetadataModeling>(EventContentType.class);
        enumMap.put(EventContentType.NODE, new MetadataModeling(MetadataTopologyType.LITERAL_ONLY, EnumSet.of(LiteralContentSequenceType.SIMPLE)));
        enumMap.put(EventContentType.ROOT_EDGE, new MetadataModeling(MetadataTopologyType.LITERAL_ONLY, EnumSet.of(LiteralContentSequenceType.SIMPLE)));
        enumMap.put(EventContentType.EDGE, new MetadataModeling(MetadataTopologyType.LITERAL_ONLY, EnumSet.of(LiteralContentSequenceType.SIMPLE)));
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("info.bioinfweb.jphyloio.writerInstance");
        treeSet.add("info.bioinfweb.jphyloio.logger");
        treeSet.add("info.bioinfweb.jphyloio.maximumNameLength");
        treeSet.add("info.bioinfweb.jphyloio.labelEditingReporter");
        treeSet.add("info.bioinfweb.jphyloio.objectTranslatorFactory");
        return new DefaultFormatInfo(this, "info.bioinfweb.jphyloio.newick", "Newick", enumSet, enumSet, enumMap, enumMap, Collections.emptySet(), treeSet, new ReadWriteParameterMap(), "Newick tree format", "nwk", "newick", "tre", "tree", "con");
    }
}

