/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.formats.newick.DefaultNewickReaderNodeLabelProcessor;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.newick.NewickStringReader;
import info.bioinfweb.jphyloio.formats.text.AbstractTextEventReader;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class NewickEventReader
extends AbstractTextEventReader<TextReaderStreamDataProvider<NewickEventReader>>
implements NewickConstants {
    private State state = State.START;
    private NewickStringReader newickStringReader;

    private void init() {
        this.newickStringReader = new NewickStringReader((TextReaderStreamDataProvider)this.getStreamDataProvider(), null, null, new DefaultNewickReaderNodeLabelProcessor(), ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getParameters().getBoolean("info.bioinfweb.jphyloio.expectENewick", false));
    }

    public NewickEventReader(BufferedReader bufferedReader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(bufferedReader, readWriteParameterMap, null);
        this.init();
    }

    public NewickEventReader(File file, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(file, readWriteParameterMap, null);
        this.init();
    }

    public NewickEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(inputStream, readWriteParameterMap, null);
        this.init();
    }

    public NewickEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(reader, readWriteParameterMap, null);
        this.init();
    }

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.newick";
    }

    @Override
    protected void readNextEvent() throws IOException {
        switch (this.state) {
            case START: {
                this.state = State.IN_DOCUMENT;
                this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.START));
                this.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.TREE_NETWORK_GROUP, "treesOrNetworks" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), null, null));
                break;
            }
            case IN_DOCUMENT: {
                if (this.newickStringReader.addNextEvents()) break;
                this.state = State.END;
                this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.TREE_NETWORK_GROUP, EventTopologyType.END));
                this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.END));
                break;
            }
            case END: {
                break;
            }
            default: {
                throw new InternalError("Unsupported state " + (Object)((Object)this.state) + ".");
            }
        }
    }

    private static enum State {
        START,
        IN_DOCUMENT,
        END;

    }
}

