/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.newick.NHXUtils;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import info.bioinfweb.jphyloio.objecttranslation.InvalidObjectSourceDataException;
import info.bioinfweb.jphyloio.objecttranslation.implementations.ListTranslator;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.namespace.QName;

public class HotCommentDataReader
implements NewickConstants,
ReadWriteConstants {
    private Value readTextElementData(String string) {
        char c = ' ';
        if (string.startsWith(Character.toString('\'')) && string.endsWith(Character.toString('\''))) {
            c = '\'';
        } else if (string.startsWith(Character.toString('\"')) && string.endsWith(Character.toString('\"'))) {
            c = '\"';
        }
        if (c != ' ') {
            return new Value(string.substring(1, string.length() - 1).replaceAll("\\" + c + "\\" + c, "" + c));
        }
        try {
            return new Value(string, new Double(string));
        }
        catch (NumberFormatException numberFormatException) {
            return new Value(string);
        }
    }

    private int findNameEnd(String string, int n, char c) {
        ++n;
        while (n < string.length()) {
            if (string.charAt(n) == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int findFieldEnd(String string, int n) {
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\"': 
                case '\'': {
                    n = this.findNameEnd(string, n, string.charAt(n));
                    if (n != -1) break;
                    return -1;
                }
                case '}': {
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    private int findAllocationEnd(String string, int n) {
        int n2;
        if (n >= string.length()) {
            return -1;
        }
        for (n2 = n; n2 < string.length(); ++n2) {
            switch (string.charAt(n2)) {
                case '{': {
                    n2 = this.findFieldEnd(string, n2);
                    break;
                }
                case '\"': 
                case '\'': {
                    n2 = this.findNameEnd(string, n2, string.charAt(n2));
                    break;
                }
                case ',': {
                    return n2;
                }
            }
            if (n2 != -1) continue;
            return -1;
        }
        return n2;
    }

    private void addLiteralMetaStart(String string, QName qName, URIOrStringIdentifier uRIOrStringIdentifier, TextReaderStreamDataProvider<?> textReaderStreamDataProvider, Collection<JPhyloIOEvent> collection) {
        collection.add(new LiteralMetadataEvent("meta" + textReaderStreamDataProvider.getIDManager().createNewID(), string, new URIOrStringIdentifier(string, qName), uRIOrStringIdentifier, LiteralContentSequenceType.SIMPLE));
    }

    private void addLiteralMetaContent(Value value, Collection<JPhyloIOEvent> collection) {
        collection.add(new LiteralMetadataContentEvent(value.objectValue, value.stringValue));
    }

    private void addLiteralMetaEnd(Collection<JPhyloIOEvent> collection) {
        collection.add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
    }

    private void processMetacomments(String string, TextReaderStreamDataProvider<?> textReaderStreamDataProvider, Collection<JPhyloIOEvent> collection) throws JPhyloIOReaderException {
        ListTranslator listTranslator = new ListTranslator();
        int n = 1;
        int n2 = this.findAllocationEnd(string, n);
        while (n2 != -1) {
            String string2 = string.substring(n, n2);
            int n3 = string2.indexOf(61);
            if (n3 >= 0) {
                Value value;
                String string3 = string2.substring(n3 + 1).trim();
                URIOrStringIdentifier uRIOrStringIdentifier = null;
                if (string3.startsWith("{") && string3.endsWith("}")) {
                    try {
                        value = new Value(string3, listTranslator.representationToJava(string3, textReaderStreamDataProvider));
                        uRIOrStringIdentifier = new URIOrStringIdentifier(null, DATA_TYPE_NEWICK_ARRAY);
                    }
                    catch (InvalidObjectSourceDataException invalidObjectSourceDataException) {
                        throw new JPhyloIOReaderException("The following excpetion occurred when trying to read a list from a Newick hot comment: " + invalidObjectSourceDataException.getMessage(), (StreamLocationProvider)textReaderStreamDataProvider.getDataReader(), (Throwable)invalidObjectSourceDataException);
                    }
                } else {
                    value = this.readTextElementData(string3);
                }
                this.addLiteralMetaStart(string2.substring(0, n3).trim(), PREDICATE_HAS_LITERAL_METADATA, uRIOrStringIdentifier, textReaderStreamDataProvider, collection);
                this.addLiteralMetaContent(value, collection);
                this.addLiteralMetaEnd(collection);
            }
            n = n2 + 1;
            n2 = this.findAllocationEnd(string, n);
        }
    }

    private void processNHX(String string, TextReaderStreamDataProvider<?> textReaderStreamDataProvider, Collection<JPhyloIOEvent> collection) {
        LinkedList<JPhyloIOEvent> linkedList = new LinkedList<JPhyloIOEvent>();
        String[] stringArray = string.substring("&&NHX:".length()).split(":");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n <= 0) {
                throw new IllegalArgumentException("\"" + stringArray[i] + "\" is not a legal NHX metadata definition.");
            }
            String string2 = stringArray[i].substring(0, n);
            this.addLiteralMetaStart("NHX:" + string2, NHXUtils.getInstance().predicateByKey(string2), null, textReaderStreamDataProvider, linkedList);
            this.addLiteralMetaContent(this.readTextElementData(stringArray[i].substring(n + 1, stringArray[i].length())), linkedList);
            this.addLiteralMetaEnd(linkedList);
        }
        collection.addAll(linkedList);
    }

    public void read(String string, TextReaderStreamDataProvider<?> textReaderStreamDataProvider, Collection<JPhyloIOEvent> collection, boolean bl) throws IllegalArgumentException, JPhyloIOReaderException {
        if (string.startsWith("&&NHX:")) {
            this.processNHX(string, textReaderStreamDataProvider, collection);
        } else if (string.startsWith("&")) {
            this.processMetacomments(string, textReaderStreamDataProvider, collection);
        }
    }

    private static class Value {
        public String stringValue;
        public Object objectValue;

        public Value(String string, Object object) {
            this.stringValue = string;
            this.objectValue = object;
        }

        public Value(String string) {
            this(string, string);
        }
    }
}

