/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.fasta;

import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.JPhyloIOEventReceiver;
import info.bioinfweb.jphyloio.dataadapters.MatrixDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.implementations.receivers.BasicEventReceiver;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SequenceTokensEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.formats.fasta.FASTAConstants;
import info.bioinfweb.jphyloio.formats.fasta.FASTAEventWriter;
import info.bioinfweb.jphyloio.formats.text.TextWriterStreamDataProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;

class FASTASequenceEventReceiver
extends BasicEventReceiver<TextWriterStreamDataProvider<FASTAEventWriter>>
implements JPhyloIOEventReceiver,
FASTAConstants {
    private int charsPerLineWritten = 0;
    private MatrixDataAdapter matrixDataAdapter;
    private long lineLength;
    private boolean allowCommentsBeforeTokens = false;
    private boolean continuedCommentExpected = false;

    public FASTASequenceEventReceiver(TextWriterStreamDataProvider<FASTAEventWriter> textWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, MatrixDataAdapter matrixDataAdapter, long l) {
        super(textWriterStreamDataProvider, readWriteParameterMap);
        this.matrixDataAdapter = matrixDataAdapter;
        this.lineLength = l;
    }

    public int getCharsPerLineWritten() {
        return this.charsPerLineWritten;
    }

    public boolean isAllowCommentsBeforeTokens() {
        return this.allowCommentsBeforeTokens;
    }

    public void setAllowCommentsBeforeTokens(boolean bl) {
        this.allowCommentsBeforeTokens = bl;
    }

    protected void writeNewLine(Writer writer) throws IOException {
        AbstractEventWriter.writeLineBreak(writer, this.getParameterMap());
        this.charsPerLineWritten = 0;
    }

    private void writeToken(String string) throws IOException {
        if (this.matrixDataAdapter.containsLongTokens(this.getParameterMap())) {
            string = string + " ";
        } else if (string.length() > 1) {
            throw new IllegalArgumentException("The specified string representation of one or more of token(s) is longer than one character, although this reader is set to not allow longer tokens.");
        }
        if ((long)(this.charsPerLineWritten + string.length()) > this.lineLength) {
            this.writeNewLine(((TextWriterStreamDataProvider)this.getStreamDataProvider()).getWriter());
        }
        ((TextWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().write(string);
        this.charsPerLineWritten += string.length();
    }

    private void writeTokens(Collection<String> collection) throws IOException {
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.writeToken(iterator.next());
        }
    }

    private void writeComment(CommentEvent commentEvent) throws IOException {
        if (!this.continuedCommentExpected) {
            ((TextWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().write(59);
        }
        ((TextWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().write(commentEvent.getContent());
        this.continuedCommentExpected = commentEvent.isContinuedInNextEvent();
        if (!this.continuedCommentExpected) {
            this.writeNewLine(((TextWriterStreamDataProvider)this.getStreamDataProvider()).getWriter());
        }
    }

    @Override
    protected void handleComment(CommentEvent commentEvent) throws IOException, XMLStreamException {
        if (this.isAllowCommentsBeforeTokens()) {
            this.writeComment(commentEvent.asCommentEvent());
        } else {
            this.addIgnoredComments(1L);
        }
    }

    @Override
    public boolean doAdd(JPhyloIOEvent jPhyloIOEvent) throws IllegalArgumentException, IOException {
        if (this.continuedCommentExpected && !EventContentType.COMMENT.equals((Object)jPhyloIOEvent.getType().getContentType())) {
            throw new IllegalArgumentException("The previous event was a comment event indicating that it would be continued in this event, but this event was of type " + jPhyloIOEvent.getType());
        }
        boolean bl = false;
        switch (jPhyloIOEvent.getType().getContentType()) {
            case SEQUENCE_TOKENS: {
                SequenceTokensEvent sequenceTokensEvent = jPhyloIOEvent.asSequenceTokensEvent();
                if (sequenceTokensEvent.getTokens().isEmpty()) break;
                this.writeTokens(jPhyloIOEvent.asSequenceTokensEvent().getTokens());
                bl = true;
                break;
            }
            case SINGLE_SEQUENCE_TOKEN: {
                if (!jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) break;
                this.writeToken(jPhyloIOEvent.asSingleSequenceTokenEvent().getToken());
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Events of the type " + (Object)((Object)jPhyloIOEvent.getType().getContentType()) + " are not allowed in a sequence content subsequence.");
            }
        }
        if (bl) {
            this.setAllowCommentsBeforeTokens(false);
        }
        return true;
    }
}

