/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.fasta;

import info.bioinfweb.jphyloio.AbstractSingleMatrixEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.DocumentDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.MatrixDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.OTUListDataAdapter;
import info.bioinfweb.jphyloio.formats.fasta.FASTAConstants;
import info.bioinfweb.jphyloio.formats.fasta.FASTASequenceEventReceiver;
import info.bioinfweb.jphyloio.formats.text.TextWriterStreamDataProvider;
import java.io.IOException;
import java.util.Iterator;

public class FASTAEventWriter
extends AbstractSingleMatrixEventWriter<TextWriterStreamDataProvider<FASTAEventWriter>>
implements FASTAConstants {
    public FASTAEventWriter() {
        super("FASTA");
    }

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.fasta";
    }

    @Override
    protected TextWriterStreamDataProvider<FASTAEventWriter> createStreamDataProvider() {
        return new TextWriterStreamDataProvider<FASTAEventWriter>(this);
    }

    @Override
    protected String maskReservedLabelCharacters(String string) {
        return string;
    }

    private void writeSequenceName(String string, FASTASequenceEventReceiver fASTASequenceEventReceiver, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        if (fASTASequenceEventReceiver.getCharsPerLineWritten() > 0) {
            fASTASequenceEventReceiver.writeNewLine(((TextWriterStreamDataProvider)this.getStreamDataProvider()).getWriter());
        }
        ((TextWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().write(62);
        ((TextWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().write(string);
        FASTAEventWriter.writeLineBreak(((TextWriterStreamDataProvider)this.getStreamDataProvider()).getWriter(), readWriteParameterMap);
    }

    @Override
    protected void writeSingleMatrix(DocumentDataAdapter documentDataAdapter, MatrixDataAdapter matrixDataAdapter, Iterator<String> iterator, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        Object object;
        FASTASequenceEventReceiver fASTASequenceEventReceiver = new FASTASequenceEventReceiver((TextWriterStreamDataProvider)this.getStreamDataProvider(), readWriteParameterMap, matrixDataAdapter, readWriteParameterMap.getLong("info.bioinfweb.jphyloio.lineLength", 80L));
        String string = readWriteParameterMap.getString("info.bioinfweb.jphyloio.sequenceExtensionToken");
        long l = FASTAEventWriter.determineMaxSequenceLength(matrixDataAdapter, readWriteParameterMap);
        OTUListDataAdapter oTUListDataAdapter = FASTAEventWriter.getReferencedOTUList(documentDataAdapter, matrixDataAdapter, readWriteParameterMap);
        while (iterator.hasNext()) {
            object = iterator.next();
            this.writeSequenceName(this.editSequenceOrNodeLabel(matrixDataAdapter.getSequenceStartEvent(readWriteParameterMap, (String)object), readWriteParameterMap, oTUListDataAdapter), fASTASequenceEventReceiver, readWriteParameterMap);
            fASTASequenceEventReceiver.setAllowCommentsBeforeTokens(true);
            matrixDataAdapter.writeSequencePartContentData(readWriteParameterMap, fASTASequenceEventReceiver, (String)object, 0L, matrixDataAdapter.getSequenceLength(readWriteParameterMap, (String)object));
            this.extendSequence(matrixDataAdapter, readWriteParameterMap, (String)object, l, string, fASTASequenceEventReceiver);
        }
        object = readWriteParameterMap.getLogger();
        if (fASTASequenceEventReceiver.didIgnoreComments()) {
            object.addWarning(fASTASequenceEventReceiver.getIgnoredComments() + " comment events inside the matrix could not be written, because FASTA supports only comments at the beginning of sequences.");
        }
        if (fASTASequenceEventReceiver.didIgnoreMetadata()) {
            object.addWarning(fASTASequenceEventReceiver.getIgnoredMetadata() + " metadata events inside the matrix could not be written, because FASTA does not support metadata.");
        }
    }
}

