/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.events;

import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;

public class EdgeEvent
extends LabeledIDEvent {
    private String sourceID;
    private String targetID;
    private double length;

    public EdgeEvent(String string, String string2, String string3, String string4, double d) {
        super(string3 == null ? EventContentType.ROOT_EDGE : EventContentType.EDGE, string, string2);
        this.checkID(string4, "target ID");
        if (string3 != null) {
            this.checkID(string3, "source ID");
        }
        this.sourceID = string3;
        this.targetID = string4;
        this.length = d;
    }

    public EdgeEvent(String string, String string2, String string3, double d) {
        super(EventContentType.ROOT_EDGE, string, string2);
        this.checkID(string3, "target ID");
        this.targetID = string3;
        this.length = d;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public boolean hasSource() {
        return this.getSourceID() == null;
    }

    public String getTargetID() {
        return this.targetID;
    }

    public double getLength() {
        return this.length;
    }

    public boolean hasLength() {
        return !Double.isNaN(this.getLength());
    }

    public String toString() {
        return this.getType() + " (" + this.getSourceID() + " -> " + this.getTargetID() + "):" + this.getLength();
    }
}

