/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.dataadapters.implementations.receivers;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.dataadapters.JPhyloIOEventReceiver;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.IllegalEventException;
import info.bioinfweb.jphyloio.exception.JPhyloIOWriterException;
import java.io.IOException;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;

public class BasicEventReceiver<P extends WriterStreamDataProvider<? extends AbstractEventWriter<P>>>
implements JPhyloIOEventReceiver {
    private ReadWriteParameterMap parameterMap;
    private P streamDataProvider;
    private Stack<JPhyloIOEvent> parentEvents = new Stack();
    private long ignoredComments = 0L;
    private long ignoredLiteralMetadata = 0L;
    private long ignoredResourceMetadata = 0L;
    private boolean inComment = false;

    public BasicEventReceiver(P p, ReadWriteParameterMap readWriteParameterMap) {
        this.streamDataProvider = p;
        this.parameterMap = readWriteParameterMap;
    }

    public ReadWriteParameterMap getParameterMap() {
        return this.parameterMap;
    }

    public P getStreamDataProvider() {
        return this.streamDataProvider;
    }

    public ApplicationLogger getLogger() {
        return this.getParameterMap().getApplicationLogger("info.bioinfweb.jphyloio.logger");
    }

    public Stack<JPhyloIOEvent> getParentEvents() {
        return this.parentEvents;
    }

    public JPhyloIOEvent getParentEvent() {
        if (!this.getParentEvents().isEmpty()) {
            return this.getParentEvents().peek();
        }
        return null;
    }

    public boolean isInComment() {
        return this.inComment;
    }

    public long getIgnoredComments() {
        return this.ignoredComments;
    }

    public boolean didIgnoreComments() {
        return this.getIgnoredComments() > 0L;
    }

    protected void addIgnoredComments(long l) {
        this.ignoredComments += l;
    }

    public long getIgnoredLiteralMetadata() {
        return this.ignoredLiteralMetadata;
    }

    public boolean didIgnoreLiteralMetadata() {
        return this.getIgnoredLiteralMetadata() > 0L;
    }

    protected void addIgnoredLiteralMetadata(long l) {
        this.ignoredLiteralMetadata += l;
    }

    public long getIgnoredResourceMetadata() {
        return this.ignoredResourceMetadata;
    }

    public boolean didIgnoreResourceMetadata() {
        return this.getIgnoredResourceMetadata() > 0L;
    }

    public boolean didIgnoreMetadata() {
        return this.didIgnoreLiteralMetadata() || this.didIgnoreResourceMetadata();
    }

    public long getIgnoredMetadata() {
        return this.getIgnoredLiteralMetadata() + this.getIgnoredResourceMetadata();
    }

    protected void addIgnoredResourceMetadata(long l) {
        this.ignoredResourceMetadata += l;
    }

    protected void handleLiteralMetaStart(LiteralMetadataEvent literalMetadataEvent) throws IOException, XMLStreamException {
        this.addIgnoredLiteralMetadata(1L);
    }

    protected void handleLiteralContentMeta(LiteralMetadataContentEvent literalMetadataContentEvent) throws IOException, XMLStreamException {
    }

    protected void handleResourceMetaStart(ResourceMetadataEvent resourceMetadataEvent) throws IOException, XMLStreamException {
        this.addIgnoredResourceMetadata(1L);
    }

    protected void handleComment(CommentEvent commentEvent) throws IOException, XMLStreamException {
        this.addIgnoredComments(1L);
    }

    protected void handleMetaEndEvent(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
    }

    protected boolean doAdd(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        throw IllegalEventException.newInstance(this, this.getParentEvent(), jPhyloIOEvent);
    }

    @Override
    public boolean add(JPhyloIOEvent jPhyloIOEvent) throws IOException {
        try {
            if (this.isInComment() && !jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.COMMENT)) {
                throw new IllegalEventException("A non-comment event was encountered after a comment event that indicated to be continued in the next event.", this, this.getParentEvent(), jPhyloIOEvent);
            }
            boolean bl = true;
            JPhyloIOEvent jPhyloIOEvent2 = this.getParentEvent();
            if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.END)) {
                if (jPhyloIOEvent2 == null || !jPhyloIOEvent2.getType().getContentType().equals((Object)jPhyloIOEvent.getType().getContentType())) {
                    throw IllegalEventException.newInstance(this, jPhyloIOEvent2, jPhyloIOEvent);
                }
                this.getParentEvents().pop();
                jPhyloIOEvent2 = this.getParentEvent();
            }
            switch (jPhyloIOEvent.getType().getContentType()) {
                case RESOURCE_META: {
                    if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                        this.handleResourceMetaStart(jPhyloIOEvent.asResourceMetadataEvent());
                        break;
                    }
                    this.handleMetaEndEvent(jPhyloIOEvent);
                    break;
                }
                case LITERAL_META: {
                    if (jPhyloIOEvent2 == null || !jPhyloIOEvent2.getType().getContentType().equals((Object)EventContentType.LITERAL_META)) {
                        if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                            this.handleLiteralMetaStart(jPhyloIOEvent.asLiteralMetadataEvent());
                            break;
                        }
                        this.handleMetaEndEvent(jPhyloIOEvent);
                        break;
                    }
                    throw IllegalEventException.newInstance(this, jPhyloIOEvent2, jPhyloIOEvent);
                }
                case LITERAL_META_CONTENT: {
                    if (jPhyloIOEvent2 != null && jPhyloIOEvent2.getType().getContentType().equals((Object)EventContentType.LITERAL_META)) {
                        this.handleLiteralContentMeta(jPhyloIOEvent.asLiteralMetadataContentEvent());
                        break;
                    }
                    throw IllegalEventException.newInstance(this, jPhyloIOEvent2, jPhyloIOEvent);
                }
                case COMMENT: {
                    CommentEvent commentEvent = jPhyloIOEvent.asCommentEvent();
                    this.handleComment(commentEvent);
                    this.inComment = commentEvent.isContinuedInNextEvent();
                    break;
                }
                default: {
                    if (jPhyloIOEvent2 == null) {
                        bl = this.doAdd(jPhyloIOEvent);
                        break;
                    }
                    throw IllegalEventException.newInstance(this, jPhyloIOEvent2, jPhyloIOEvent);
                }
            }
            if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                this.getParentEvents().add(jPhyloIOEvent);
            }
            return bl;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new JPhyloIOWriterException("An XMLStream exception with the message \"" + xMLStreamException.getMessage() + "\" occured when trying to add an event to this receiver.", xMLStreamException);
        }
    }

    public void addIgnoreLogMessage(ApplicationLogger applicationLogger, String string, String string2) {
        if (applicationLogger == null || string == null || string2 == null) {
            throw new NullPointerException("None of the parameters of this method may be null.");
        }
        if (this.didIgnoreMetadata()) {
            applicationLogger.addWarning(this.getIgnoredMetadata() + " metadata element(s) attached to " + string + " was/were ignored, since the " + string2 + " format does not support it at this position.");
        }
        if (this.didIgnoreComments()) {
            applicationLogger.addWarning(this.getIgnoredComments() + " comment(s) attached to " + string + " was/were ignored, since the " + string2 + " format does not support it at this position.");
        }
    }
}

