/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.dataadapters.implementations.receivers;

import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.dataadapters.implementations.receivers.BasicEventReceiver;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SingleSequenceTokenEvent;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractSequenceContentReceiver<P extends WriterStreamDataProvider<? extends AbstractEventWriter<P>>>
extends BasicEventReceiver<P> {
    private boolean longTokens;

    public AbstractSequenceContentReceiver(P p, ReadWriteParameterMap readWriteParameterMap, boolean bl) {
        super(p, readWriteParameterMap);
        this.longTokens = bl;
    }

    protected abstract void handleToken(String var1, String var2) throws IOException, XMLStreamException;

    @Override
    protected boolean doAdd(JPhyloIOEvent jPhyloIOEvent) throws XMLStreamException, IOException {
        switch (jPhyloIOEvent.getType().getContentType()) {
            case SINGLE_SEQUENCE_TOKEN: {
                if (!jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) break;
                SingleSequenceTokenEvent singleSequenceTokenEvent = jPhyloIOEvent.asSingleSequenceTokenEvent();
                this.handleToken(singleSequenceTokenEvent.getToken(), singleSequenceTokenEvent.getLabel());
                break;
            }
            case SEQUENCE_TOKENS: {
                for (String string : jPhyloIOEvent.asSequenceTokensEvent().getTokens()) {
                    this.handleToken(string, null);
                }
                break;
            }
        }
        return true;
    }

    public boolean isLongTokens() {
        return this.longTokens;
    }
}

