/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio;

import info.bioinfweb.commons.LongIDManager;
import info.bioinfweb.jphyloio.JPhyloIOEventReader;
import info.bioinfweb.jphyloio.ParentEventInformation;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.ReaderStreamDataProvider;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.events.type.EventType;
import info.bioinfweb.jphyloio.push.JPhyloIOEventListener;
import info.bioinfweb.jphyloio.utils.SequenceTokensEventManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;

public abstract class AbstractEventReader<P extends ReaderStreamDataProvider<? extends AbstractEventReader<P>>>
implements JPhyloIOEventReader,
ReadWriteConstants {
    private JPhyloIOEvent next = null;
    private JPhyloIOEvent previous = null;
    private JPhyloIOEvent lastNonComment = null;
    private ParentEventInformation parentEventInformation = new ParentEventInformation();
    private P streamDataProvider;
    private Queue<JPhyloIOEvent> upcomingEvents = new LinkedList<JPhyloIOEvent>();
    private Stack<Collection<JPhyloIOEvent>> eventCollections = new Stack();
    private boolean beforeFirstAccess = true;
    private boolean dataSourceClosed = false;
    private ReadWriteParameterMap parameters;
    private LongIDManager idManager = new LongIDManager();
    private SequenceTokensEventManager sequenceTokensEventManager;
    private List<JPhyloIOEventListener> eventListeners = new ArrayList<JPhyloIOEventListener>();

    public AbstractEventReader(ReadWriteParameterMap readWriteParameterMap, String string) {
        this.parameters = readWriteParameterMap;
        this.sequenceTokensEventManager = new SequenceTokensEventManager(this, string);
        this.streamDataProvider = this.createStreamDataProvider();
        this.eventCollections.add(this.upcomingEvents);
    }

    @Override
    public ParentEventInformation getParentInformation() {
        return this.parentEventInformation;
    }

    protected P createStreamDataProvider() {
        return (P)new ReaderStreamDataProvider<AbstractEventReader>(this);
    }

    protected P getStreamDataProvider() {
        return this.streamDataProvider;
    }

    protected ReadWriteParameterMap getParameters() {
        return this.parameters;
    }

    protected Collection<JPhyloIOEvent> resetCurrentEventCollection() {
        return this.eventCollections.pop();
    }

    protected Collection<JPhyloIOEvent> setCurrentEventCollection(Collection<JPhyloIOEvent> collection) {
        if (collection == null) {
            throw new NullPointerException("The current event collection must not be null.");
        }
        Collection<JPhyloIOEvent> collection2 = this.eventCollections.peek();
        this.eventCollections.add(collection);
        return collection2;
    }

    protected Collection<JPhyloIOEvent> getCurrentEventCollection() {
        return this.eventCollections.peek();
    }

    protected boolean hasSpecialEventCollection() {
        return this.upcomingEvents != this.eventCollections.peek();
    }

    protected Queue<JPhyloIOEvent> getUpcomingEvents() {
        return this.upcomingEvents;
    }

    protected LongIDManager getIDManager() {
        return this.idManager;
    }

    protected SequenceTokensEventManager getSequenceTokensEventManager() {
        return this.sequenceTokensEventManager;
    }

    protected void fireEvent(JPhyloIOEvent jPhyloIOEvent) throws IOException {
        for (JPhyloIOEventListener jPhyloIOEventListener : this.eventListeners.toArray(new JPhyloIOEventListener[this.eventListeners.size()])) {
            jPhyloIOEventListener.processEvent(this, jPhyloIOEvent);
        }
    }

    @Override
    public JPhyloIOEvent getPreviousEvent() {
        return this.previous;
    }

    @Override
    public JPhyloIOEvent getLastNonCommentEvent() {
        return this.lastNonComment;
    }

    protected boolean isBeforeFirstAccess() {
        return this.beforeFirstAccess;
    }

    private JPhyloIOEvent getNextEventFromQueue() throws IOException {
        if (this.getUpcomingEvents().isEmpty()) {
            this.readNextEvent();
        }
        return this.getUpcomingEvents().poll();
    }

    @Override
    public boolean hasNextEvent() throws IOException {
        this.ensureFirstEvent();
        return !this.dataSourceClosed && this.next != null;
    }

    @Override
    public JPhyloIOEvent next() throws IOException {
        if (!this.hasNextEvent()) {
            throw new NoSuchElementException("The end of the document was already reached.");
        }
        if (this.previous != null && this.previous.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
            this.parentEventInformation.add(this.previous);
        }
        if (this.next != null && this.next.getType().getTopologyType().equals((Object)EventTopologyType.END)) {
            this.parentEventInformation.pop();
        }
        this.previous = this.next;
        if (!(this.previous instanceof CommentEvent)) {
            this.lastNonComment = this.previous;
        }
        this.next = this.getNextEventFromQueue();
        this.fireEvent(this.previous);
        return this.previous;
    }

    @Override
    public JPhyloIOEvent nextOfType(Set<EventType> set) throws IOException {
        try {
            JPhyloIOEvent jPhyloIOEvent = this.next();
            while (!set.contains(jPhyloIOEvent.getType())) {
                jPhyloIOEvent = this.next();
            }
            return jPhyloIOEvent;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public JPhyloIOEvent peek() throws IOException {
        if (!this.hasNextEvent()) {
            throw new NoSuchElementException("The end of the document was already reached.");
        }
        return this.next;
    }

    private void ensureFirstEvent() throws IOException {
        if (this.beforeFirstAccess) {
            this.next = this.getNextEventFromQueue();
            this.beforeFirstAccess = false;
        }
    }

    @Override
    public void addEventListener(JPhyloIOEventListener jPhyloIOEventListener) {
        this.eventListeners.add(jPhyloIOEventListener);
    }

    @Override
    public void removeEventListener(JPhyloIOEventListener jPhyloIOEventListener) {
        this.eventListeners.remove(jPhyloIOEventListener);
    }

    protected abstract void readNextEvent() throws IOException;

    @Override
    public void close() throws IOException {
        this.dataSourceClosed = true;
    }
}

