/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.errorreport.swing;

import info.bioinfweb.commons.appversion.ApplicationVersion;
import info.bioinfweb.errorreport.swing.ErrorReportDialog;
import info.bioinfweb.errorreport.swing.ErrorReportDialogRunnable;
import java.awt.KeyboardFocusManager;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SwingErrorReporter
implements Thread.UncaughtExceptionHandler {
    private String targetURL;
    private ApplicationVersion applicationVersion = null;

    public SwingErrorReporter(String targetURL, ApplicationVersion applicationVersion) {
        this.targetURL = targetURL;
        this.applicationVersion = applicationVersion;
    }

    @Override
    public void uncaughtException(Thread t, Throwable throwable) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                ErrorReportDialog.show(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), this.targetURL, throwable, this.applicationVersion);
            } else {
                SwingUtilities.invokeLater(new ErrorReportDialogRunnable(this.targetURL, throwable, this.applicationVersion));
            }
        }
        catch (Exception e) {
            try {
                JOptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), "An error occurred when trying to dislay the error report dialog.", "Error", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

