/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.errorreport.swing;

import info.bioinfweb.commons.appversion.ApplicationVersion;
import info.bioinfweb.errorreport.io.ExceptionWriter;
import javax.xml.stream.XMLStreamException;

public class HTMLGenerator {
    public static final String CLOSE_LINK = "exit";
    public static final String TERMINATE_LINK = "terminate";
    public static final String RESOURCES_PATH = "/resources/html/";
    private static ExceptionWriter writer = new ExceptionWriter();

    private static String maskXMLForParam(String xml) {
        return xml.replaceAll("\"", "&quot;");
    }

    private static String maskXMLForDisplaying(String xml) {
        return HTMLGenerator.maskXMLForParam(xml).replaceAll("><", ">\n<").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>");
    }

    private static String getPath(String file) {
        return HTMLGenerator.class.getResource(RESOURCES_PATH + file).toString();
    }

    public static String generateMessage(Throwable e, ApplicationVersion applicationVersion, String target) throws XMLStreamException {
        String report = writer.write(e, applicationVersion);
        return "<html><head><link rel='stylesheet' type='text/css' href='" + HTMLGenerator.getPath("ErrorReport.css") + "'></head>" + "<body style='font-family: sans-serif'>" + "<p>The error \"" + e.toString() + "\" occurred.</p>" + "<p><b>Do you want to send an error report</b> and help to fix this problem in future versions of this software<b>?</b> (Internet access is required.)<br>" + "No personal information will be included. <b>Scroll down to see the information which will be tranferred.</b><br>" + "If you choose to terminate the application now, all unsaved data will be lost.</p>" + "<p><form action='" + target + "' method='post'>" + "<input type='hidden' name='error' value='" + HTMLGenerator.maskXMLForParam(report) + "'>" + "<div align='center'>" + "<input type='submit' value='Send error report'>&nbsp;" + "<a href='" + CLOSE_LINK + "'><img border='0' src='" + HTMLGenerator.getPath("DoNotSendButton.png") + "'></a>&nbsp;" + "<a href='" + TERMINATE_LINK + "'><img border='0' src='" + HTMLGenerator.getPath("TerminateButton.png") + "'></a>" + "</div>" + "</form></p><br><br>" + "<h2>The following XML-data will be transfered:</h2>" + "<code>" + HTMLGenerator.maskXMLForDisplaying(report) + "</code>" + "</body>" + "</html>";
    }
}

