/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.errorreport.swing;

import info.bioinfweb.commons.appversion.ApplicationVersion;
import info.bioinfweb.errorreport.swing.HTMLGenerator;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.stream.XMLStreamException;

public class ErrorReportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel reportPanel = null;
    private JScrollPane scrollPane = null;
    private JEditorPane htmlField = null;

    private ErrorReportDialog(Window owner, String targetURL, Throwable throwable, ApplicationVersion applicationVersion) throws XMLStreamException {
        super(owner, "Send error report", Dialog.ModalityType.APPLICATION_MODAL);
        this.initialize();
        this.getHTMLField().setText(HTMLGenerator.generateMessage(throwable, applicationVersion, targetURL));
    }

    public static void show(Window owner, String targetURL, Throwable throwable, ApplicationVersion applicationVersion) {
        try {
            ErrorReportDialog dialog = new ErrorReportDialog(owner, targetURL, throwable, applicationVersion);
            SwingUtilities.invokeLater(new TopScroller(dialog.getScrollPane().getVerticalScrollBar()));
            dialog.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(owner, "An error occurred. Additionally an error occurred while processing this error.", "Error.", 0);
        }
    }

    private void initialize() {
        this.setSize(480, 300);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getReportPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getReportPanel() {
        if (this.reportPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.reportPanel = new JPanel();
            this.reportPanel.setLayout(new GridBagLayout());
            this.reportPanel.add((Component)this.getScrollPane(), gridBagConstraints);
        }
        return this.reportPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getHTMLField());
        }
        return this.scrollPane;
    }

    private JEditorPane getHTMLField() {
        if (this.htmlField == null) {
            this.htmlField = new JEditorPane();
            this.htmlField.setContentType("text/html");
            this.htmlField.setEditable(false);
            ((HTMLEditorKit)this.htmlField.getEditorKit()).setAutoFormSubmission(true);
            this.htmlField.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        if (e.getDescription().equals("exit")) {
                            ErrorReportDialog.this.setVisible(false);
                        } else if (e.getDescription().equals("terminate")) {
                            System.exit(-1);
                        } else {
                            try {
                                Desktop.getDesktop().browse(e.getURL().toURI());
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(ErrorReportDialog.this.getOwner(), "An error occurred when trying open the selected link.", "Navigation failed,", 0);
                            }
                        }
                    }
                }
            });
        }
        return this.htmlField;
    }

    private static class TopScroller
    implements Runnable {
        private JScrollBar scrollbar;

        public TopScroller(JScrollBar scrollbar) {
            this.scrollbar = scrollbar;
        }

        @Override
        public void run() {
            this.scrollbar.setValue(0);
        }
    }
}

