/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.errorreport.io;

import info.bioinfweb.commons.appversion.ApplicationType;
import info.bioinfweb.commons.appversion.ApplicationVersion;
import info.bioinfweb.errorreport.io.ExceptionXMLConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ExceptionWriter
implements ExceptionXMLConstants {
    public static final String STREAM_ENCODING = "UTF8";
    public static String XML_VERSION = "1.0";
    public static String XML_ENCODING = "UTF-8";
    private XMLStreamWriter writer = null;

    private void writeStackTrace(StackTraceElement[] elements) throws XMLStreamException {
        this.writer.writeStartElement(TAG_STACK_TRACE.toString());
        int i = 0;
        while (i < elements.length) {
            this.writer.writeStartElement(TAG_STACK_TRACE_ELEMENT.toString());
            this.writer.writeStartElement(TAG_CLASS_NAME.toString());
            this.writer.writeCharacters(elements[i].getClassName());
            this.writer.writeEndElement();
            this.writer.writeStartElement(TAG_FILE_NAME.toString());
            this.writer.writeCharacters(elements[i].getFileName());
            this.writer.writeEndElement();
            this.writer.writeStartElement(TAG_METHOD_NAME.toString());
            this.writer.writeCharacters(elements[i].getMethodName());
            this.writer.writeEndElement();
            this.writer.writeStartElement(TAG_LINE_NO.toString());
            this.writer.writeCharacters("" + elements[i].getLineNumber());
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            ++i;
        }
        this.writer.writeEndElement();
    }

    private void writeAppVersion(ApplicationVersion version) throws XMLStreamException {
        this.writer.writeStartElement(TAG_APP_VERSION.toString());
        this.writer.writeAttribute(ATTR_MAJOR_APP_VERSION.toString(), "" + version.getMajorRelease());
        this.writer.writeAttribute(ATTR_MINOR_APP_VERSION.toString(), "" + version.getMinorRelease());
        this.writer.writeAttribute(ATTR_PATCH_LEVEL.toString(), "" + version.getPatchLevel());
        this.writer.writeAttribute(ATTR_BUILD_NO.toString(), "" + version.getBuildNumber());
        if (!version.getType().equals((Object)ApplicationType.STABLE)) {
            this.writer.writeAttribute(ATTR_APP_TYPE.toString(), "" + version.getType());
        }
        this.writer.writeEndElement();
    }

    private void writeDocument(Throwable e, ApplicationVersion version) throws XMLStreamException {
        try {
            this.writer.writeStartDocument(XML_ENCODING, XML_VERSION);
            this.writer.writeStartElement(TAG_ROOT.toString());
            this.writeAppVersion(version);
            this.writer.writeStartElement(TAG_ERROR.toString());
            this.writer.writeStartElement(TAG_DESCRIPTION.toString());
            this.writer.writeCharacters(e.toString());
            this.writer.writeEndElement();
            this.writer.writeStartElement(TAG_MESSAGE.toString());
            this.writer.writeCharacters(e.getMessage());
            this.writer.writeEndElement();
            this.writeStackTrace(e.getStackTrace());
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
        }
        finally {
            this.writer.close();
        }
    }

    public void write(Throwable e, ApplicationVersion version, OutputStream stream) throws XMLStreamException, IOException {
        try {
            this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stream, STREAM_ENCODING);
            this.writeDocument(e, version);
        }
        finally {
            stream.close();
        }
    }

    public String write(Throwable e, ApplicationVersion version) throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stringWriter);
        this.writeDocument(e, version);
        return stringWriter.getBuffer().toString();
    }
}

