/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.errorreport.io;

import info.bioinfweb.commons.appversion.ApplicationType;
import info.bioinfweb.commons.appversion.ApplicationVersion;
import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.errorreport.ErrorReport;
import info.bioinfweb.errorreport.io.ExceptionXMLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ExceptionReader
implements ExceptionXMLConstants {
    private XMLEventReader reader;
    private ErrorReport report;

    private StackTraceElement readStackTraceElement() throws XMLStreamException {
        String className = "";
        String fileName = "";
        String methodName = "";
        int lineNo = 0;
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_CLASS_NAME)) {
                    className = this.reader.nextEvent().asCharacters().getData();
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_FILE_NAME)) {
                    fileName = this.reader.nextEvent().asCharacters().getData();
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_METHOD_NAME)) {
                    methodName = this.reader.nextEvent().asCharacters().getData();
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_LINE_NO)) {
                    try {
                        lineNo = Integer.parseInt(this.reader.nextEvent().asCharacters().getData());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.reader.nextEvent();
                } else {
                    XMLUtils.reachElementEnd((XMLEventReader)this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
        return new StackTraceElement(className, methodName, fileName, lineNo);
    }

    private void readStackTrace() throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_STACK_TRACE_ELEMENT)) {
                    this.report.getStackTrace().add(this.readStackTraceElement());
                    this.reader.nextEvent();
                } else {
                    XMLUtils.reachElementEnd((XMLEventReader)this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readError() throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_DESCRIPTION)) {
                    this.report.setDescription(this.reader.nextEvent().asCharacters().getData());
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_MESSAGE)) {
                    this.report.setMessage(this.reader.nextEvent().asCharacters().getData());
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_STACK_TRACE)) {
                    this.readStackTrace();
                    this.reader.nextEvent();
                } else {
                    XMLUtils.reachElementEnd((XMLEventReader)this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readAppVersion(StartElement element) throws XMLStreamException {
        ApplicationVersion version = new ApplicationVersion();
        version.setMajorRelease(XMLUtils.readIntAttr((StartElement)element, (QName)ATTR_MAJOR_APP_VERSION, (int)-1));
        version.setMinorRelease(XMLUtils.readIntAttr((StartElement)element, (QName)ATTR_MINOR_APP_VERSION, (int)-1));
        version.setPatchLevel(XMLUtils.readIntAttr((StartElement)element, (QName)ATTR_PATCH_LEVEL, (int)-1));
        version.setBuildNumber((long)XMLUtils.readIntAttr((StartElement)element, (QName)ATTR_BUILD_NO, (int)-1));
        ApplicationType type = ApplicationType.parseType((String)XMLUtils.readStringAttr((StartElement)element, (QName)ATTR_APP_TYPE, null));
        if (type != null) {
            version.setType(type);
        }
        this.report.setApplicationVersion(version);
    }

    private void readRoot() throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_APP_VERSION)) {
                    this.readAppVersion(element);
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_IP)) {
                    this.report.setIP(this.reader.nextEvent().asCharacters().getData());
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_DATE)) {
                    try {
                        this.report.setDate(DateFormat.getDateTimeInstance().parse(this.reader.nextEvent().asCharacters().getData()));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_ERROR)) {
                    this.readError();
                    this.reader.nextEvent();
                } else {
                    XMLUtils.reachElementEnd((XMLEventReader)this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readDocument() throws XMLStreamException {
        while (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextEvent();
            switch (event.getEventType()) {
                case 7: {
                    break;
                }
                case 8: {
                    this.reader.close();
                    return;
                }
                case 1: {
                    StartElement element = event.asStartElement();
                    if (element.getName().equals(TAG_ROOT)) {
                        this.readRoot();
                        this.reader.nextEvent();
                        break;
                    }
                    XMLUtils.reachElementEnd((XMLEventReader)this.reader);
                }
            }
        }
    }

    public ErrorReport read(Reader r) throws XMLStreamException {
        this.reader = XMLInputFactory.newInstance().createXMLEventReader(r);
        this.report = new ErrorReport();
        try {
            this.readDocument();
        }
        finally {
            this.reader.close();
        }
        return this.report;
    }

    public ErrorReport read(InputStream stream) throws XMLStreamException {
        this.reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
        this.report = new ErrorReport();
        try {
            this.readDocument();
        }
        finally {
            this.reader.close();
        }
        return this.report;
    }

    public ErrorReport read(String data) throws XMLStreamException {
        return this.read(new StringReader(data));
    }

    public ErrorReport read(File file) throws XMLStreamException, FileNotFoundException {
        return this.read(new FileInputStream(file));
    }
}

