/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.scrollpaneselector;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ScrollPaneBidule
extends JComponent {
    private static final double MAX_SIZE = 200.0;
    private JScrollPane theScrollPane;
    private JComponent theComponent;
    private JPopupMenu thePopupMenu;
    private JButton theButton;
    private BufferedImage theImage;
    private Rectangle theStartRectangle;
    private Rectangle theRectangle;
    private Point theStartPoint;
    private double theScale;

    public ScrollPaneBidule(JScrollPane jScrollPane) {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.theScrollPane = jScrollPane;
        this.theComponent = (JComponent)this.theScrollPane.getViewport().getView();
        this.theImage = null;
        this.theStartRectangle = null;
        this.theRectangle = null;
        this.theStartPoint = null;
        this.theScale = 0.0;
        this.theButton = new JButton(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScrollPaneBidule.this.display();
            }
        });
        this.theScrollPane.setCorner("LOWER_RIGHT_CORNER", this.theButton);
        this.setCursor(Cursor.getPredefinedCursor(13));
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ScrollPaneBidule.this.theStartPoint = mouseEvent.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (ScrollPaneBidule.this.theStartPoint != null) {
                    Point point = mouseEvent.getPoint();
                    int n = (int)((double)(point.x - ((ScrollPaneBidule)ScrollPaneBidule.this).theStartPoint.x) / ScrollPaneBidule.this.theScale);
                    int n2 = (int)((double)(point.y - ((ScrollPaneBidule)ScrollPaneBidule.this).theStartPoint.y) / ScrollPaneBidule.this.theScale);
                    ScrollPaneBidule.this.scroll(n, n2);
                }
                ScrollPaneBidule.this.theStartPoint = null;
                ScrollPaneBidule.this.theStartRectangle = ScrollPaneBidule.this.theRectangle;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (ScrollPaneBidule.this.theStartPoint == null) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                ScrollPaneBidule.this.moveRectangle(point.x - ((ScrollPaneBidule)ScrollPaneBidule.this).theStartPoint.x, point.y - ((ScrollPaneBidule)ScrollPaneBidule.this).theStartPoint.y);
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this.thePopupMenu = new JPopupMenu();
        this.thePopupMenu.setLayout(new BorderLayout());
        this.thePopupMenu.add((Component)this, "Center");
        this.thePopupMenu.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.theImage == null || this.theRectangle == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        graphics2D.drawImage((Image)this.theImage, n, n2, null);
        Color color = graphics2D.getColor();
        Area area = new Area(new Rectangle(n, n2, n3, n4));
        area.subtract(new Area(this.theRectangle));
        graphics2D.setColor(new Color(255, 255, 255, 128));
        graphics2D.fill(area);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.theRectangle);
        graphics2D.setColor(color);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.theImage == null || this.theRectangle == null) {
            return new Dimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this.theImage.getWidth(null) + insets.left + insets.right, this.theImage.getHeight(null) + insets.top + insets.bottom);
    }

    private void display() {
        double d = this.theComponent.getWidth();
        double d2 = this.theComponent.getHeight();
        double d3 = 200.0 / d;
        double d4 = 200.0 / d2;
        this.theScale = Math.min(d3, d4);
        this.theImage = new BufferedImage((int)((double)this.theComponent.getWidth() * this.theScale), (int)((double)this.theComponent.getHeight() * this.theScale), 1);
        Graphics2D graphics2D = this.theImage.createGraphics();
        graphics2D.scale(this.theScale, this.theScale);
        this.theComponent.paint(graphics2D);
        this.theStartRectangle = this.theComponent.getVisibleRect();
        Insets insets = this.getInsets();
        this.theStartRectangle.x = (int)(this.theScale * (double)this.theStartRectangle.x + (double)insets.left);
        this.theStartRectangle.y = (int)(this.theScale * (double)this.theStartRectangle.y + (double)insets.right);
        this.theStartRectangle.width = (int)((double)this.theStartRectangle.width * this.theScale);
        this.theStartRectangle.height = (int)((double)this.theStartRectangle.height * this.theScale);
        this.theRectangle = this.theStartRectangle;
        Dimension dimension = this.thePopupMenu.getPreferredSize();
        this.thePopupMenu.show(this.theButton, (this.theButton.getWidth() - dimension.width) / 2, (this.theButton.getHeight() - dimension.height) / 2);
        try {
            Robot robot = new Robot();
            Point point = new Point(this.theRectangle.x + this.theRectangle.width / 2, this.theRectangle.y + this.theRectangle.height / 2);
            SwingUtilities.convertPointToScreen(point, this);
            robot.mouseMove(point.x, point.y);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
    }

    private void moveRectangle(int n, int n2) {
        if (this.theStartRectangle == null) {
            return;
        }
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(this.theStartRectangle);
        rectangle.x += n;
        rectangle.y += n2;
        rectangle.x = Math.min(Math.max(rectangle.x, insets.left), this.getWidth() - insets.right - rectangle.width);
        rectangle.y = Math.min(Math.max(rectangle.y, insets.right), this.getHeight() - insets.bottom - rectangle.height);
        Rectangle rectangle2 = new Rectangle();
        Rectangle.union(this.theRectangle, rectangle, rectangle2);
        rectangle2.grow(2, 2);
        this.theRectangle = rectangle;
        this.paintImmediately(rectangle2);
    }

    private void scroll(int n, int n2) {
        JComponent jComponent = (JComponent)this.theScrollPane.getViewport().getView();
        Rectangle rectangle = jComponent.getVisibleRect();
        rectangle.x += n;
        rectangle.y += n2;
        jComponent.scrollRectToVisible(rectangle);
        this.thePopupMenu.setVisible(false);
    }
}

