/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing.scrollpaneselector;

import info.bioinfweb.commons.swing.scrollpaneselector.ScrollPaneSelectable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.scrollpaneselector.TweakedScrollPaneLayout;

public class ExtendedScrollPaneSelector
extends JComponent {
    private static final double MAX_SIZE = 200.0;
    private static final String COMPONENT_ORIENTATION = "componentOrientation";
    private static final Icon LAUNCH_SELECTOR_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(Color.BLACK);
            graphics.drawRect(2, 2, 10, 10);
            graphics.drawRect(4, 5, 6, 4);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 15;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }
    };
    private static Map<JScrollPane, ExtendedScrollPaneSelector> theInstalledScrollPaneSelectors = new HashMap<JScrollPane, ExtendedScrollPaneSelector>();
    private LayoutManager theFormerLayoutManager;
    private JScrollPane theScrollPane;
    private JComponent theComponent;
    private JPopupMenu thePopupMenu;
    private JComponent theButton;
    private BufferedImage theImage;
    private Rectangle theStartRectangle;
    private Rectangle theRectangle;
    private Point theStartPoint;
    private double theScale;
    private PropertyChangeListener theComponentOrientationListener;
    private ContainerAdapter theViewPortViewListener;

    public static synchronized void installScrollPaneSelector(JScrollPane jScrollPane) {
        if (jScrollPane == null) {
            return;
        }
        if (theInstalledScrollPaneSelectors.containsKey(jScrollPane)) {
            return;
        }
        ExtendedScrollPaneSelector extendedScrollPaneSelector = new ExtendedScrollPaneSelector();
        extendedScrollPaneSelector.installOnScrollPane(jScrollPane);
        theInstalledScrollPaneSelectors.put(jScrollPane, extendedScrollPaneSelector);
    }

    public static synchronized void uninstallScrollPaneSelector(JScrollPane jScrollPane) {
        if (jScrollPane == null) {
            return;
        }
        ExtendedScrollPaneSelector extendedScrollPaneSelector = theInstalledScrollPaneSelectors.get(jScrollPane);
        if (extendedScrollPaneSelector == null) {
            return;
        }
        extendedScrollPaneSelector.uninstallFromScrollPane();
        theInstalledScrollPaneSelectors.remove(jScrollPane);
    }

    private ExtendedScrollPaneSelector() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.theScrollPane = null;
        this.theImage = null;
        this.theStartRectangle = null;
        this.theRectangle = null;
        this.theStartPoint = null;
        this.theScale = 0.0;
        this.theButton = new JLabel(LAUNCH_SELECTOR_ICON);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ExtendedScrollPaneSelector.this.theComponent.getWidth() > 0 && ExtendedScrollPaneSelector.this.theComponent.getHeight() > 0) {
                    Point point = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(point, ExtendedScrollPaneSelector.this.theButton);
                    ExtendedScrollPaneSelector.this.display(point);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (ExtendedScrollPaneSelector.this.theStartPoint != null) {
                    Point point = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
                    int n = (int)((double)(point.x - ((ExtendedScrollPaneSelector)ExtendedScrollPaneSelector.this).theStartPoint.x) / ExtendedScrollPaneSelector.this.theScale);
                    int n2 = (int)((double)(point.y - ((ExtendedScrollPaneSelector)ExtendedScrollPaneSelector.this).theStartPoint.y) / ExtendedScrollPaneSelector.this.theScale);
                    ExtendedScrollPaneSelector.this.scroll(n, n2);
                }
                ExtendedScrollPaneSelector.this.theStartPoint = null;
                ExtendedScrollPaneSelector.this.theStartRectangle = ExtendedScrollPaneSelector.this.theRectangle;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (ExtendedScrollPaneSelector.this.theStartPoint == null) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
                ExtendedScrollPaneSelector.this.moveRectangle(point.x - ((ExtendedScrollPaneSelector)ExtendedScrollPaneSelector.this).theStartPoint.x, point.y - ((ExtendedScrollPaneSelector)ExtendedScrollPaneSelector.this).theStartPoint.y);
            }
        };
        this.theButton.addMouseListener(mouseInputAdapter);
        this.theButton.addMouseMotionListener(mouseInputAdapter);
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.thePopupMenu = new JPopupMenu();
        this.thePopupMenu.setLayout(new BorderLayout());
        this.thePopupMenu.add((Component)this, "Center");
        this.theComponentOrientationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ExtendedScrollPaneSelector.this.theScrollPane == null) {
                    return;
                }
                ExtendedScrollPaneSelector.this.theScrollPane.setCorner("LOWER_LEADING_CORNER", null);
                ExtendedScrollPaneSelector.this.theScrollPane.setCorner("LOWER_TRAILING_CORNER", ExtendedScrollPaneSelector.this.theButton);
            }
        };
        this.theViewPortViewListener = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                Component component;
                if (ExtendedScrollPaneSelector.this.thePopupMenu.isVisible()) {
                    ExtendedScrollPaneSelector.this.thePopupMenu.setVisible(false);
                }
                ExtendedScrollPaneSelector.this.theComponent = (component = ExtendedScrollPaneSelector.this.theScrollPane.getViewport().getView()) instanceof JComponent ? (JComponent)component : null;
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.theImage == null || this.theRectangle == null) {
            return new Dimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this.theImage.getWidth(null) + insets.left + insets.right, this.theImage.getHeight(null) + insets.top + insets.bottom);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.theImage == null || this.theRectangle == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        graphics2D.drawImage((Image)this.theImage, n, n2, null);
        Color color = graphics2D.getColor();
        Area area = new Area(new Rectangle(n, n2, n3, n4));
        area.subtract(new Area(this.theRectangle));
        graphics2D.setColor(new Color(200, 200, 200, 128));
        graphics2D.fill(area);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.theRectangle);
        graphics2D.setColor(color);
    }

    private void installOnScrollPane(JScrollPane jScrollPane) {
        if (this.theScrollPane != null) {
            this.uninstallFromScrollPane();
        }
        this.theScrollPane = jScrollPane;
        this.theFormerLayoutManager = this.theScrollPane.getLayout();
        this.theScrollPane.setLayout(new TweakedScrollPaneLayout());
        this.theScrollPane.addPropertyChangeListener(COMPONENT_ORIENTATION, this.theComponentOrientationListener);
        this.theScrollPane.getViewport().addContainerListener(this.theViewPortViewListener);
        this.theScrollPane.setCorner("LOWER_TRAILING_CORNER", this.theButton);
        Component component = this.theScrollPane.getViewport().getView();
        this.theComponent = component instanceof JComponent ? (JComponent)component : null;
    }

    private void uninstallFromScrollPane() {
        if (this.theScrollPane == null) {
            return;
        }
        if (this.thePopupMenu.isVisible()) {
            this.thePopupMenu.setVisible(false);
        }
        this.theScrollPane.setCorner("LOWER_TRAILING_CORNER", null);
        this.theScrollPane.removePropertyChangeListener(COMPONENT_ORIENTATION, this.theComponentOrientationListener);
        this.theScrollPane.getViewport().removeContainerListener(this.theViewPortViewListener);
        this.theScrollPane.setLayout(this.theFormerLayoutManager);
        this.theScrollPane = null;
    }

    private void display(Point point) {
        if (this.theComponent == null) {
            return;
        }
        double d = this.theComponent.getWidth();
        double d2 = this.theComponent.getHeight();
        double d3 = 200.0 / d;
        double d4 = 200.0 / d2;
        this.theScale = Math.min(d3, d4);
        this.theImage = new BufferedImage(Math.max(1, (int)((double)this.theComponent.getWidth() * this.theScale)), Math.max(1, (int)((double)this.theComponent.getHeight() * this.theScale)), 1);
        Graphics2D graphics2D = this.theImage.createGraphics();
        if (this.theComponent instanceof ScrollPaneSelectable) {
            ((ScrollPaneSelectable)((Object)this.theComponent)).paintPreview(graphics2D, this.theScale);
        } else {
            graphics2D.scale(this.theScale, this.theScale);
            this.theComponent.paint(graphics2D);
        }
        this.theStartRectangle = this.theComponent.getVisibleRect();
        Insets insets = this.getInsets();
        this.theStartRectangle.x = (int)(this.theScale * (double)this.theStartRectangle.x + (double)insets.left);
        this.theStartRectangle.y = (int)(this.theScale * (double)this.theStartRectangle.y + (double)insets.right);
        this.theStartRectangle.width = (int)((double)this.theStartRectangle.width * this.theScale);
        this.theStartRectangle.height = (int)((double)this.theStartRectangle.height * this.theScale);
        this.theRectangle = this.theStartRectangle;
        Dimension dimension = this.thePopupMenu.getPreferredSize();
        Point point2 = this.theButton.getLocationOnScreen();
        Point point3 = new Point((this.theButton.getWidth() - dimension.width) / 2, (this.theButton.getHeight() - dimension.height) / 2);
        Point point4 = new Point(point2.x + point3.x + this.theRectangle.x + this.theRectangle.width / 2, point2.y + point3.y + this.theRectangle.y + this.theRectangle.height / 2);
        try {
            new Robot().mouseMove(point4.x, point4.y);
            this.theStartPoint = point4;
        }
        catch (Exception exception) {
            this.theStartPoint = point;
            point3.x += this.theStartPoint.x - point4.x;
            point3.y += this.theStartPoint.y - point4.y;
        }
        this.thePopupMenu.show(this.theButton, point3.x, point3.y);
    }

    private void moveRectangle(int n, int n2) {
        if (this.theStartRectangle == null) {
            return;
        }
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(this.theStartRectangle);
        rectangle.x += n;
        rectangle.y += n2;
        rectangle.x = Math.min(Math.max(rectangle.x, insets.left), this.getWidth() - insets.right - rectangle.width);
        rectangle.y = Math.min(Math.max(rectangle.y, insets.right), this.getHeight() - insets.bottom - rectangle.height);
        Rectangle rectangle2 = new Rectangle();
        Rectangle.union(this.theRectangle, rectangle, rectangle2);
        rectangle2.grow(2, 2);
        this.theRectangle = rectangle;
        this.paintImmediately(rectangle2);
    }

    private void scroll(int n, int n2) {
        if (this.theComponent == null) {
            return;
        }
        Rectangle rectangle = this.theComponent.getVisibleRect();
        rectangle.x += n;
        rectangle.y += n2;
        this.theComponent.scrollRectToVisible(rectangle);
        this.thePopupMenu.setVisible(false);
    }
}

