/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing.actions;

import info.bioinfweb.commons.swing.ExtendedAbstractAction;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;

public class OpenWebsiteAction
extends ExtendedAbstractAction {
    private URI url;

    protected static URI createURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError(uRISyntaxException);
        }
    }

    public OpenWebsiteAction(String string, String string2) {
        this(OpenWebsiteAction.createURI(string), string2);
    }

    public OpenWebsiteAction(String string) {
        this(OpenWebsiteAction.createURI(string));
    }

    public OpenWebsiteAction(URI uRI, String string) {
        super(string);
        this.url = uRI;
    }

    public OpenWebsiteAction(URI uRI) {
        this.url = uRI;
    }

    public URI getURL() {
        return this.url;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Desktop.getDesktop().browse(this.getURL());
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "The website could not be opened due to the following error: " + iOException.getLocalizedMessage(), "Could not open website", 0);
        }
    }
}

