/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing;

import info.bioinfweb.commons.changemonitor.ChangeMonitorable;
import info.bioinfweb.commons.io.AbstractSaver;
import info.bioinfweb.commons.io.Savable;
import info.bioinfweb.commons.swing.SwingSaverMessages;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class SwingSaver
extends AbstractSaver
implements ChangeMonitorable,
Savable {
    private SwingSaverMessages messages = new SwingSaverMessages();
    private JFileChooser fileChooser = null;

    public SwingSaver() {
    }

    public SwingSaver(String string) {
        this.setDefaultName(string);
    }

    public boolean askToSave() {
        return this.askToSave(null);
    }

    public boolean askToSave(Component component) {
        if (this.hasChanged()) {
            int n = JOptionPane.showOptionDialog(component, this.messages.getAskToSaveMessageBeginnung() + "\"" + this.getDefaultNameOrPath() + "\"" + this.messages.getAskToSaveMessageEnd(), this.messages.getAskToSaveTitle(), 1, 3, null, null, null);
            if (n == 0) {
                return this.save();
            }
            return n != 2 && n != -1;
        }
        return true;
    }

    public boolean saveAs() {
        return this.saveAs(null);
    }

    public boolean saveAs(Component component) {
        boolean bl;
        this.fileChooser.setSelectedFile(new File(this.getDefaultNameOrPath()));
        boolean bl2 = bl = this.fileChooser.showSaveDialog(component) == 0;
        if (bl) {
            File file = this.endsWithValidExt(this.fileChooser.getSelectedFile().getName()) ? this.fileChooser.getSelectedFile() : new File(this.fileChooser.getSelectedFile().getAbsolutePath() + this.getDefaultExtension());
            if (file.exists()) {
                boolean bl3 = bl = JOptionPane.showConfirmDialog(null, "The file \"" + file.getAbsolutePath() + "\" already exists.\nDo you want to overwrite it?", "Overwrite file", 0, 2) == 0;
            }
            if (bl) {
                this.setFile(file);
                return this.save();
            }
        }
        return bl;
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }
}

