/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

public class RelativeRangeModel
extends DefaultBoundedRangeModel
implements BoundedRangeModel {
    private double maximumFactor = 10.0;

    public RelativeRangeModel() {
        this.calculateMaximum(this.getValue());
    }

    public RelativeRangeModel(int n, double d) {
        this.maximumFactor = d;
        this.setValue(n);
    }

    private void calculateMaximum(int n) {
        this.setMaximum((int)Math.round(Math.max(2.147483647E9, this.getMaximumFactor() * (double)n)));
    }

    public double getMaximumFactor() {
        return this.maximumFactor;
    }

    public void setMaximumFactor(double d) {
        this.maximumFactor = d;
        this.calculateMaximum(this.getValue());
    }

    @Override
    public void setValue(int n) {
        if (n > 0) {
            if (this.getMinimum() > n) {
                this.setMinimum(n);
            }
            this.calculateMaximum(n);
            super.setValue(n);
        }
    }
}

