/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing;

import info.bioinfweb.commons.progress.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProgressDialog
extends JDialog
implements ProgressMonitor {
    private static final long serialVersionUID = 1L;
    public static final DecimalFormat DEFAULT_PROGRESS_FORMAT = new DecimalFormat("0.00 %");
    private static final int MIN_DIALOG_WITH = 350;
    private static final int PROGRESS_BAR_LENGTH = 1000;
    private static final double MIN_DISPLAY_INTERVAL = 0.005;
    private double progress = 0.0;
    private double displayedProgress = 0.0;
    private String currentText = "";
    private boolean canceled = false;
    private boolean showText = true;
    private DecimalFormat progressFormat;
    private final JPanel contentPanel = new JPanel();
    private JProgressBar progressBar = null;
    private JLabel label = null;
    private JButton cancelButton = null;

    public ProgressDialog(Window window, String string) {
        this(window, string, DEFAULT_PROGRESS_FORMAT);
    }

    public ProgressDialog(Window window, String string, DecimalFormat decimalFormat) {
        this(window, string, decimalFormat, true);
    }

    public ProgressDialog(Window window, String string, DecimalFormat decimalFormat, boolean bl) {
        this(window, string, decimalFormat, bl, "Cancel");
    }

    public ProgressDialog(Window window, String string, DecimalFormat decimalFormat, boolean bl, String string2) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.showText = bl;
        this.progressFormat = decimalFormat == null ? DEFAULT_PROGRESS_FORMAT : decimalFormat;
        this.init(string2);
    }

    private void init(String string) {
        GridBagConstraints gridBagConstraints;
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{146, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 19, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gridBagLayout);
        if (this.showText) {
            this.label = this.getLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.contentPanel.add((Component)this.label, gridBagConstraints);
        }
        this.progressBar = this.getProgressBar();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.contentPanel.add((Component)this.progressBar, gridBagConstraints);
        if (string != null) {
            this.cancelButton = new JButton(string);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressDialog.this.canceled = true;
                }
            });
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 3;
            this.contentPanel.add((Component)this.cancelButton, gridBagConstraints2);
        }
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setSize(Math.max(this.getSize().width, 350), this.getSize().height);
        this.setLocationRelativeTo(this.getOwner());
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setMinimum(0);
            this.progressBar.setStringPainted(true);
            this.progressBar.setMaximum(1000);
        }
        return this.progressBar;
    }

    protected JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel("Text");
        }
        return this.label;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    public double getProgressValue() {
        return this.progress;
    }

    public String getProgressText() {
        return this.currentText;
    }

    public void setProgressValue(double d) {
        this.setProgressValue(d, this.currentText);
    }

    public synchronized void setProgressValue(double d, String string) {
        this.currentText = string;
        if (this.progress != d) {
            this.progress = Math.max(0.0, Math.min(1.0, d));
            if (Math.abs(this.progress - this.displayedProgress) >= 0.005 || this.progress == 1.0) {
                this.displayedProgress = this.progress;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressDialog.this.getProgressBar().setValue((int)Math.round(ProgressDialog.this.progress * 1000.0));
                        ProgressDialog.this.getProgressBar().setString(ProgressDialog.this.progressFormat.format(ProgressDialog.this.progress));
                        ProgressDialog.this.getLabel().setText(ProgressDialog.this.currentText);
                    }
                });
            }
        }
    }

    public void addToProgressValue(double d) {
        this.setProgressValue(this.progress + d);
    }

    public void addToProgressValue(double d, String string) {
        this.setProgressValue(this.progress + d, string);
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

