/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing;

import java.util.Collections;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class LocaleComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private Vector<ComparableLocale> items = new Vector();
    private int selected = 0;

    public LocaleComboBoxModel() {
        this.fillList(Locale.getAvailableLocales());
    }

    public LocaleComboBoxModel(Locale[] localeArray) {
        this.fillList(localeArray);
    }

    private void fillList(Locale[] localeArray) {
        for (Locale locale : localeArray) {
            this.items.add(new ComparableLocale(locale));
        }
        Collections.sort(this.items);
        this.fireContentsChanged(this, 0, this.items.size() - 1);
    }

    @Override
    public String getElementAt(int n) {
        return this.getLocaleAt(n).getDisplayName();
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public String getSelectedItem() {
        return this.getSelectedLocale().getDisplayName();
    }

    @Override
    public void setSelectedItem(Object object) {
        int n;
        String string = object.toString();
        for (n = 0; n < this.items.size() && !this.items.get(n).getName().equals(string); ++n) {
        }
        if (n >= this.items.size()) {
            throw new IllegalArgumentException("The specified element \"" + string + "\"is not in the list.");
        }
        this.selected = n;
        this.fireContentsChanged(this, 0, this.items.size() - 1);
    }

    public Locale getLocaleAt(int n) {
        return this.items.get(n).getLocale();
    }

    public Locale getSelectedLocale() {
        if (this.items.size() == 0) {
            return null;
        }
        return this.items.get(this.selected).getLocale();
    }

    public void setSelectedLocale(Locale locale) {
        int n;
        for (n = 0; n < this.items.size() && !this.items.get(n).equals(locale); ++n) {
        }
        if (n >= this.items.size()) {
            throw new IllegalArgumentException("The specified element is not in the list.");
        }
        this.selected = n;
        this.fireContentsChanged(this, 0, this.items.size() - 1);
    }

    private class ComparableLocale
    implements Comparable<ComparableLocale> {
        private Locale locale;

        public ComparableLocale(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getName() {
            return this.getLocale().getDisplayName();
        }

        @Override
        public int compareTo(ComparableLocale comparableLocale) {
            return this.getName().compareTo(comparableLocale.getName());
        }
    }
}

