/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;

public class FileChooserDirModel {
    private Vector<JFileChooser> fileChoosers = new Vector();
    private Listener listener = new Listener();
    private File currentDirectory = null;
    private boolean saveCanceled = true;

    public FileChooserDirModel() {
    }

    public FileChooserDirModel(File file) {
        this.currentDirectory = file;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
        for (int i = 0; i < this.fileChoosers.size(); ++i) {
            this.fileChoosers.get(i).setCurrentDirectory(file);
        }
    }

    public boolean isSaveCanceled() {
        return this.saveCanceled;
    }

    public void setSaveCanceled(boolean bl) {
        this.saveCanceled = bl;
    }

    public boolean contains(JFileChooser jFileChooser) {
        return this.fileChoosers.contains(jFileChooser);
    }

    public void addFileChooser(JFileChooser jFileChooser) {
        jFileChooser.setCurrentDirectory(this.getCurrentDirectory());
        jFileChooser.addActionListener(this.listener);
        this.fileChoosers.add(jFileChooser);
    }

    public void removeFileChooser(JFileChooser jFileChooser) {
        jFileChooser.removeActionListener(this.listener);
        this.fileChoosers.remove(jFileChooser);
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FileChooserDirModel.this.fileChoosers.contains(actionEvent.getSource()) && (actionEvent.getActionCommand().equals("ApproveSelection") || actionEvent.getActionCommand().equals("CancelSelection") && FileChooserDirModel.this.saveCanceled)) {
                FileChooserDirModel.this.setCurrentDirectory(((JFileChooser)actionEvent.getSource()).getCurrentDirectory());
            }
        }
    }
}

