/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing;

import info.bioinfweb.commons.swing.DecimalInput;
import info.bioinfweb.commons.swing.OkCancelApplyDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class DecimalInputDialog
extends OkCancelApplyDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel inputPanel = null;
    private DecimalInput decimalInput = null;

    public DecimalInputDialog(Frame frame) {
        super(frame, true);
        this.initialize();
        this.setLocationRelativeTo(frame);
    }

    public DecimalInputDialog(Dialog dialog) {
        super(dialog, true);
        this.initialize();
        this.setLocationRelativeTo(dialog);
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private void initExecute(String string, String string2, String string3) {
        this.getDecimalInput().getLabel().setText(string);
        this.setTitle(string2);
        this.getDecimalInput().setDecimalFormatStr(string3);
    }

    public boolean execute(String string, String string2, double d, String string3) {
        this.initExecute(string, string2, string3);
        this.getDecimalInput().setValue(d);
        return this.execute();
    }

    public boolean execute(String string, String string2, long l, String string3) {
        this.initExecute(string, string2, string3);
        this.getDecimalInput().setValue(l);
        return this.execute();
    }

    public long getLongValue() {
        return this.getDecimalInput().parseLong();
    }

    public int getIntValue() {
        return this.getDecimalInput().parseInt();
    }

    public float getFloatValue() {
        return this.getDecimalInput().parseFloat();
    }

    public double getDoubleValue() {
        return this.getDecimalInput().parseDouble();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getInputPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            this.decimalInput = new DecimalInput("Enter a value", this.inputPanel, 0, "#.##########");
        }
        return this.inputPanel;
    }

    public DecimalInput getDecimalInput() {
        this.getInputPanel();
        return this.decimalInput;
    }
}

