/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.swing.SwingChangeMonitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class DecimalInput {
    public static final String DOUBLE_FORMAT = "#.##########";
    public static final String FLOAT_FORMAT = "#.#######";
    public static final String INTEGER_FORMAT = "#";
    private JLabel label = null;
    private JFormattedTextField textField = null;
    private JSlider slider = null;
    private DecimalFormat decimalFormat = null;
    private double valuesPerTick = 1.0;
    private SwingChangeMonitor changeMonitor = new SwingChangeMonitor();

    public DecimalInput(String string, JPanel jPanel, int n, String string2) {
        this(string, jPanel, 0, n, string2, true);
    }

    public DecimalInput(String string, JPanel jPanel, int n, int n2, String string2) {
        this(string, jPanel, n, n2, string2, true);
    }

    public DecimalInput(String string, JPanel jPanel, int n, int n2, String string2, boolean bl) {
        this.decimalFormat = new DecimalFormat(string2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.label = new JLabel(string);
        jPanel.add((Component)this.getLabel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = 4.0;
        jPanel.add((Component)this.getTextField(), gridBagConstraints);
        if (bl) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = n2 + 1;
            gridBagConstraints.weightx = 4.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = n + 1;
            jPanel.add((Component)this.getSlider(), gridBagConstraints);
        }
        this.setValue(1);
        this.setValue(0);
        this.getTextField().getDocument().addDocumentListener(this.changeMonitor);
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JFormattedTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JFormattedTextField(this.decimalFormat);
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (Character.isDigit(keyEvent.getKeyChar()) || keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                        try {
                            DecimalInput.this.setSliderValue(DecimalInput.this.parseDouble());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return this.textField;
    }

    private JSlider getSlider() {
        if (this.slider == null) {
            this.slider = new JSlider();
            this.slider.setPaintLabels(true);
            this.slider.setPaintTicks(true);
            this.slider.setMinorTickSpacing(1);
            this.slider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    DecimalInput.this.setValue((double)DecimalInput.this.getSlider().getValue() * DecimalInput.this.valuesPerTick);
                }
            });
        }
        return this.slider;
    }

    public SwingChangeMonitor getChangeMonitor() {
        return this.changeMonitor;
    }

    public void setEnabled(boolean bl) {
        this.getLabel().setEnabled(bl);
        this.getTextField().setEnabled(bl);
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormatStr(String string) {
        this.decimalFormat = new DecimalFormat(string);
    }

    public float parseFloat() {
        return Math2.parseFloat((String)this.getTextField().getText());
    }

    public double parseDouble() {
        return Math2.parseDouble((String)this.getTextField().getText());
    }

    public int parseInt() {
        return Integer.parseInt(this.getTextField().getText());
    }

    public long parseLong() {
        return Long.parseLong(this.getTextField().getText());
    }

    protected Hashtable<Integer, JLabel> createLabelTable(int n, int n2, double d) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= n; i += n2) {
            hashtable.put(new Integer(i), new JLabel(this.getDecimalFormat().format((double)i / (double)n * d)));
        }
        return hashtable;
    }

    private void setSliderValue(double d) {
        this.getSlider().setPaintLabels(false);
        double d2 = Math.pow(10.0, Math.ceil(Math.log10(10.0 * d)));
        if (d2 == 0.0) {
            d2 = (double)this.getSlider().getMaximum() * this.valuesPerTick;
        } else {
            if (10.0 * d <= 0.3 * d2) {
                d2 *= 0.3;
                this.getSlider().setMaximum(300);
                this.getSlider().setMinorTickSpacing(10);
                this.getSlider().setMajorTickSpacing(50);
            } else {
                this.getSlider().setMaximum(400);
                this.getSlider().setMinorTickSpacing(4);
                this.getSlider().setMajorTickSpacing(40);
            }
            this.valuesPerTick = d2 / (double)this.getSlider().getMaximum();
            this.getSlider().setLabelTable(this.createLabelTable(this.getSlider().getMaximum(), this.getSlider().getMajorTickSpacing(), d2));
        }
        this.getSlider().setPaintLabels(true);
        this.getSlider().setValue((int)Math.max(0L, Math.min((long)this.getSlider().getMaximum(), Math.round(d / d2 * (double)this.getSlider().getMaximum()))));
    }

    public void setValue(float f) {
        this.getTextField().setText(this.getDecimalFormat().format(f));
        this.setSliderValue(f);
    }

    public void setValue(double d) {
        this.getTextField().setText(this.getDecimalFormat().format(d));
        this.setSliderValue(d);
    }

    public void setValue(int n) {
        this.getTextField().setText(this.getDecimalFormat().format(n));
        this.setSliderValue(n);
    }

    public void setValue(long l) {
        this.getTextField().setText(this.getDecimalFormat().format(l));
        this.setSliderValue(l);
    }
}

