/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.swing;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class AccessibleUndoManager
extends UndoManager {
    public int firstUndoPosition() {
        UndoableEdit undoableEdit = this.editToBeUndone();
        if (undoableEdit != null) {
            return this.edits.indexOf(undoableEdit);
        }
        return -1;
    }

    public int firstRedoPosition() {
        UndoableEdit undoableEdit = this.editToBeRedone();
        if (undoableEdit != null) {
            return this.edits.indexOf(undoableEdit);
        }
        return -1;
    }

    public int undoCount() {
        return this.firstUndoPosition() + 1;
    }

    public int redoCount() {
        int n = this.firstRedoPosition();
        if (n == -1) {
            return 0;
        }
        return this.edits.size() - n;
    }

    public UndoableEdit getEdit(int n) {
        return (UndoableEdit)this.edits.get(n);
    }

    public UndoableEdit getUndoEdit(int n) {
        int n2 = this.firstUndoPosition();
        if (n2 == -1) {
            throw new IndexOutOfBoundsException("There no undo edits in the list.");
        }
        return (UndoableEdit)this.edits.get(n2 - n);
    }

    public UndoableEdit getRedoEdit(int n) {
        int n2 = this.firstRedoPosition();
        if (n2 == -1) {
            throw new IndexOutOfBoundsException("There no undo edits in the list.");
        }
        return (UndoableEdit)this.edits.get(n2 + n);
    }

    @Override
    public void redoTo(UndoableEdit undoableEdit) throws CannotRedoException {
        super.redoTo(undoableEdit);
    }

    @Override
    public void undoTo(UndoableEdit undoableEdit) throws CannotUndoException {
        super.undoTo(undoableEdit);
    }

    public boolean contains(UndoableEdit undoableEdit) {
        return this.edits.contains(undoableEdit);
    }
}

