/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.log;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.commons.log.ApplicationLoggerMessage;
import info.bioinfweb.commons.log.JTextAreaApplicationLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ApplicationLoggerDialog
extends JDialog
implements ApplicationLogger {
    private static final long serialVersionUID = 1L;
    private ApplicationLogger logger = null;
    private JPanel jContentPane = null;
    private JScrollPane messagesScrollPane = null;
    private JPanel buttonsPanel = null;
    private JButton closeButton = null;
    private JTextArea textArea;

    public ApplicationLoggerDialog(Frame frame) {
        super(frame, true);
        this.initialize();
    }

    public void addMessage(ApplicationLoggerMessage applicationLoggerMessage) {
        this.getLogger().addMessage(applicationLoggerMessage);
    }

    public void addMessage(String string, int n) {
        this.getLogger().addMessage(string, n);
    }

    public void addMessage(String string) {
        this.getLogger().addMessage(string);
    }

    public void addWarning(String string, int n) {
        this.getLogger().addWarning(string, n);
    }

    public void addWarning(String string) {
        this.getLogger().addWarning(string);
    }

    public void addError(String string) {
        this.getLogger().addError(string);
    }

    public void addError(String string, int n) {
        this.getLogger().addError(string, n);
    }

    public void addError(Throwable throwable, boolean bl) {
        this.getLogger().addError(throwable, bl);
    }

    public void addError(Throwable throwable, boolean bl, int n) {
        this.getLogger().addError(throwable, bl, n);
    }

    public void clearMessages() {
        this.getTextArea().setText("");
    }

    public void display() {
        if (this.getTextArea().getText().length() > 0) {
            this.setLocationRelativeTo(this.getOwner());
            this.setVisible(true);
        }
    }

    private void initialize() {
        this.setTitle("Log messages");
        this.setSize(new Dimension(600, 400));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gridBagLayout.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
            this.jContentPane.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.jContentPane.add((Component)this.getMessagesScrollPane(), gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 15;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            this.jContentPane.add((Component)this.getButtonsPanel(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    private JScrollPane getMessagesScrollPane() {
        if (this.messagesScrollPane == null) {
            this.messagesScrollPane = new JScrollPane();
            this.messagesScrollPane.setViewportView(this.getTextArea());
        }
        return this.messagesScrollPane;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new FlowLayout());
            this.buttonsPanel.setEnabled(false);
            this.buttonsPanel.add((Component)this.getCloseButton(), null);
        }
        return this.buttonsPanel;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationLoggerDialog.this.clearMessages();
                    ApplicationLoggerDialog.this.setVisible(false);
                }
            });
        }
        return this.closeButton;
    }

    public ApplicationLogger getLogger() {
        if (this.logger == null) {
            this.logger = new JTextAreaApplicationLogger(this.getTextArea());
        }
        return this.logger;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
            this.textArea.setEditable(false);
        }
        return this.textArea;
    }
}

