/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.scrollpaneselector;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ScrollPaneBidule
extends JComponent {
    private static final double MAX_SIZE = 200.0;
    private JScrollPane theScrollPane;
    private JComponent theComponent;
    private JPopupMenu thePopupMenu;
    private JButton theButton;
    private BufferedImage theImage;
    private Rectangle theStartRectangle;
    private Rectangle theRectangle;
    private Point theStartPoint;
    private double theScale;

    public ScrollPaneBidule(JScrollPane aScrollPane) {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.theScrollPane = aScrollPane;
        this.theComponent = (JComponent)this.theScrollPane.getViewport().getView();
        this.theImage = null;
        this.theStartRectangle = null;
        this.theRectangle = null;
        this.theStartPoint = null;
        this.theScale = 0.0;
        this.theButton = new JButton(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollPaneBidule.this.display();
            }
        });
        this.theScrollPane.setCorner("LOWER_RIGHT_CORNER", this.theButton);
        this.setCursor(Cursor.getPredefinedCursor(13));
        MouseInputAdapter mil = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ScrollPaneBidule.this.theStartPoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ScrollPaneBidule.this.theStartPoint != null) {
                    Point newPoint = e.getPoint();
                    int deltaX = (int)((double)(newPoint.x - ((ScrollPaneBidule)ScrollPaneBidule.this).theStartPoint.x) / ScrollPaneBidule.this.theScale);
                    int deltaY = (int)((double)(newPoint.y - ((ScrollPaneBidule)ScrollPaneBidule.this).theStartPoint.y) / ScrollPaneBidule.this.theScale);
                    ScrollPaneBidule.this.scroll(deltaX, deltaY);
                }
                ScrollPaneBidule.this.theStartPoint = null;
                ScrollPaneBidule.this.theStartRectangle = ScrollPaneBidule.this.theRectangle;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ScrollPaneBidule.this.theStartPoint == null) {
                    return;
                }
                Point newPoint = e.getPoint();
                ScrollPaneBidule.this.moveRectangle(newPoint.x - ((ScrollPaneBidule)ScrollPaneBidule.this).theStartPoint.x, newPoint.y - ((ScrollPaneBidule)ScrollPaneBidule.this).theStartPoint.y);
            }
        };
        this.addMouseListener(mil);
        this.addMouseMotionListener(mil);
        this.thePopupMenu = new JPopupMenu();
        this.thePopupMenu.setLayout(new BorderLayout());
        this.thePopupMenu.add((Component)this, "Center");
        this.thePopupMenu.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    @Override
    protected void paintComponent(Graphics g1D) {
        if (this.theImage == null || this.theRectangle == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1D;
        Insets insets = this.getInsets();
        int xOffset = insets.left;
        int yOffset = insets.top;
        int availableWidth = this.getWidth() - insets.left - insets.right;
        int availableHeight = this.getHeight() - insets.top - insets.bottom;
        g.drawImage((Image)this.theImage, xOffset, yOffset, null);
        Color tmpColor = g.getColor();
        Area area = new Area(new Rectangle(xOffset, yOffset, availableWidth, availableHeight));
        area.subtract(new Area(this.theRectangle));
        g.setColor(new Color(255, 255, 255, 128));
        g.fill(area);
        g.setColor(Color.BLACK);
        g.draw(this.theRectangle);
        g.setColor(tmpColor);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.theImage == null || this.theRectangle == null) {
            return new Dimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this.theImage.getWidth(null) + insets.left + insets.right, this.theImage.getHeight(null) + insets.top + insets.bottom);
    }

    private void display() {
        double compWidth = this.theComponent.getWidth();
        double compHeight = this.theComponent.getHeight();
        double scaleX = 200.0 / compWidth;
        double scaleY = 200.0 / compHeight;
        this.theScale = Math.min(scaleX, scaleY);
        this.theImage = new BufferedImage((int)((double)this.theComponent.getWidth() * this.theScale), (int)((double)this.theComponent.getHeight() * this.theScale), 1);
        Graphics2D g = this.theImage.createGraphics();
        g.scale(this.theScale, this.theScale);
        this.theComponent.paint(g);
        this.theStartRectangle = this.theComponent.getVisibleRect();
        Insets insets = this.getInsets();
        this.theStartRectangle.x = (int)(this.theScale * (double)this.theStartRectangle.x + (double)insets.left);
        this.theStartRectangle.y = (int)(this.theScale * (double)this.theStartRectangle.y + (double)insets.right);
        this.theStartRectangle.width = (int)((double)this.theStartRectangle.width * this.theScale);
        this.theStartRectangle.height = (int)((double)this.theStartRectangle.height * this.theScale);
        this.theRectangle = this.theStartRectangle;
        Dimension pref = this.thePopupMenu.getPreferredSize();
        this.thePopupMenu.show(this.theButton, (this.theButton.getWidth() - pref.width) / 2, (this.theButton.getHeight() - pref.height) / 2);
        try {
            Robot robot = new Robot();
            Point centerPoint = new Point(this.theRectangle.x + this.theRectangle.width / 2, this.theRectangle.y + this.theRectangle.height / 2);
            SwingUtilities.convertPointToScreen(centerPoint, this);
            robot.mouseMove(centerPoint.x, centerPoint.y);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    private void moveRectangle(int aDeltaX, int aDeltaY) {
        if (this.theStartRectangle == null) {
            return;
        }
        Insets insets = this.getInsets();
        Rectangle newRect = new Rectangle(this.theStartRectangle);
        newRect.x += aDeltaX;
        newRect.y += aDeltaY;
        newRect.x = Math.min(Math.max(newRect.x, insets.left), this.getWidth() - insets.right - newRect.width);
        newRect.y = Math.min(Math.max(newRect.y, insets.right), this.getHeight() - insets.bottom - newRect.height);
        Rectangle clip = new Rectangle();
        Rectangle.union(this.theRectangle, newRect, clip);
        clip.grow(2, 2);
        this.theRectangle = newRect;
        this.paintImmediately(clip);
    }

    private void scroll(int aDeltaX, int aDeltaY) {
        JComponent component = (JComponent)this.theScrollPane.getViewport().getView();
        Rectangle rect = component.getVisibleRect();
        rect.x += aDeltaX;
        rect.y += aDeltaY;
        component.scrollRectToVisible(rect);
        this.thePopupMenu.setVisible(false);
    }
}

