/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.text;

import info.bioinfweb.commons.text.UniqueNameMapParameters;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class UniqueNameMap {
    private Map<String, String> nameMap = new TreeMap<String, String>();
    private UniqueNameMapParameters parameters;

    public UniqueNameMap(UniqueNameMapParameters uniqueNameMapParameters) {
        this.parameters = uniqueNameMapParameters;
    }

    public UniqueNameMapParameters getParameters() {
        return this.parameters;
    }

    protected Map<String, String> getMap() {
        return this.nameMap;
    }

    public String addName(String string) {
        UniqueNameMapParameters uniqueNameMapParameters = this.getParameters();
        String string2 = string;
        if (uniqueNameMapParameters.hasReplacements()) {
            for (String string3 : uniqueNameMapParameters.getReplacements().keySet()) {
                string2 = string.replaceAll(string3, uniqueNameMapParameters.getReplacements().get(string3));
            }
        }
        if (!uniqueNameMapParameters.isUnlimitedLength()) {
            if (string2.length() > uniqueNameMapParameters.getMaxNameLength()) {
                string2 = string2.substring(0, uniqueNameMapParameters.getMaxNameLength());
            } else if (string2.length() < uniqueNameMapParameters.getMaxNameLength() && uniqueNameMapParameters.isFillUp()) {
                StringBuffer stringBuffer = new StringBuffer(uniqueNameMapParameters.getMaxNameLength());
                stringBuffer.append(string2);
                while (stringBuffer.length() < uniqueNameMapParameters.getMaxNameLength()) {
                    stringBuffer.append(" ");
                }
                string2 = stringBuffer.toString();
            }
        }
        if (!string.equals(string2)) {
            int n = 1;
            while (this.getMap().containsKey(string2)) {
                String string3;
                string3 = "" + n;
                string2 = string2.substring(0, uniqueNameMapParameters.getMaxNameLength() - string3.length()) + string3;
                ++n;
            }
            this.getMap().put(string2, string);
        }
        return string2;
    }

    public void addNames(Collection<String> collection) {
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addName(iterator.next());
        }
    }

    public String getProcessedName(String string) {
        return this.nameMap.get(string);
    }

    public void clear() {
        this.nameMap.clear();
    }

    public boolean containsKey(Object object) {
        return this.nameMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.nameMap.containsValue(object);
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.nameMap.entrySet();
    }

    public boolean isEmpty() {
        return this.nameMap.isEmpty();
    }

    public Set<String> keySet() {
        return this.nameMap.keySet();
    }

    public String remove(Object object) {
        return this.nameMap.remove(object);
    }

    public int size() {
        return this.nameMap.size();
    }

    public Collection<String> values() {
        return this.nameMap.values();
    }

    public void writeNameMap(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        for (String string : this.nameMap.keySet()) {
            printWriter.println(string + "\t" + this.nameMap.get(string));
        }
        printWriter.flush();
    }

    public void writeNameMap(File file) throws FileNotFoundException, IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            this.writeNameMap(bufferedOutputStream);
        }
    }
}

