/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.text;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class StringUtils {
    public static final NumberFormat DOUBLE_FORMAT = NumberFormat.getNumberInstance(Locale.getDefault());
    public static final NumberFormat INTEGER_FORMAT = NumberFormat.getIntegerInstance(Locale.getDefault());
    private static final Pattern NO_WHITESPACE_PATTERN = Pattern.compile("\\S*");

    public static String invert(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            stringBuffer.append(charSequence.charAt(charSequence.length() - i - 1));
        }
        return stringBuffer.toString();
    }

    public static String repeat(CharSequence charSequence, int n) {
        StringBuffer stringBuffer = new StringBuffer(charSequence.length() + n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(charSequence);
        }
        return stringBuffer.toString();
    }

    public static void renameRepeatedEntries(String[] stringArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Integer n = (Integer)hashMap.get(string);
            if (n == null) {
                n = 1;
            } else {
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
                stringArray[i] = string + " (" + n + ")";
            }
            hashMap.put(string, n);
        }
    }

    public static void renameRepeatedEntries(List<String> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            Integer n = (Integer)hashMap.get(string);
            if (n == null) {
                n = 1;
            } else {
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
                list.set(i, string + " (" + n + ")");
            }
            hashMap.put(string, n);
        }
    }

    public static String concatWithOperator(String string, String string2, String string3, String string4, String string5) {
        String string6 = !string.equals("") && !string2.equals("") ? string4 + string + string3 + string2 + string5 : string + string2;
        return string6;
    }

    public static String concatWithOperator(String string, String string2, String string3) {
        return StringUtils.concatWithOperator(string, string2, string3, "", "");
    }

    public static String firstCharToLowerCase(String string) {
        if (string.length() > 1) {
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        return string.toLowerCase();
    }

    public static String firstCharToUpperCase(String string) {
        if (string.length() > 1) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string.toUpperCase();
    }

    public static String convertCamelCase(String string, String string2) {
        if (string.length() > 1) {
            StringBuffer stringBuffer = new StringBuffer(string.length() * (string2.length() + 1) / 5);
            stringBuffer.append(Character.toLowerCase(string.charAt(0)));
            for (int i = 1; i < string.length(); ++i) {
                if (Character.isUpperCase(string.charAt(i))) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(Character.toLowerCase(string.charAt(i)));
            }
            return stringBuffer.toString();
        }
        return string.toLowerCase();
    }

    public static boolean isNewLineChar(char c) {
        return c == '\n' || c == '\r';
    }

    public static int indexOfWhiteSpace(CharSequence charSequence) {
        return StringUtils.indexOfWhiteSpace(charSequence, 0);
    }

    public static int indexOfWhiteSpace(CharSequence charSequence, int n) {
        for (int i = n; i < charSequence.length(); ++i) {
            if (!Character.isWhitespace(charSequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsWhitespace(CharSequence charSequence) {
        return !NO_WHITESPACE_PATTERN.matcher(charSequence).matches();
    }

    public static boolean endsWith(CharSequence charSequence, char c) {
        return charSequence.length() == 0 || charSequence.charAt(charSequence.length() - 1) == c;
    }

    public static CharSequence cutEnd(CharSequence charSequence, int n) {
        if (n > charSequence.length()) {
            return "";
        }
        return charSequence.subSequence(0, charSequence.length() - n);
    }

    public static String cutEnd(String string, int n) {
        if (n > string.length()) {
            return "";
        }
        return string.substring(0, string.length() - n);
    }

    public static char lastChar(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            throw new IllegalArgumentException("The specified character sequence needs to be at least one character long.");
        }
        return charSequence.charAt(charSequence.length() - 1);
    }

    public static List<String> charSequenceToStringList(CharSequence charSequence) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < charSequence.length(); ++i) {
            arrayList.add(Character.toString(charSequence.charAt(i)));
        }
        return arrayList;
    }
}

