/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.log;

import info.bioinfweb.commons.log.ApplicationLoggerMessageType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ApplicationLoggerMessage {
    public static final int NO_HELP_CODE = -1;
    public static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ApplicationLoggerMessageType type = null;
    private Date time = new Date(System.currentTimeMillis());
    private String message = "";
    private int helpCode = -1;

    public ApplicationLoggerMessage(ApplicationLoggerMessageType applicationLoggerMessageType, String string) {
        this(applicationLoggerMessageType, string, -1);
    }

    public ApplicationLoggerMessage(ApplicationLoggerMessageType applicationLoggerMessageType, String string, int n) {
        this.type = applicationLoggerMessageType;
        this.message = string;
        this.helpCode = n;
    }

    public ApplicationLoggerMessageType getType() {
        return this.type;
    }

    public void setType(ApplicationLoggerMessageType applicationLoggerMessageType) {
        this.type = applicationLoggerMessageType;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date date) {
        this.time = date;
    }

    public void setTime(long l) {
        this.time = new Date(l);
    }

    public void setTimeToNow() {
        this.time = new Date(System.currentTimeMillis());
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public int getHelpCode() {
        return this.helpCode;
    }

    public void setHelpCode(int n) {
        this.helpCode = n;
    }

    public boolean hasHelpCode() {
        return this.getHelpCode() != -1;
    }

    public String toString() {
        String string = this.getMessage();
        if (!this.getType().equals((Object)ApplicationLoggerMessageType.MESSAGE)) {
            string = this.getType().toString() + ": " + string;
        }
        return TIME_FORMAT.format(this.getTime()) + " " + string;
    }
}

